/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.iot.integration.user;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import junit.framework.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.iot.integration.common.AssertUtil;
import org.wso2.iot.integration.common.PayloadGenerator;
import org.wso2.iot.integration.common.RestClient;
import org.wso2.iot.integration.common.TestBase;

public class UserManagement
extends TestBase {
    private String NON_EXISTING_USERNAME = "non_exiting";
    private RestClient client;

    @Factory(dataProvider="userModeProvider")
    public UserManagement(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true, groups={"user-mgt"})
    public void initTest() throws Exception {
        super.init(this.userMode);
        this.client = new RestClient(this.backendHTTPSURL, "application/json", this.accessTokenString);
    }

    @Test(description="Test add user.")
    public void testAddUser() throws Exception {
        HttpResponse response = this.client.post("/api/device-mgt/v1.0/users", PayloadGenerator.getJsonPayload((String)"user-payloads.json", (String)"POST").toString());
        Assert.assertEquals((int)201, (int)response.getResponseCode());
        AssertUtil.jsonPayloadCompare((String)PayloadGenerator.getJsonPayload((String)"user-response-payloads.json", (String)"POST").toString(), (String)response.getData(), (boolean)true);
    }

    @Test(description="Test update user.", dependsOnMethods={"testAddUser"})
    public void testUpdateUser() throws Exception {
        String url = "/api/device-mgt/v1.0/users/username123";
        HttpResponse response = this.client.put(url, PayloadGenerator.getJsonPayload((String)"user-payloads.json", (String)"PUT").toString());
        Assert.assertEquals((int)200, (int)response.getResponseCode());
        AssertUtil.jsonPayloadCompare((String)PayloadGenerator.getJsonPayload((String)"user-response-payloads.json", (String)"PUT").toString(), (String)response.getData(), (boolean)true);
    }

    @Test(description="Test view user.", dependsOnMethods={"testUpdateUser"})
    public void testViewUser() throws Exception {
        String url = "/api/device-mgt/v1.0/users/username123";
        HttpResponse response = this.client.get(url);
        Assert.assertEquals((int)200, (int)response.getResponseCode());
        AssertUtil.jsonPayloadCompare((String)PayloadGenerator.getJsonPayload((String)"user-response-payloads.json", (String)"GET").toString(), (String)response.getData(), (boolean)true);
    }

    @Test(description="Test getting user roles.", dependsOnMethods={"testViewUser"})
    public void testGetUserRoles() throws Exception {
        String url = "/api/device-mgt/v1.0/users/username123/roles";
        HttpResponse response = this.client.get(url);
        Assert.assertEquals((int)200, (int)response.getResponseCode());
        AssertUtil.jsonPayloadCompare((String)PayloadGenerator.getJsonPayload((String)"user-response-payloads.json", (String)"GET_ROLES").toString(), (String)response.getData(), (boolean)true);
        url = "/api/device-mgt/v1.0/users/" + this.NON_EXISTING_USERNAME + "/roles";
        response = this.client.get(url);
        Assert.assertEquals((int)404, (int)response.getResponseCode());
    }

    @Test(description="Test the API that checks whether user exist.", dependsOnMethods={"testGetUserRoles"})
    public void testIsUserExist() throws Exception {
        String url = "/api/device-mgt/v1.0/users/checkUser?username=username123";
        HttpResponse response = this.client.get(url);
        Assert.assertEquals((int)200, (int)response.getResponseCode());
        Assert.assertEquals((String)"CheckUser API return false even the user with the username username123exists", (boolean)true, (boolean)Boolean.parseBoolean(response.getData()));
        url = "/api/device-mgt/v1.0/users/checkUser?username=" + this.NON_EXISTING_USERNAME;
        response = this.client.get(url);
        Assert.assertEquals((int)200, (int)response.getResponseCode());
        Assert.assertEquals((String)("CheckUser API return true but user with " + this.NON_EXISTING_USERNAME + "exists"), (boolean)false, (boolean)Boolean.parseBoolean(response.getData()));
    }

    @Test(description="Test whether correct user count is returned.", dependsOnMethods={"testIsUserExist"})
    public void testUserCount() throws Exception {
        int expectedCount = this.userMode == TestUserMode.TENANT_ADMIN ? 4 : 15;
        String url = "/api/device-mgt/v1.0/users/count";
        HttpResponse response = this.client.get(url);
        Assert.assertEquals((int)200, (int)response.getResponseCode());
        JsonObject jsonElement = new JsonParser().parse(response.getData()).getAsJsonObject();
        Assert.assertEquals((String)"Actual user count does not match with the returned user count", (int)expectedCount, (int)jsonElement.get("count").getAsInt());
    }

    @Test(description="Test whether the API that is used to get the users returns all the user details.", dependsOnMethods={"testUserCount"})
    public void testGetUsers() throws Exception {
        int expectedCount = this.userMode == TestUserMode.TENANT_ADMIN ? 4 : 15;
        String url = "/api/device-mgt/v1.0/users/?offset=0&limit=100";
        HttpResponse response = this.client.get(url);
        Assert.assertEquals((int)200, (int)response.getResponseCode());
        JsonObject jsonElement = new JsonParser().parse(response.getData()).getAsJsonObject();
        Assert.assertEquals((String)"All the users list is not returned", (int)expectedCount, (int)jsonElement.get("users").getAsJsonArray().size());
    }

    @Test(description="Test whether the API that is used to get the users with particular filter returns all the user details that satisfy particular filter.", dependsOnMethods={"testGetUsers"})
    public void testSearchUserNames() throws Exception {
        String url = "/api/device-mgt/v1.0/users/search/usernames?filter=username123";
        HttpResponse response = this.client.get(url);
        Assert.assertEquals((int)200, (int)response.getResponseCode());
        JsonArray jsonArray = new JsonParser().parse(response.getData()).getAsJsonArray();
        Assert.assertEquals((String)"Relevant filtered user list in not returned correctly.", (int)1, (int)jsonArray.size());
        url = "/api/device-mgt/v1.0/users/search/usernames?filter=" + this.NON_EXISTING_USERNAME;
        response = this.client.get(url);
        Assert.assertEquals((int)200, (int)response.getResponseCode());
        jsonArray = new JsonParser().parse(response.getData()).getAsJsonArray();
        Assert.assertEquals((String)"Relevant filtered user list in not returned correctly. Return a list of users for non-existing username", (int)0, (int)jsonArray.size());
    }

    @Test(description="Test remove user.", dependsOnMethods={"testSearchUserNames"})
    public void testRemoveUser() throws Exception {
        String url = "/api/device-mgt/v1.0/users/username123";
        HttpResponse response = this.client.delete(url);
        Assert.assertEquals((int)200, (int)response.getResponseCode());
    }

    @Test(description="Test whether the API that is used to change the password works as expected.", dependsOnMethods={"testRemoveUser"})
    public void testChangePassword() throws Exception {
        String url = "/api/device-mgt/v1.0/users/credentials";
        HttpResponse response = this.client.put(url, PayloadGenerator.getJsonPayload((String)"user-payloads.json", (String)"RESET_PASSWORD").toString());
        Assert.assertEquals((int)200, (int)response.getResponseCode());
        Assert.assertEquals((String)"Password of the user cannot be changed", (String)"\"UserImpl password by username: admin was successfully changed.\"", (String)response.getData());
    }
}

