/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.iot.integration.role;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.FileNotFoundException;
import javax.xml.xpath.XPathExpressionException;
import junit.framework.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.iot.integration.common.AssertUtil;
import org.wso2.iot.integration.common.IOTHttpClient;
import org.wso2.iot.integration.common.IOTResponse;
import org.wso2.iot.integration.common.PayloadGenerator;
import org.wso2.iot.integration.common.TestBase;

public class RoleManagement
extends TestBase {
    private IOTHttpClient client;
    private static final String ROLE_NAME = "administration";

    @Factory(dataProvider="userModeProvider")
    public RoleManagement(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true, groups={"role-mgt"})
    public void initTest() throws Exception {
        super.init(this.userMode);
        this.client = new IOTHttpClient(this.backendHTTPSURL, "application/json", this.accessTokenString);
    }

    @Test(description="Test add role.")
    public void testAddRole() throws FileNotFoundException {
        IOTResponse response = this.client.post("/api/device-mgt/v1.0/roles", PayloadGenerator.getJsonPayload((String)"role-payloads.json", (String)"POST").toString());
        Assert.assertEquals((int)201, (int)response.getStatus());
    }

    @Test(description="Test update permission role.", dependsOnMethods={"testAddRole"})
    public void testUpdateRolePermission() throws FileNotFoundException {
        IOTResponse response = this.client.put("/api/device-mgt/v1.0/roles/administration", PayloadGenerator.getJsonPayload((String)"role-payloads.json", (String)"PUT").toString());
        Assert.assertEquals((int)200, (int)response.getStatus());
    }

    @Test(description="Test get roles.", dependsOnMethods={"testUpdateRolePermission"})
    public void testGetRoles() throws FileNotFoundException {
        IOTResponse response = this.client.get("/api/device-mgt/v1.0/roles?offset=0&limit=2");
        Assert.assertEquals((int)200, (int)response.getStatus());
        AssertUtil.jsonPayloadCompare((String)PayloadGenerator.getJsonPayload((String)"role-response-payloads.json", (String)"GET_ROLES").toString(), (String)response.getBody(), (boolean)true);
    }

    @Test(description="Test getting roles that has particular prefix.", dependsOnMethods={"testGetRoles"})
    public void testGetFilteredRoles() throws FileNotFoundException {
        IOTResponse response = this.client.get("/api/device-mgt/v1.0/roles/filter/administ?offset=0&limit=2");
        Assert.assertEquals((int)200, (int)response.getStatus());
        AssertUtil.jsonPayloadCompare((String)PayloadGenerator.getJsonPayload((String)"role-response-payloads.json", (String)"GET_FILTERED_ROLES").toString(), (String)response.getBody(), (boolean)true);
    }

    @Test(description="Test getting permissions of a role.", dependsOnMethods={"testGetFilteredRoles"})
    public void testGetRolePermissions() throws FileNotFoundException {
        IOTResponse response = this.client.get("/api/device-mgt/v1.0/roles/administration/permissions");
        Assert.assertEquals((int)200, (int)response.getStatus());
    }

    @Test(description="Test getting role details.", dependsOnMethods={"testGetRolePermissions"})
    public void testGetRole() throws FileNotFoundException {
        IOTResponse response = this.client.get("/api/device-mgt/v1.0/roles/administration");
        Assert.assertEquals((int)200, (int)response.getStatus());
    }

    @Test(description="Test updating users with a given role.", dependsOnMethods={"testGetRole"})
    public void testUpdateRolesOfUser() throws FileNotFoundException, XPathExpressionException {
        boolean isRoleNameExist = false;
        IOTResponse response = this.client.put("/api/device-mgt/v1.0/roles/administration/users", PayloadGenerator.getJsonArray((String)"role-payloads.json", (String)"UPDATE_USERS").toString());
        Assert.assertEquals((String)"Error while updating the user list for the role administration", (int)200, (int)response.getStatus());
        String url = "/api/device-mgt/v1.0/users/" + this.automationContext.getContextTenant().getContextUser().getUserNameWithoutDomain() + "/roles";
        response = this.client.get(url);
        JsonArray jsonArray = new JsonParser().parse(response.getBody()).getAsJsonObject().get("roles").getAsJsonArray();
        Assert.assertEquals((String)"Error while retrieving the role details", (int)200, (int)response.getStatus());
        for (JsonElement jsonElement : jsonArray) {
            if (!jsonElement.getAsString().equals(ROLE_NAME)) continue;
            isRoleNameExist = true;
            break;
        }
        if (!isRoleNameExist) {
            Assert.fail((String)"The user is not assigned with the new role administration");
        }
    }

    @Test(description="Test remove user.", dependsOnMethods={"testUpdateRolesOfUser"})
    public void testRemoveRole() throws Exception {
        IOTResponse response = this.client.delete("/api/device-mgt/v1.0/roles/administration");
        Assert.assertEquals((int)200, (int)response.getStatus());
    }
}

