/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.iot.integration.operation;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import junit.framework.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.iot.integration.common.AssertUtil;
import org.wso2.iot.integration.common.IOTHttpClient;
import org.wso2.iot.integration.common.IOTResponse;
import org.wso2.iot.integration.common.OAuthUtil;
import org.wso2.iot.integration.common.PayloadGenerator;
import org.wso2.iot.integration.common.RestClient;
import org.wso2.iot.integration.common.TestBase;

public class OperationManagement
extends TestBase {
    private JsonObject device;
    private IOTHttpClient client;
    private RestClient rclient;

    @BeforeClass(alwaysRun=true, groups={"api-policy-mgt"})
    public void initTest() throws Exception {
        super.init(TestUserMode.SUPER_TENANT_ADMIN);
        String accessTokenString = "Bearer " + OAuthUtil.getOAuthToken((String)this.backendHTTPSURL, (String)this.backendHTTPSURL);
        this.client = new IOTHttpClient(this.backendHTTPSURL, "application/json", accessTokenString);
        this.rclient = new RestClient(this.backendHTTPSURL, "application/json", accessTokenString);
    }

    @Test(description="Add an Android device.")
    public void testEnrollment() throws Exception {
        JsonObject enrollmentData = PayloadGenerator.getJsonPayload((String)"android-enrollment-payloads.json", (String)"POST");
        enrollmentData.addProperty("deviceIdentifier", "d24f870f390352a41234");
        IOTResponse response = this.client.post("/api/device-mgt/android/v1.0/devices", enrollmentData.toString());
        Assert.assertEquals((int)200, (int)response.getStatus());
        AssertUtil.jsonPayloadCompare((String)PayloadGenerator.getJsonPayload((String)"android-enrollment-response-payloads.json", (String)"POST").toString(), (String)response.getBody(), (boolean)true);
    }

    @Test(dependsOnMethods={"testEnrollment"}, description="Test Android install apps operation.")
    public void testInstallApps() throws Exception {
        JsonObject operationData = PayloadGenerator.getJsonPayload((String)"android-operation-payloads.json", (String)"install_apps");
        JsonArray deviceIds = new JsonArray();
        JsonPrimitive deviceID = new JsonPrimitive("d24f870f390352a41234");
        deviceIds.add((JsonElement)deviceID);
        operationData.add("deviceIDs", (JsonElement)deviceIds);
        HttpResponse response = this.rclient.post("install-application", operationData.toString());
        Assert.assertEquals((int)201, (int)response.getResponseCode());
    }

    @Test(dependsOnMethods={"testInstallApps"}, description="Test get device apps with wrong Device ID")
    public void testGetDeviceAppsWithWrongDeviceID() throws Exception {
        IOTResponse response = this.client.get("/mdm-admin/operations/android/1111/apps");
        Assert.assertEquals((int)500, (int)response.getStatus());
    }

    @Test(dependsOnMethods={"testInstallApps"}, description="Test get operations for device with wrong Device ID")
    public void testGetDeviceOperationsWithWrongDeviceID() throws Exception {
        IOTResponse response = this.client.get("/mdm-admin/operations/android/123123123");
        Assert.assertEquals((int)500, (int)response.getStatus());
    }
}

