/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.iot.integration.device.enrollment;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import junit.framework.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.iot.integration.common.AssertUtil;
import org.wso2.iot.integration.common.PayloadGenerator;
import org.wso2.iot.integration.common.RestClient;
import org.wso2.iot.integration.common.TestBase;

public class AndroidEnrollment
extends TestBase {
    private RestClient client;
    private String deviceId;

    @Factory(dataProvider="userModeProvider")
    public AndroidEnrollment(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true, groups={"user-mgt"})
    public void initTest() throws Exception {
        super.init(this.userMode);
        this.client = new RestClient(this.backendHTTPSURL, "application/json", this.accessTokenString);
    }

    @Test(description="Test an Android device enrollment.")
    public void testEnrollment() throws Exception {
        String enrollmentData = PayloadGenerator.getJsonPayload((String)"android-enrollment-payloads.json", (String)"POST").toString();
        HttpResponse response = this.client.post("/api/device-mgt/android/v1.0/devices", enrollmentData);
        JsonParser jsonParser = new JsonParser();
        JsonElement element = jsonParser.parse(response.getData());
        JsonObject jsonObject = element.getAsJsonObject();
        JsonElement msg = jsonObject.get("responseMessage");
        this.deviceId = msg.getAsString().split("'")[1].split("'")[0];
        Assert.assertEquals((int)200, (int)response.getResponseCode());
        AssertUtil.jsonPayloadCompare((String)PayloadGenerator.getJsonPayload((String)"android-enrollment-response-payloads.json", (String)"POST").toString(), (String)response.getData(), (boolean)true);
    }

    @Test(description="Test an Android device is enrolled.", dependsOnMethods={"testEnrollment"})
    public void testIsEnrolled() throws Exception {
        HttpResponse response = this.client.get("/api/device-mgt/android/v1.0/devices/" + this.deviceId + "/status");
        Assert.assertEquals((int)200, (int)response.getResponseCode());
        AssertUtil.jsonPayloadCompare((String)PayloadGenerator.getJsonPayload((String)"android-enrollment-response-payloads.json", (String)"GET").toString(), (String)response.getData(), (boolean)true);
    }

    @Test(description="Test modify enrollment.", dependsOnMethods={"testIsEnrolled"})
    public void testModifyEnrollment() throws Exception {
        JsonObject enrollmentData = PayloadGenerator.getJsonPayload((String)"android-enrollment-payloads.json", (String)"PUT");
        HttpResponse response = this.client.put("/api/device-mgt/android/v1.0/devices/" + this.deviceId, enrollmentData.toString());
        AssertUtil.jsonPayloadCompare((String)PayloadGenerator.getJsonPayload((String)"android-enrollment-response-payloads.json", (String)"PUT").toString(), (String)response.getData(), (boolean)true);
    }

    @Test(description="Test update applications", dependsOnMethods={"testModifyEnrollment"})
    public void testUpdateApplications() throws Exception {
        JsonArray updateApplicationData = PayloadGenerator.getJsonArray((String)"android-enrollment-payloads.json", (String)"UPDATE_APPLICATIONS");
        HttpResponse response = this.client.put("/api/device-mgt/android/v1.0/devices/" + this.deviceId + "/applications", updateApplicationData.toString());
        Assert.assertEquals((String)("Update of applications for the device id " + this.deviceId + " failed"), (int)202, (int)response.getResponseCode());
        response = this.client.get("/api/device-mgt/v1.0/devices/android/" + this.deviceId + "/applications");
        Assert.assertEquals((String)("Error while getting application list for the device with the id " + this.deviceId + " failed"), (int)200, (int)response.getResponseCode());
        JsonArray jsonArray = new JsonParser().parse(response.getData()).getAsJsonArray();
        Assert.assertEquals((String)("Installed applications for the device with the device id " + this.deviceId + " has not been " + "updated yet"), (int)3, (int)jsonArray.size());
    }

    @Test(description="Test get pending operations", dependsOnMethods={"testModifyEnrollment"})
    public void testGetPendingOperations() throws Exception {
        JsonArray pendingOperationsData = PayloadGenerator.getJsonArray((String)"android-enrollment-payloads.json", (String)"GET_PENDING_OPERATIONS");
        HttpResponse response = this.client.put("/api/device-mgt/android/v1.0/devices/" + this.deviceId + "/pending-operations", pendingOperationsData.toString());
        JsonArray pendingOperations = new JsonParser().parse(response.getData()).getAsJsonArray();
        Assert.assertEquals((String)("Error while getting pending operations for android device with the id " + this.deviceId), (int)201, (int)response.getResponseCode());
        Assert.assertTrue((String)"Pending operation count is 0. Periodic monitoring tasks are not running.", (0 < pendingOperations.size() ? 1 : 0) != 0);
    }

    @Test(description="Test disEnrollment.", dependsOnMethods={"testGetPendingOperations"})
    public void testDisEnrollDevice() throws Exception {
        HttpResponse response = this.client.delete("/api/device-mgt/android/v1.0/devices/" + this.deviceId);
        Assert.assertEquals((int)200, (int)response.getResponseCode());
        AssertUtil.jsonPayloadCompare((String)PayloadGenerator.getJsonPayload((String)"android-enrollment-response-payloads.json", (String)"DELETE").toString(), (String)response.getData(), (boolean)true);
    }
}

