/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.iot.integration.device.enrollment;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.sql.Timestamp;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.util.Base64;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.engine.context.beans.User;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.iot.integration.common.PayloadGenerator;
import org.wso2.iot.integration.common.RestClient;
import org.wso2.iot.integration.common.TestBase;

public class AndroidSenseEnrollment
extends TestBase {
    private static Log log = LogFactory.getLog(AndroidSenseEnrollment.class);
    private RestClient client;
    private String DEVICE_ID = "AS101";
    private RestClient analyticsClient;

    @Factory(dataProvider="userModeProvider")
    public AndroidSenseEnrollment(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true, groups={"user-mgt"})
    public void initTest() throws Exception {
        super.init(this.userMode);
        User currentUser = this.getAutomationContext().getContextTenant().getContextUser();
        byte[] bytesEncoded = Base64.encodeBase64((byte[])(currentUser.getUserName() + ":" + currentUser.getPassword()).getBytes());
        String encoded = new String(bytesEncoded);
        String auth_string = "Basic " + encoded;
        String anaytics_https_url = this.automationContext.getContextUrls().getWebAppURLHttps().replace("9443", String.valueOf(9445)).replace("/t/" + this.automationContext.getContextTenant().getDomain(), "") + "/";
        this.client = new RestClient(this.backendHTTPSURL, "application/json", this.accessTokenString);
        this.analyticsClient = new RestClient(anaytics_https_url, "application/json", auth_string);
        if (this.userMode == TestUserMode.TENANT_ADMIN) {
            HttpResponse response = this.client.post("/api/device-mgt/v1.0/admin/publish-artifact/1.0.0/deploy/android_sense", "");
            Assert.assertEquals((int)201, (int)response.getResponseCode());
        }
    }

    @Test(description="Test an Android sense device enrollment.")
    public void testEnrollment() throws Exception {
        Thread.sleep(30000L);
        HttpResponse response = this.client.post("/android_sense/1.0.0/device/" + this.DEVICE_ID + "/register?deviceName=android_sense_test", "");
        Assert.assertEquals((int)200, (int)response.getResponseCode());
        JsonElement jsonElement = new JsonParser().parse(response.getData());
        JsonObject expectedPayloadObject = jsonElement.getAsJsonObject();
        Assert.assertNotNull((String)"Mqtt end-point is returned with the android sense enrollment payload", (Object)expectedPayloadObject.get("mqttEndpoint"));
        Assert.assertNotNull((String)"Tenant domain is returned with the android sense enrollment payload", (Object)expectedPayloadObject.get("tenantDomain"));
    }

    @Test(description="Test an Android sense device data publishing.", dependsOnMethods={"testEnrollment"})
    public void testEventPublishing() throws Exception {
        String DEVICE_TYPE = "android_sense";
        String topic = this.automationContext.getContextTenant().getDomain() + "/" + DEVICE_TYPE + "/" + this.DEVICE_ID + "/data";
        int qos = 2;
        String broker = "tcp://localhost:1886";
        String clientId = this.DEVICE_ID + ":" + DEVICE_TYPE;
        MemoryPersistence persistence = new MemoryPersistence();
        MqttClient sampleClient = new MqttClient(broker, clientId, (MqttClientPersistence)persistence);
        MqttConnectOptions connOpts = new MqttConnectOptions();
        connOpts.setUserName(this.accessToken);
        connOpts.setPassword("".toCharArray());
        connOpts.setKeepAliveInterval(120);
        connOpts.setCleanSession(true);
        log.info((Object)("Connecting to broker: " + broker));
        sampleClient.connect(connOpts);
        log.info((Object)"Connected");
        MqttMessage message = new MqttMessage(PayloadGenerator.getJsonArray((String)"android-sense-enrollment-payloads.json", (String)"PUBLISH_DATA").toString().getBytes());
        message.setQos(qos);
        for (int i = 0; i < 100; ++i) {
            sampleClient.publish(topic, message);
            log.info((Object)"Message is published to Mqtt Client");
            Thread.sleep(1000L);
        }
        sampleClient.disconnect();
        HttpResponse response = this.analyticsClient.get("analytics/table_exists?table=ORG_WSO2_IOT_ANDROID_BATTERY_STATS");
        Assert.assertEquals((String)"ORG_WSO2_IOT_ANDROID_BATTERY_STATS table does not exist. Problem with the android sense analytics", (int)200, (int)response.getResponseCode());
        log.info((Object)"Mqtt Client is Disconnected");
        String url = "analytics/tables/ORG_WSO2_IOT_ANDROID_BATTERY_STATS/";
        Timestamp timestamp = new Timestamp(System.currentTimeMillis() - 3600000L);
        url = url + timestamp.getTime() + "/" + new Timestamp(System.currentTimeMillis()).getTime() + "/0/100";
        response = this.analyticsClient.get(url);
        JsonArray jsonArray = new JsonParser().parse(response.getData()).getAsJsonArray();
    }
}

