/* 
 jTable 2.4.0
 http://www.jtable.org
 ---------------------------------------------------------------------------
 Copyright (C) 2011-2014 by Halil İbrahim Kalkan (http://www.halilibrahimkalkan.com)

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 */
(function (c) {
    var g;
    c(window).on("beforeunload", function () {
        g = !0
    });
    c(window).on("unload", function () {
        g = !1
    });
    c.widget("hik.jtable", {
        options: {
            actions: {},
            fields: {},
            animationsEnabled: !0,
            defaultDateFormat: "yy-mm-dd",
            dialogShowEffect: "fade",
            dialogHideEffect: "fade",
            showCloseButton: !1,
            loadingAnimationDelay: 500,
            saveUserPreferences: !0,
            jqueryuiTheme: !1,
            unAuthorizedRequestRedirectUrl: null,
            ajaxSettings: {type: "POST", dataType: "json"},
            toolbar: {
                hoverAnimation: !0, hoverAnimationDuration: 60, hoverAnimationEasing: void 0,
                items: []
            },
            closeRequested: function (a, b) {
            },
            formCreated: function (a, b) {
            },
            formSubmitting: function (a, b) {
            },
            formClosed: function (a, b) {
            },
            loadingRecords: function (a, b) {
            },
            recordsLoaded: function (a, b) {
            },
            rowInserted: function (a, b) {
            },
            rowsRemoved: function (a, b) {
            },
            messages: {
                serverCommunicationError: "An error occured while communicating to the server.",
                loadingMessage: "Loading records...",
                noDataAvailable: "No data available!",
                areYouSure: "Are you sure?",
                save: "Save",
                saving: "Saving",
                cancel: "Cancel",
                error: "Error",
                close: "Close",
                cannotLoadOptionsFor: "Can not load options for field {0}"
            }
        },
        _$mainContainer: null,
        _$titleDiv: null,
        _$toolbarDiv: null,
        _$table: null,
        _$tableBody: null,
        _$tableRows: null,
        _$busyDiv: null,
        _$busyMessageDiv: null,
        _$errorDialogDiv: null,
        _columnList: null,
        _fieldList: null,
        _keyField: null,
        _firstDataColumnOffset: 0,
        _lastPostData: null,
        _cache: null,
        _create: function () {
            this._normalizeFieldsOptions();
            this._initializeFields();
            this._createFieldAndColumnList();
            this._createMainContainer();
            this._createTableTitle();
            this._createToolBar();
            this._createTable();
            this._createBusyPanel();
            this._createErrorDialogDiv();
            this._addNoDataRow();
            this._cookieKeyPrefix = this._generateCookieKeyPrefix()
        },
        _normalizeFieldsOptions: function () {
            var a = this;
            c.each(a.options.fields, function (b, d) {
                a._normalizeFieldOptions(b, d)
            })
        },
        _normalizeFieldOptions: function (a, b) {
            void 0 == b.listClass && (b.listClass = "");
            void 0 == b.inputClass && (b.inputClass = "");
            if (b.dependsOn && "string" === c.type(b.dependsOn)) {
                var d = b.dependsOn.split(",");
                b.dependsOn = [];
                for (var f = 0; f < d.length; f++) {
                    b.dependsOn.push(c.trim(d[f]))
                }
            }
        },
        _initializeFields: function () {
            this._lastPostData = {};
            this._$tableRows = [];
            this._columnList = [];
            this._fieldList = [];
            this._cache = []
        },
        _createFieldAndColumnList: function () {
            var a = this;
            c.each(a.options.fields, function (b, d) {
                a._fieldList.push(b);
                !0 == d.key && (a._keyField = b);
                !1 != d.list && "hidden" != d.type && a._columnList.push(b)
            })
        },
        _createMainContainer: function () {
            this._$mainContainer = c("<div />").addClass("jtable-main-container").appendTo(this.element);
            this._jqueryuiThemeAddClass(this._$mainContainer, "ui-widget")
        },
        _createTableTitle: function () {
            var a = this;
            if (a.options.title) {
                var b = c("<div />").addClass("jtable-title").appendTo(a._$mainContainer);
                a._jqueryuiThemeAddClass(b, "ui-widget-header");
                c("<div />").addClass("jtable-title-text").appendTo(b).append(a.options.title);
                if (a.options.showCloseButton) {
                    var d = c("<span />").html(a.options.messages.close);
                    c("<button></button>").addClass("jtable-command-button jtable-close-button").attr("title", a.options.messages.close).append(d).appendTo(b).click(function (d) {
                        d.preventDefault();
                        d.stopPropagation();
                        a._onCloseRequested()
                    })
                }
                a._$titleDiv = b
            }
        },
        _createTable: function () {
            this._$table = c("<table></table>").addClass("jtable").appendTo(this._$mainContainer);
            this.options.tableId && this._$table.attr("id", this.options.tableId);
            this._jqueryuiThemeAddClass(this._$table, "ui-widget-content");
            this._createTableHead();
            this._createTableBody()
        },
        _createTableHead: function () {
            var a = c("<thead></thead>").appendTo(this._$table);
            this._addRowToTableHead(a)
        },
        _addRowToTableHead: function (a) {
            a = c("<tr></tr>").appendTo(a);
            this._addColumnsToHeaderRow(a)
        },
        _addColumnsToHeaderRow: function (a) {
            for (var b = 0; b < this._columnList.length; b++) {
                var d = this._columnList[b];
                this._createHeaderCellForField(d, this.options.fields[d]).appendTo(a)
            }
        },
        _createHeaderCellForField: function (a, b) {
            b.width = b.width || "10%";
            var d = c("<span />").addClass("jtable-column-header-text").html(b.title), d = c("<div />").addClass("jtable-column-header-container").append(d), d = c("<th></th>").addClass("jtable-column-header").addClass(b.listClass).css("width", b.width).data("fieldName",
                                                                                                                                                                                                                                                                   a).append(d);
            this._jqueryuiThemeAddClass(d, "ui-state-default");
            return d
        },
        _createEmptyCommandHeader: function () {
            var a = c("<th></th>").addClass("jtable-command-column-header").css("width", "1%");
            this._jqueryuiThemeAddClass(a, "ui-state-default");
            return a
        },
        _createTableBody: function () {
            this._$tableBody = c("<tbody></tbody>").appendTo(this._$table)
        },
        _createBusyPanel: function () {
            this._$busyMessageDiv = c("<div />").addClass("jtable-busy-message").prependTo(this._$mainContainer);
            this._$busyDiv = c("<div />").addClass("jtable-busy-panel-background").prependTo(this._$mainContainer);
            this._jqueryuiThemeAddClass(this._$busyMessageDiv, "ui-widget-header");
            this._hideBusy()
        },
        _createErrorDialogDiv: function () {
            var a = this;
            a._$errorDialogDiv = c("<div></div>").appendTo(a._$mainContainer);
            a._$errorDialogDiv.dialog({
                                          autoOpen: !1,
                                          show: a.options.dialogShowEffect,
                                          hide: a.options.dialogHideEffect,
                                          modal: !0,
                                          title: a.options.messages.error,
                                          buttons: [{
                                                        text: a.options.messages.close, click: function () {
                                                  a._$errorDialogDiv.dialog("close")
                                              }
                                                    }]
                                      })
        },
        load: function (a, b) {
            this._lastPostData = a;
            this._reloadTable(b)
        },
        reload: function (a) {
            this._reloadTable(a)
        },
        getRowByKey: function (a) {
            for (var b = 0; b < this._$tableRows.length; b++) {
                if (a == this._getKeyValueOfRecord(this._$tableRows[b].data("record"))) {
                    return this._$tableRows[b];
                }
            }
            return null
        },
        destroy: function () {
            this.element.empty();
            c.Widget.prototype.destroy.call(this)
        },
        _setOption: function (a, b) {
        },
        _reloadTable: function (a) {
            var b = this, d = function (d) {
                b._hideBusy();
                "OK" != d.Result ? b._showError(d.Message) : (b._removeAllRows("reloading"), b._addRecordsToTable(d.Records), b._onRecordsLoaded(d), a && a())
            };
            b._showBusy(b.options.messages.loadingMessage,
                        b.options.loadingAnimationDelay);
            b._onLoadingRecords();
            if (c.isFunction(b.options.actions.listAction)) {
                var f = b.options.actions.listAction(b._lastPostData, b._createJtParamsForLoading());
                b._isDeferredObject(f) ? f.done(function (a) {
                    d(a)
                }).fail(function () {
                    b._showError(b.options.messages.serverCommunicationError)
                }).always(function () {
                    b._hideBusy()
                }) : d(f)
            } else {
                f = b._createRecordLoadUrl(), b._ajax({
                                                          url: f, data: b._lastPostData, success: function (a) {
                        d(a)
                    }, error: function () {
                        b._hideBusy();
                        b._showError(b.options.messages.serverCommunicationError)
                    }
                                                      })
            }
        },
        _createRecordLoadUrl: function () {
            return this.options.actions.listAction
        },
        _createJtParamsForLoading: function () {
            return {}
        },
        _createRowFromRecord: function (a) {
            a = c("<tr></tr>").addClass("jtable-data-row").attr("data-record-key", this._getKeyValueOfRecord(a)).data("record", a);
            this._addCellsToRowUsingRecord(a);
            return a
        },
        _addCellsToRowUsingRecord: function (a) {
            for (var b = a.data("record"), d = 0; d < this._columnList.length; d++) {
                this._createCellForRecordField(b, this._columnList[d]).appendTo(a)
            }
        },
        _createCellForRecordField: function (a,
                                             b) {
            return c("<td></td>").addClass(this.options.fields[b].listClass).append(this._getDisplayTextForRecordField(a, b))
        },
        _addRecordsToTable: function (a) {
            var b = this;
            c.each(a, function (a, f) {
                b._addRow(b._createRowFromRecord(f))
            });
            b._refreshRowStyles()
        },
        _addRowToTable: function (a, b, d, f) {
            b = {index: this._normalizeNumber(b, 0, this._$tableRows.length, this._$tableRows.length)};
            !0 == d && (b.isNewRow = !0);
            !1 == f && (b.animationsEnabled = !1);
            this._addRow(a, b)
        },
        _addRow: function (a, b) {
            b = c.extend({
                             index: this._$tableRows.length, isNewRow: !1,
                             animationsEnabled: !0
                         }, b);
            0 >= this._$tableRows.length && this._removeNoDataRow();
            b.index = this._normalizeNumber(b.index, 0, this._$tableRows.length, this._$tableRows.length);
            b.index == this._$tableRows.length ? (this._$tableBody.append(a), this._$tableRows.push(a)) : 0 == b.index ? (this._$tableBody.prepend(a), this._$tableRows.unshift(a)) : (this._$tableRows[b.index - 1].after(a), this._$tableRows.splice(b.index, 0, a));
            this._onRowInserted(a, b.isNewRow);
            b.isNewRow && (this._refreshRowStyles(), this.options.animationsEnabled &&
                                                     b.animationsEnabled && this._showNewRowAnimation(a))
        },
        _showNewRowAnimation: function (a) {
            var b = "jtable-row-created";
            this.options.jqueryuiTheme && (b += " ui-state-highlight");
            a.addClass(b, "slow", "", function () {
                a.removeClass(b, 5E3)
            })
        },
        _removeRowsFromTable: function (a, b) {
            var d = this;
            0 >= a.length || (a.addClass("jtable-row-removed").remove(), a.each(function () {
                var a = d._findRowIndex(c(this));
                0 <= a && d._$tableRows.splice(a, 1)
            }), d._onRowsRemoved(a, b), 0 == d._$tableRows.length && d._addNoDataRow(), d._refreshRowStyles())
        },
        _findRowIndex: function (a) {
            return this._findIndexInArray(a,
                                          this._$tableRows, function (a, d) {
                        return a.data("record") == d.data("record")
                    })
        },
        _removeAllRows: function (a) {
            if (!(0 >= this._$tableRows.length)) {
                var b = this._$tableBody.find("tr.jtable-data-row");
                this._$tableBody.empty();
                this._$tableRows = [];
                this._onRowsRemoved(b, a);
                this._addNoDataRow()
            }
        },
        _addNoDataRow: function () {
            if (!(0 < this._$tableBody.find(">tr.jtable-no-data-row").length)) {
                var a = c("<tr></tr>").addClass("jtable-no-data-row").appendTo(this._$tableBody), b = this._$table.find("thead th").length;
                c("<td></td>").attr("colspan",
                                    b).html(this.options.messages.noDataAvailable).appendTo(a)
            }
        },
        _removeNoDataRow: function () {
            this._$tableBody.find(".jtable-no-data-row").remove()
        },
        _refreshRowStyles: function () {
            for (var a = 0; a < this._$tableRows.length; a++) {
                0 == a % 2 ? this._$tableRows[a].addClass("jtable-row-even") : this._$tableRows[a].removeClass("jtable-row-even")
            }
        },
        _getDisplayTextForRecordField: function (a, b) {
            var d = this.options.fields[b], f = a[b];
            return d.display ? d.display({record: a}) : "date" == d.type ? this._getDisplayTextForDateRecordField(d, f) : "checkbox" ==
                                                                                                                          d.type ? this._getCheckBoxTextForFieldByValue(b, f) : d.options ? (d = this._getOptionsForField(b, {
                record: a,
                value: f,
                source: "list",
                dependedValues: this._createDependedValuesUsingRecord(a, d.dependsOn)
            }), this._findOptionByValue(d, f).DisplayText) : f
        },
        _createDependedValuesUsingRecord: function (a, b) {
            if (!b) {
                return {};
            }
            for (var d = {}, f = 0; f < b.length; f++) {
                d[b[f]] = a[b[f]];
            }
            return d
        },
        _findOptionByValue: function (a, b) {
            for (var d = 0; d < a.length; d++) {
                if (a[d].Value == b) {
                    return a[d];
                }
            }
            return {}
        },
        _getDisplayTextForDateRecordField: function (a, b) {
            if (!b) {
                return "";
            }
            var d = a.displayFormat || this.options.defaultDateFormat, f = this._parseDate(b);
            return c.datepicker.formatDate(d, f)
        },
        _getOptionsForField: function (a, b) {
            var d = this.options.fields[a], f = d.options;
            c.isFunction(f) && (b = c.extend(!0, {
                _cacheCleared: !1, dependedValues: {}, clearCache: function () {
                    this._cacheCleared = !0
                }
            }, b), f = f(b));
            if ("string" == typeof f) {
                var e = "options_" + a + "_" + f;
                b._cacheCleared || !this._cache[e] ? (this._cache[e] = this._buildOptionsFromArray(this._downloadOptions(a, f)), this._sortFieldOptions(this._cache[e],
                                                                                                                                                        d.optionsSorting)) : void 0 != b.value && void 0 == this._findOptionByValue(this._cache[e], b.value).DisplayText && (this._cache[e] = this._buildOptionsFromArray(this._downloadOptions(a, f)), this._sortFieldOptions(this._cache[e], d.optionsSorting));
                f = this._cache[e]
            } else {
                f = jQuery.isArray(f) ? this._buildOptionsFromArray(f) : this._buildOptionsArrayFromObject(f), this._sortFieldOptions(f, d.optionsSorting);
            }
            return f
        },
        _downloadOptions: function (a, b) {
            var d = this, f = [];
            d._ajax({
                        url: b, async: !1, success: function (a) {
                    "OK" != a.Result ?
                    d._showError(a.Message) : f = a.Options
                }, error: function () {
                    var b = d._formatString(d.options.messages.cannotLoadOptionsFor, a);
                    d._showError(b)
                }
                    });
            return f
        },
        _sortFieldOptions: function (a, b) {
            if (a && a.length && b) {
                var d;
                d = 0 == b.indexOf("value") ? function (a) {
                    return a.Value
                } : function (a) {
                    return a.DisplayText
                };
                var f;
                f = "string" == c.type(d(a[0])) ? function (a, b) {
                    return d(a).localeCompare(d(b))
                } : function (a, b) {
                    return d(a) - d(b)
                };
                0 < b.indexOf("desc") ? a.sort(function (a, d) {
                    return f(d, a)
                }) : a.sort(function (a, d) {
                    return f(a, d)
                })
            }
        },
        _buildOptionsArrayFromObject: function (a) {
            var b =
                    [];
            c.each(a, function (a, f) {
                b.push({Value: a, DisplayText: f})
            });
            return b
        },
        _buildOptionsFromArray: function (a) {
            for (var b = [], d = 0; d < a.length; d++) {
                c.isPlainObject(a[d]) ? b.push(a[d]) : b.push({
                                                                  Value: a[d],
                                                                  DisplayText: a[d]
                                                              });
            }
            return b
        },
        _parseDate: function (a) {
            if (0 <= a.indexOf("Date")) {
                return new Date(parseInt(a.substr(6), 10));
            }
            if (10 == a.length) {
                return new Date(parseInt(a.substr(0, 4), 10), parseInt(a.substr(5, 2), 10) - 1, parseInt(a.substr(8, 2), 10));
            }
            if (19 == a.length) {
                return new Date(parseInt(a.substr(0, 4), 10), parseInt(a.substr(5,
                                                                                2), 10) - 1, parseInt(a.substr(8, 2, 10)), parseInt(a.substr(11, 2), 10), parseInt(a.substr(14, 2), 10), parseInt(a.substr(17, 2), 10));
            }
            this._logWarn("Given date is not properly formatted: " + a);
            return "format error!"
        },
        _createToolBar: function () {
            this._$toolbarDiv = c("<div />").addClass("jtable-toolbar").appendTo(this._$titleDiv);
            for (var a = 0; a < this.options.toolbar.items.length; a++) {
                this._addToolBarItem(this.options.toolbar.items[a])
            }
        },
        _addToolBarItem: function (a) {
            if (void 0 == a || void 0 == a.text && void 0 == a.icon) {
                return this._logWarn("Can not add tool bar item since it is not valid!"),
                        this._logWarn(a), null;
            }
            var b = c("<span></span>").addClass("jtable-toolbar-item").appendTo(this._$toolbarDiv);
            this._jqueryuiThemeAddClass(b, "ui-widget ui-state-default ui-corner-all", "ui-state-hover");
            a.cssClass && b.addClass(a.cssClass);
            a.tooltip && b.attr("title", a.tooltip);
            if (a.icon) {
                var d = c('<span class="jtable-toolbar-item-icon"></span>').appendTo(b);
                !0 !== a.icon && c.type("string" === a.icon) && d.css("background", 'url("' + a.icon + '")')
            }
            a.text && c('<span class=""></span>').html(a.text).addClass("jtable-toolbar-item-text").appendTo(b);
            a.click && b.click(function () {
                a.click()
            });
            var f = void 0, e = void 0;
            this.options.toolbar.hoverAnimation && (f = this.options.toolbar.hoverAnimationDuration, e = this.options.toolbar.hoverAnimationEasing);
            b.hover(function () {
                b.addClass("jtable-toolbar-item-hover", f, e)
            }, function () {
                b.removeClass("jtable-toolbar-item-hover", f, e)
            });
            return b
        },
        _showError: function (a) {
            this._$errorDialogDiv.html(a).dialog("open")
        },
        _setBusyTimer: null,
        _showBusy: function (a, b) {
            var d = this;
            d._$busyDiv.width(d._$mainContainer.width()).height(d._$mainContainer.height()).addClass("jtable-busy-panel-background-invisible").show();
            var f = function () {
                d._$busyDiv.removeClass("jtable-busy-panel-background-invisible");
                d._$busyMessageDiv.html(a).show()
            };
            b ? d._setBusyTimer || (d._setBusyTimer = setTimeout(f, b)) : f()
        },
        _hideBusy: function () {
            clearTimeout(this._setBusyTimer);
            this._setBusyTimer = null;
            this._$busyDiv.hide();
            this._$busyMessageDiv.html("").hide()
        },
        _isBusy: function () {
            return this._$busyMessageDiv.is(":visible")
        },
        _jqueryuiThemeAddClass: function (a, b, d) {
            this.options.jqueryuiTheme && (a.addClass(b), d && a.hover(function () {
                a.addClass(d)
            }, function () {
                a.removeClass(d)
            }))
        },
        _performAjaxCall: function (a, b, d, f, e) {
            this._ajax({url: a, data: b, async: d, success: f, error: e})
        },
        _unAuthorizedRequestHandler: function () {
            this.options.unAuthorizedRequestRedirectUrl ? location.href = this.options.unAuthorizedRequestRedirectUrl : location.reload(!0)
        },
        _ajax: function (a) {
            var b = this, d = {
                statusCode: {
                    401: function () {
                        b._unAuthorizedRequestHandler()
                    }
                }
            }, d = c.extend(d, this.options.ajaxSettings, a);
            d.success = function (d) {
                d && !0 == d.UnAuthorizedRequest && b._unAuthorizedRequestHandler();
                a.success && a.success(d)
            };
            d.error =
            function (d, b, h) {
                g ? d.abort() : a.error && a.error(arguments)
            };
            d.complete = function () {
                a.complete && a.complete()
            };
            c.ajax(d)
        },
        _getKeyValueOfRecord: function (a) {
            return a[this._keyField]
        },
        _setCookie: function (a, b) {
            a = this._cookieKeyPrefix + a;
            var d = new Date;
            d.setDate(d.getDate() + 30);
            document.cookie = encodeURIComponent(a) + "=" + encodeURIComponent(b) + "; expires=" + d.toUTCString()
        },
        _getCookie: function (a) {
            a = this._cookieKeyPrefix + a;
            for (var b = document.cookie.split("; "), d = 0; d < b.length; d++) {
                if (b[d]) {
                    var f = b[d].split("=");
                    if (2 ==
                        f.length && decodeURIComponent(f[0]) === a) {
                        return decodeURIComponent(f[1] || "")
                    }
                }
            }
            return null
        },
        _generateCookieKeyPrefix: function () {
            var a = "";
            this.options.tableId && (a = a + this.options.tableId + "#");
            a = a + this._columnList.join("$") + "#c" + this._$table.find("thead th").length;
            var b = 0;
            if (0 != a.length) {
                for (var d = 0; d < a.length; d++) {
                    var f = a.charCodeAt(d), b = (b << 5) - b + f, b = b & b;
                }
            }
            return "jtable#" + b
        },
        _onLoadingRecords: function () {
            this._trigger("loadingRecords", null, {})
        },
        _onRecordsLoaded: function (a) {
            this._trigger("recordsLoaded", null,
                          {records: a.Records, serverResponse: a})
        },
        _onRowInserted: function (a, b) {
            this._trigger("rowInserted", null, {row: a, record: a.data("record"), isNewRow: b})
        },
        _onRowsRemoved: function (a, b) {
            this._trigger("rowsRemoved", null, {rows: a, reason: b})
        },
        _onCloseRequested: function () {
            this._trigger("closeRequested", null, {})
        }
    })
})(jQuery);
(function (c) {
    c.extend(!0, c.hik.jtable.prototype, {
        _getPropertyOfObject: function (c, a) {
            if (0 > a.indexOf(".")) {
                return c[a];
            }
            var b = a.substring(0, a.indexOf(".")), d = a.substring(a.indexOf(".") + 1);
            return this._getPropertyOfObject(c[b], d)
        }, _setPropertyOfObject: function (c, a, b) {
            if (0 > a.indexOf(".")) {
                c[a] = b;
            } else {
                var d = a.substring(0, a.indexOf("."));
                a = a.substring(a.indexOf(".") + 1);
                this._setPropertyOfObject(c[d], a, b)
            }
        }, _insertToArrayIfDoesNotExists: function (g, a) {
            0 > c.inArray(a, g) && g.push(a)
        }, _findIndexInArray: function (c,
                                        a, b) {
            b || (b = function (a, d) {
                return a == d
            });
            for (var d = 0; d < a.length; d++) {
                if (b(c, a[d])) {
                    return d;
                }
            }
            return -1
        }, _normalizeNumber: function (c, a, b, d) {
            return void 0 == c || null == c || isNaN(c) ? d : c < a ? a : c > b ? b : c
        }, _formatString: function () {
            if (0 == arguments.length) {
                return null;
            }
            for (var c = arguments[0], a = 1; a < arguments.length; a++) {
                c = c.replace("{" + (a - 1) + "}", arguments[a]);
            }
            return c
        }, _isDeferredObject: function (c) {
            return c.then && c.done && c.fail
        }, _logDebug: function (c) {
            window.console && console.log("jTable DEBUG: " + c)
        }, _logInfo: function (c) {
            window.console &&
            console.log("jTable INFO: " + c)
        }, _logWarn: function (c) {
            window.console && console.log("jTable WARNING: " + c)
        }, _logError: function (c) {
            window.console && console.log("jTable ERROR: " + c)
        }
    });
    Array.prototype.indexOf || (Array.prototype.indexOf = function (c, a) {
        var b = this.length, d = Number(a) || 0, d = 0 > d ? Math.ceil(d) : Math.floor(d);
        for (0 > d && (d += b); d < b; d++) {
            if (d in this && this[d] === c) {
                return d;
            }
        }
        return -1
    })
})(jQuery);
(function (c) {
    c.extend(!0, c.hik.jtable.prototype, {
        _submitFormUsingAjax: function (c, a, b, d) {
            this._ajax({url: c, data: a, success: b, error: d})
        }, _createInputLabelForRecordField: function (g) {
            return c("<div />").addClass("jtable-input-label").html(this.options.fields[g].inputTitle || this.options.fields[g].title)
        }, _createInputForRecordField: function (g) {
            var a = g.fieldName, b = g.value, d = g.record, f = g.formType;
            g = g.form;
            var e = this.options.fields[a];
            if (void 0 == b || null == b) {
                b = e.defaultValue;
            }
            return e.input ? (b = c(e.input({
                                                value: b,
                                                record: d, formType: f, form: g
                                            })), b.attr("id") || b.attr("id", "Edit-" + a), c("<div />").addClass("jtable-input jtable-custom-input").append(b)) : "date" == e.type ? this._createDateInputForField(e, a, b) : "textarea" == e.type ? this._createTextAreaForField(e, a, b) : "password" == e.type ? this._createPasswordInputForField(e, a, b) : "checkbox" == e.type ? this._createCheckboxForField(e, a, b) : e.options ? "radiobutton" == e.type ? this._createRadioButtonListForField(e, a, b, d, f) : this._createDropDownListForField(e, a, b, d, f, g) : this._createTextInputForField(e,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               a, b)
        }, _createInputForHidden: function (g, a) {
            void 0 == a && (a = "");
            return c('<input type="hidden" name="' + g + '" id="Edit-' + g + '"></input>').val(a)
        }, _createDateInputForField: function (g, a, b) {
            a = c('<input class="' + g.inputClass + '" id="Edit-' + a + '" type="text" name="' + a + '"></input>');
            void 0 != b && a.val(b);
            a.datepicker({dateFormat: g.displayFormat || this.options.defaultDateFormat});
            return c("<div />").addClass("jtable-input jtable-date-input").append(a)
        }, _createTextAreaForField: function (g, a, b) {
            g = c('<textarea class="' +
                  g.inputClass + '" placeholder="' + g.placeholder + '" id="Edit-' + a + '" name="' + a + '"></textarea>');
            void 0 != b && g.val(b);
            return c("<div />").addClass("jtable-input jtable-textarea-input").append(g)
        }, _createTextInputForField: function (g, a, b) {
            g = c('<input class="' + g.inputClass + '" placeholder="' + g.placeholder + '" id="Edit-' + a + '" type="text" name="' + a + '"></input>');
            void 0 != b && g.val(b);
            return c("<div />").addClass("jtable-input jtable-text-input").append(g)
        }, _createPasswordInputForField: function (g, a, b) {
            g = c('<input class="' + g.inputClass + '" id="Edit-' + a + '" type="password" name="' +
                  a + '"></input>');
            void 0 != b && g.val(b);
            return c("<div />").addClass("jtable-input jtable-password-input").append(g)
        }, _createCheckboxForField: function (g, a, b) {
            var d = this;
            void 0 == b && (b = d._getCheckBoxPropertiesForFieldByState(a, !1).Value);
            var f = c("<div />").addClass("jtable-input jtable-checkbox-input"), e = c('<input class="' + g.inputClass + '" id="Edit-' + a + '" type="checkbox" name="' + a + '" />').appendTo(f);
            void 0 != b && e.val(b);
            var h = c("<span>" + (g.formText || d._getCheckBoxTextForFieldByValue(a, b)) + "</span>").appendTo(f);
            d._getIsCheckBoxSelectedForFieldByValue(a, b) && e.attr("checked", "checked");
            var k = function () {
                var b = d._getCheckBoxPropertiesForFieldByState(a, e.is(":checked"));
                e.attr("value", b.Value);
                h.html(g.formText || b.DisplayText)
            };
            e.click(function () {
                k()
            });
            !1 != g.setOnTextClick && h.addClass("jtable-option-text-clickable").click(function () {
                e.is(":checked") ? e.attr("checked", !1) : e.attr("checked", !0);
                k()
            });
            return f
        }, _createDropDownListForField: function (g, a, b, d, f, e) {
            var h = c("<div />").addClass("jtable-input jtable-dropdown-input"),
                    k = c('<select class="' + g.inputClass + '" id="Edit-' + a + '" name="' + a + '"></select>').appendTo(h);
            g = this._getOptionsForField(a, {
                record: d,
                source: f,
                form: e,
                dependedValues: this._createDependedValuesUsingForm(e, g.dependsOn)
            });
            this._fillDropDownListWithOptions(k, g, b);
            return h
        }, _fillDropDownListWithOptions: function (g, a, b) {
            g.empty();
            for (var d = 0; d < a.length; d++) {
                c("<option" + (a[d].Value == b ? ' selected="selected"' : "") + ">" + a[d].DisplayText + "</option>").val(a[d].Value).appendTo(g)
            }
        }, _createDependedValuesUsingForm: function (c,
                                                     a) {
            if (!a) {
                return {};
            }
            for (var b = {}, d = 0; d < a.length; d++) {
                var f = a[d], e = c.find("select[name=" + f + "]");
                0 >= e.length || (b[f] = e.val())
            }
            return b
        }, _createRadioButtonListForField: function (g, a, b, d, f) {
            var e = c("<div />").addClass("jtable-input jtable-radiobuttonlist-input");
            d = this._getOptionsForField(a, {record: d, source: f});
            c.each(d, function (d, f) {
                var l = c('<div class=""></div>').addClass("jtable-radio-input").appendTo(e), m = c('<input type="radio" id="Edit-' + a + "-" + d + '" class="' + g.inputClass + '" name="' + a + '"' + (f.Value == b +
                                                                                                                                                                                                                    "" ? ' checked="true"' : "") + " />").val(f.Value).appendTo(l), l = c("<span></span>").html(f.DisplayText).appendTo(l);
                !1 != g.setOnTextClick && l.addClass("jtable-option-text-clickable").click(function () {
                    m.is(":checked") || m.attr("checked", !0)
                })
            });
            return e
        }, _getCheckBoxTextForFieldByValue: function (c, a) {
            return this.options.fields[c].values[a]
        }, _getIsCheckBoxSelectedForFieldByValue: function (c, a) {
            return this._createCheckBoxStateArrayForFieldWithCaching(c)[1].Value.toString() == a.toString()
        }, _getCheckBoxPropertiesForFieldByState: function (c,
                                                            a) {
            return this._createCheckBoxStateArrayForFieldWithCaching(c)[a ? 1 : 0]
        }, _createCheckBoxStateArrayForFieldWithCaching: function (c) {
            var a = "checkbox_" + c;
            this._cache[a] || (this._cache[a] = this._createCheckBoxStateArrayForField(c));
            return this._cache[a]
        }, _createCheckBoxStateArrayForField: function (g) {
            var a = [], b = 0;
            c.each(this.options.fields[g].values, function (d, f) {
                2 > b++ && a.push({Value: d, DisplayText: f})
            });
            return a
        }, _makeCascadeDropDowns: function (g, a, b) {
            var d = this;
            g.find("select").each(function () {
                var f = c(this),
                        e = f.attr("name");
                if (e) {
                    var h = d.options.fields[e];
                    h.dependsOn && c.each(h.dependsOn, function (c, l) {
                        g.find("select[name=" + l + "]").change(function () {
                            var c = {record: a, source: b, form: g, dependedValues: {}};
                            c.dependedValues = d._createDependedValuesUsingForm(g, h.dependsOn);
                            c = d._getOptionsForField(e, c);
                            d._fillDropDownListWithOptions(f, c, void 0);
                            f.change()
                        })
                    })
                }
            })
        }, _updateRecordValuesFromForm: function (g, a) {
            for (var b = 0; b < this._fieldList.length; b++) {
                var d = this._fieldList[b], f = this.options.fields[d];
                if (!1 != f.edit) {
                    var e =
                            a.find('[name="' + d + '"]');
                    if (!(0 >= e.length)) {
                        if ("date" == f.type) {
                            if (e = e.val()) {
                                f = f.displayFormat || this.options.defaultDateFormat;
                                try {
                                    var h = c.datepicker.parseDate(f, e);
                                    g[d] = "/Date(" + h.getTime() + ")/"
                                } catch (k) {
                                    this._logWarn("Date format is incorrect for field " + d + ": " + e), g[d] = void 0
                                }
                            } else {
                                this._logDebug("Date is empty for " + d), g[d] = void 0;
                            }
                        } else {
                            f.options && "radiobutton" == f.type ? (f = e.filter(":checked"), g[d] = f.length ? f.val() : void 0) : g[d] = e.val()
                        }
                    }
                }
            }
        }, _setEnabledOfDialogButton: function (c, a, b) {
            c && (!1 != a ? c.removeAttr("disabled").removeClass("ui-state-disabled") :
                  c.attr("disabled", "disabled").addClass("ui-state-disabled"), b && c.find("span").text(b))
        }
    })
})(jQuery);
(function (c) {
    var g = c.hik.jtable.prototype._create;
    c.extend(!0, c.hik.jtable.prototype, {
        options: {
            recordAdded: function (a, b) {
            }, messages: {addNewRecord: "Add new record"}
        }, _$addRecordDiv: null, _create: function () {
            g.apply(this, arguments);
            this.options.actions.createAction && this._createAddRecordDialogDiv()
        }, _createAddRecordDialogDiv: function () {
            var a = this;
            a._$addRecordDiv = c("<div />").appendTo(a._$mainContainer);
            a._$addRecordDiv.dialog({
                                        autoOpen: !1,
                                        show: a.options.dialogShowEffect,
                                        hide: a.options.dialogHideEffect,
                                        modal: !0,
                                        height: "300",
                                        width: "500",
                                        resizable: !0,
                                        title: a.options.messages.addNewRecord,
                                        buttons: [{
                                                      text: a.options.messages.cancel, click: function () {
                                                a._$addRecordDiv.dialog("close")
                                            }
                                                  }, {
                                                      id: "AddRecordDialogSaveButton",
                                                      text: a.options.messages.save,
                                                      click: function () {
                                                          a._onSaveClickedOnCreateForm()
                                                      }
                                                  }],
                                        close: function () {
                                            var b = a._$addRecordDiv.find("form").first(), d = a._$addRecordDiv.parent().find("#AddRecordDialogSaveButton");
                                            a._trigger("formClosed", null, {form: b, formType: "create"});
                                            a._setEnabledOfDialogButton(d, !0, a.options.messages.save);
                                            b.remove()
                                        }
                                    });
            a.options.addRecordButton ? a.options.addRecordButton.click(function (b) {
                b.preventDefault();
                a._showAddRecordForm()
            }) : a._addToolBarItem({
                                       icon: !0,
                                       cssClass: "jtable-toolbar-item-add-record",
                                       text: a.options.messages.addNewRecord,
                                       click: function () {
                                           a._showAddRecordForm()
                                       }
                                   })
        }, _onSaveClickedOnCreateForm: function () {
            var a = this._$addRecordDiv.parent().find("#AddRecordDialogSaveButton"), b = this._$addRecordDiv.find("form");
            !1 != this._trigger("formSubmitting", null, {
                form: b,
                formType: "create"
            }) && (this._setEnabledOfDialogButton(a,
                                                  !1, this.options.messages.saving), this._saveAddRecordForm(b, a))
        }, showCreateForm: function () {
            this._showAddRecordForm()
        }, addRecord: function (a) {
            var b = this;
            a = c.extend({
                             clientOnly: !1, animationsEnabled: b.options.animationsEnabled, success: function () {
                }, error: function () {
                }
                         }, a);
            if (a.record) {
                if (a.clientOnly) {
                    b._addRow(b._createRowFromRecord(a.record), {
                        isNewRow: !0,
                        animationsEnabled: a.animationsEnabled
                    }), a.success();
                } else {
                    var d = function (d) {
                        "OK" != d.Result ? (b._showError(d.Message), a.error(d)) : d.Record ? (b._onRecordAdded(d),
                                b._addRow(b._createRowFromRecord(d.Record), {
                                    isNewRow: !0,
                                    animationsEnabled: a.animationsEnabled
                                }), a.success(d)) : (b._logError("Server must return the created Record object."), a.error(d))
                    };
                    if (!a.url && c.isFunction(b.options.actions.createAction)) {
                        var f = b.options.actions.createAction(c.param(a.record));
                        b._isDeferredObject(f) ? f.done(function (a) {
                            d(a)
                        }).fail(function () {
                            b._showError(b.options.messages.serverCommunicationError);
                            a.error()
                        }) : d(f)
                    } else {
                        b._submitFormUsingAjax(a.url || b.options.actions.createAction,
                                               c.param(a.record), function (a) {
                                    d(a)
                                }, function () {
                                    b._showError(b.options.messages.serverCommunicationError);
                                    a.error()
                                })
                    }
                }
            } else {
                b._logWarn("options parameter in addRecord method must contain a record property.")
            }
        }, _showAddRecordForm: function () {
            for (var a = this, b = c('<form id="jtable-create-form" class="jtable-dialog-form jtable-create-form"></form>'), d = 0; d < a._fieldList.length; d++) {
                var f = a._fieldList[d], e = a.options.fields[f];
                !0 == e.key && !0 != e.create || !1 == e.create || ("hidden" == e.type ? b.append(a._createInputForHidden(f,
                                                                                                                          e.defaultValue)) : (e = c("<div />").addClass("jtable-input-field-container").appendTo(b), e.append(a._createInputLabelForRecordField(f)), e.append(a._createInputForRecordField({
                                                                                                                                                                                                                                                                                                               fieldName: f,
                                                                                                                                                                                                                                                                                                               formType: "create",
                                                                                                                                                                                                                                                                                                               form: b
                                                                                                                                                                                                                                                                                                           }))))
            }
            a._makeCascadeDropDowns(b, void 0, "create");
            b.submit(function () {
                a._onSaveClickedOnCreateForm();
                return !1
            });
            a._$addRecordDiv.append(b).dialog("open");
            a._trigger("formCreated", null, {form: b, formType: "create"})
        }, _saveAddRecordForm: function (a, b) {
            var d = this, f = function (a) {
                "OK" != a.Result ? (d._showError(a.Message),
                        d._setEnabledOfDialogButton(b, !0, d.options.messages.save)) : a.Record ? (d._onRecordAdded(a), d._addRow(d._createRowFromRecord(a.Record), {isNewRow: !0}), d._$addRecordDiv.dialog("close")) : (d._logError("Server must return the created Record object."), d._setEnabledOfDialogButton(b, !0, d.options.messages.save))
            };
            a.data("submitting", !0);
            if (c.isFunction(d.options.actions.createAction)) {
                var e = d.options.actions.createAction(a.serialize());
                d._isDeferredObject(e) ? e.done(function (a) {
                    f(a)
                }).fail(function () {
                    d._showError(d.options.messages.serverCommunicationError);
                    d._setEnabledOfDialogButton(b, !0, d.options.messages.save)
                }) : f(e)
            } else {
                d._submitFormUsingAjax(d.options.actions.createAction, a.serialize(), function (a) {
                    f(a)
                }, function () {
                    d._showError(d.options.messages.serverCommunicationError);
                    d._setEnabledOfDialogButton(b, !0, d.options.messages.save)
                })
            }
        }, _onRecordAdded: function (a) {
            this._trigger("recordAdded", null, {record: a.Record, serverResponse: a})
        }
    })
})(jQuery);
(function (c) {
    var g = c.hik.jtable.prototype._create, a = c.hik.jtable.prototype._addColumnsToHeaderRow, b = c.hik.jtable.prototype._addCellsToRowUsingRecord;
    c.extend(!0, c.hik.jtable.prototype, {
        options: {
            recordUpdated: function (a, b) {
            }, rowUpdated: function (a, b) {
            }, messages: {editRecord: "Edit Record"}
        }, _$editDiv: null, _$editingRow: null, _create: function () {
            g.apply(this, arguments);
            this.options.actions.updateAction && this._createEditDialogDiv()
        }, _createEditDialogDiv: function () {
            var a = this;
            a._$editDiv = c("<div></div>").appendTo(a._$mainContainer);
            a._$editDiv.dialog({
                                   autoOpen: !1,
                                   show: a.options.dialogShowEffect,
                                   hide: a.options.dialogHideEffect,
                                   modal: !0,
                                   height: "300",
                                   width: "500",
                                   resizable: !0,
                                   title: a.options.messages.editRecord,
                                   buttons: [{
                                                 text: a.options.messages.cancel, click: function () {
                                           a._$editDiv.dialog("close")
                                       }
                                             }, {
                                                 id: "EditDialogSaveButton",
                                                 text: a.options.messages.save,
                                                 click: function () {
                                                     a._onSaveClickedOnEditForm()
                                                 }
                                             }],
                                   close: function () {
                                       var b = a._$editDiv.find("form:first"), c = a._$editDiv.parent().find("#EditDialogSaveButton");
                                       a._trigger("formClosed", null, {
                                           form: b,
                                           formType: "edit", row: a._$editingRow
                                       });
                                       a._setEnabledOfDialogButton(c, !0, a.options.messages.save);
                                       b.remove()
                                   }
                               })
        }, _onSaveClickedOnEditForm: function () {
            if (this._$editingRow.hasClass("jtable-row-removed")) {
                this._$editDiv.dialog("close");
            } else {
                var a = this._$editDiv.parent().find("#EditDialogSaveButton"), b = this._$editDiv.find("form");
                !1 != this._trigger("formSubmitting", null, {
                    form: b,
                    formType: "edit",
                    row: this._$editingRow
                }) && (this._setEnabledOfDialogButton(a, !1, this.options.messages.saving), this._saveEditForm(b,
                                                                                                               a))
            }
        }, updateRecord: function (a) {
            var b = this;
            a = c.extend({
                             clientOnly: !1, animationsEnabled: b.options.animationsEnabled, success: function () {
                }, error: function () {
                }
                         }, a);
            if (a.record) {
                var e = b._getKeyValueOfRecord(a.record);
                if (void 0 == e || null == e) {
                    b._logWarn("options parameter in updateRecord method must contain a record that contains the key field property.");
                } else {
                    var h = b.getRowByKey(e);
                    if (null == h) {
                        b._logWarn('Can not found any row by key "' + e + '" on the table. Updating row must be visible on the table.');
                    } else if (a.clientOnly) {
                        c.extend(h.data("record"),
                                 a.record), b._updateRowTexts(h), b._onRecordUpdated(h, null), a.animationsEnabled && b._showUpdateAnimationForRow(h), a.success();
                    } else {
                        var k = function (e) {
                            "OK" != e.Result ? (b._showError(e.Message), a.error(e)) : (c.extend(h.data("record"), a.record), b._updateRecordValuesFromServerResponse(h.data("record"), e), b._updateRowTexts(h), b._onRecordUpdated(h, e), a.animationsEnabled && b._showUpdateAnimationForRow(h), a.success(e))
                        };
                        !a.url && c.isFunction(b.options.actions.updateAction) ? (e = b.options.actions.updateAction(c.param(a.record)),
                                b._isDeferredObject(e) ? e.done(function (a) {
                                    k(a)
                                }).fail(function () {
                                    b._showError(b.options.messages.serverCommunicationError);
                                    a.error()
                                }) : k(e)) : b._submitFormUsingAjax(a.url || b.options.actions.updateAction, c.param(a.record), function (a) {
                            k(a)
                        }, function () {
                            b._showError(b.options.messages.serverCommunicationError);
                            a.error()
                        })
                    }
                }
            } else {
                b._logWarn("options parameter in updateRecord method must contain a record property.")
            }
        }, _addColumnsToHeaderRow: function (d) {
            a.apply(this, arguments);
            void 0 != this.options.actions.updateAction &&
            d.append(this._createEmptyCommandHeader())
        }, _addCellsToRowUsingRecord: function (a) {
            var f = this;
            b.apply(this, arguments);
            if (void 0 != f.options.actions.updateAction) {
                var e = c("<span></span>").html(f.options.messages.editRecord), e = c('<button title="' + f.options.messages.editRecord + '"></button>').addClass("jtable-command-button jtable-edit-command-button").append(e).click(function (b) {
                    b.preventDefault();
                    b.stopPropagation();
                    f._showEditForm(a)
                });
                c("<td></td>").addClass("jtable-command-column").append(e).appendTo(a)
            }
        },
        _showEditForm: function (a) {
            for (var b = this, e = a.data("record"), h = c('<form id="jtable-edit-form" class="jtable-dialog-form jtable-edit-form"></form>'), k = 0; k < b._fieldList.length; k++) {
                var l = b._fieldList[k], m = b.options.fields[l], n = e[l];
                if (!0 == m.key) {
                    if (!0 != m.edit) {
                        h.append(b._createInputForHidden(l, n));
                        continue
                    } else {
                        h.append(b._createInputForHidden("jtRecordKey", n));
                    }
                }
                !1 != m.edit && ("hidden" == m.type ? h.append(b._createInputForHidden(l, n)) : (m = c('<div class="jtable-input-field-container"></div>').appendTo(h), m.append(b._createInputLabelForRecordField(l)),
                        n = b._getValueForRecordField(e, l), m.append(b._createInputForRecordField({
                                                                                                       fieldName: l,
                                                                                                       value: n,
                                                                                                       record: e,
                                                                                                       formType: "edit",
                                                                                                       form: h
                                                                                                   }))))
            }
            b._makeCascadeDropDowns(h, e, "edit");
            h.submit(function () {
                b._onSaveClickedOnEditForm();
                return !1
            });
            b._$editingRow = a;
            b._$editDiv.append(h).dialog("open");
            b._trigger("formCreated", null, {form: h, formType: "edit", record: e, row: a})
        }, _saveEditForm: function (a, b) {
            var e = this, h = function (c) {
                if ("OK" != c.Result) {
                    e._showError(c.Message), e._setEnabledOfDialogButton(b, !0, e.options.messages.save);
                } else {
                    var h = e._$editingRow.data("record");
                    e._updateRecordValuesFromForm(h, a);
                    e._updateRecordValuesFromServerResponse(h, c);
                    e._updateRowTexts(e._$editingRow);
                    e._$editingRow.attr("data-record-key", e._getKeyValueOfRecord(h));
                    e._onRecordUpdated(e._$editingRow, c);
                    e.options.animationsEnabled && e._showUpdateAnimationForRow(e._$editingRow);
                    e._$editDiv.dialog("close")
                }
            };
            if (c.isFunction(e.options.actions.updateAction)) {
                var k = e.options.actions.updateAction(a.serialize());
                e._isDeferredObject(k) ? k.done(function (a) {
                    h(a)
                }).fail(function () {
                    e._showError(e.options.messages.serverCommunicationError);
                    e._setEnabledOfDialogButton(b, !0, e.options.messages.save)
                }) : h(k)
            } else {
                e._submitFormUsingAjax(e.options.actions.updateAction, a.serialize(), function (a) {
                    h(a)
                }, function () {
                    e._showError(e.options.messages.serverCommunicationError);
                    e._setEnabledOfDialogButton(b, !0, e.options.messages.save)
                })
            }
        }, _updateRecordValuesFromServerResponse: function (a, b) {
            b && b.Record && c.extend(!0, a, b.Record)
        }, _getValueForRecordField: function (a, b) {
            var c = this.options.fields[b], h = a[b];
            return "date" == c.type ? this._getDisplayTextForDateRecordField(c,
                                                                             h) : h
        }, _updateRowTexts: function (a) {
            for (var b = a.data("record"), c = a.find("td"), h = 0; h < this._columnList.length; h++) {
                var k = this._getDisplayTextForRecordField(b, this._columnList[h]);
                "" != k && 0 == k && (k = "0");
                c.eq(this._firstDataColumnOffset + h).html(k || "")
            }
            this._onRowUpdated(a)
        }, _showUpdateAnimationForRow: function (a) {
            var b = "jtable-row-updated";
            this.options.jqueryuiTheme && (b += " ui-state-highlight");
            a.stop(!0, !0).addClass(b, "slow", "", function () {
                a.removeClass(b, 5E3)
            })
        }, _onRowUpdated: function (a) {
            this._trigger("rowUpdated",
                          null, {row: a, record: a.data("record")})
        }, _onRecordUpdated: function (a, b) {
            this._trigger("recordUpdated", null, {record: a.data("record"), row: a, serverResponse: b})
        }
    })
})(jQuery);
(function (c) {
    var g = c.hik.jtable.prototype._create, a = c.hik.jtable.prototype._addColumnsToHeaderRow, b = c.hik.jtable.prototype._addCellsToRowUsingRecord;
    c.extend(!0, c.hik.jtable.prototype, {
        options: {
            deleteConfirmation: !0,
            recordDeleted: function (a, b) {
            },
            messages: {
                deleteConfirmation: "This record will be deleted. Are you sure?",
                deleteText: "Delete",
                deleting: "Deleting",
                canNotDeletedRecords: "Can not delete {0} of {1} records!",
                deleteProggress: "Deleting {0} of {1} records, processing..."
            }
        }, _$deleteRecordDiv: null,
        _$deletingRow: null, _create: function () {
            g.apply(this, arguments);
            this._createDeleteDialogDiv()
        }, _createDeleteDialogDiv: function () {
            var a = this;
            a.options.actions.deleteAction && (a._$deleteRecordDiv = c('<div><p><span class="ui-icon ui-icon-alert" style="float:left; margin:0 7px 20px 0;"></span><span class="jtable-delete-confirm-message"></span></p></div>').appendTo(a._$mainContainer), a._$deleteRecordDiv.dialog({
                                                                                                                                                                                                                                                                                                autoOpen: !1,
                                                                                                                                                                                                                                                                                                show: a.options.dialogShowEffect,
                                                                                                                                                                                                                                                                                                hide: a.options.dialogHideEffect,
                                                                                                                                                                                                                                                                                                modal: !0,
                                                                                                                                                                                                                                                                                                title: a.options.messages.areYouSure,
                                                                                                                                                                                                                                                                                                buttons: [{
                                                                                                                                                                                                                                                                                                              text: a.options.messages.cancel,
                                                                                                                                                                                                                                                                                                              click: function () {
                                                                                                                                                                                                                                                                                                                  a._$deleteRecordDiv.dialog("close")
                                                                                                                                                                                                                                                                                                              }
                                                                                                                                                                                                                                                                                                          }, {
                                                                                                                                                                                                                                                                                                              id: "DeleteDialogButton",
                                                                                                                                                                                                                                                                                                              text: a.options.messages.deleteText,
                                                                                                                                                                                                                                                                                                              click: function () {
                                                                                                                                                                                                                                                                                                                  if (a._$deletingRow.hasClass("jtable-row-removed")) {
                                                                                                                                                                                                                                                                                                                      a._$deleteRecordDiv.dialog("close");
                                                                                                                                                                                                                                                                                                                  } else {
                                                                                                                                                                                                                                                                                                                      var b = a._$deleteRecordDiv.parent().find("#DeleteDialogButton");
                                                                                                                                                                                                                                                                                                                      a._setEnabledOfDialogButton(b, !1, a.options.messages.deleting);
                                                                                                                                                                                                                                                                                                                      a._deleteRecordFromServer(a._$deletingRow, function () {
                                                                                                                                                                                                                                                                                                                                                    a._removeRowsFromTableWithAnimation(a._$deletingRow);
                                                                                                                                                                                                                                                                                                                                                    a._$deleteRecordDiv.dialog("close")
                                                                                                                                                                                                                                                                                                                                                },
                                                                                                                                                                                                                                                                                                                                                function (c) {
                                                                                                                                                                                                                                                                                                                                                    a._showError(c);
                                                                                                                                                                                                                                                                                                                                                    a._setEnabledOfDialogButton(b, !0, a.options.messages.deleteText)
                                                                                                                                                                                                                                                                                                                                                })
                                                                                                                                                                                                                                                                                                                  }
                                                                                                                                                                                                                                                                                                              }
                                                                                                                                                                                                                                                                                                          }],
                                                                                                                                                                                                                                                                                                close: function () {
                                                                                                                                                                                                                                                                                                    var b = a._$deleteRecordDiv.parent().find("#DeleteDialogButton");
                                                                                                                                                                                                                                                                                                    a._setEnabledOfDialogButton(b, !0, a.options.messages.deleteText)
                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                            }))
        }, deleteRows: function (a) {
            var b = this;
            if (0 >= a.length) {
                b._logWarn("No rows specified to jTable deleteRows method.");
            } else if (b._isBusy()) {
                b._logWarn("Can not delete rows since jTable is busy!");
            } else if (1 == a.length) {
                b._deleteRecordFromServer(a, function () {
                                              b._removeRowsFromTableWithAnimation(a)
                                          },
                                          function (a) {
                                              b._showError(a)
                                          });
            } else {
                b._showBusy(b._formatString(b.options.messages.deleteProggress, 0, a.length));
                var e = 0, h = function () {
                    var c = a.filter(".jtable-row-ready-to-remove");
                    c.length < a.length && b._showError(b._formatString(b.options.messages.canNotDeletedRecords, a.length - c.length, a.length));
                    0 < c.length && b._removeRowsFromTableWithAnimation(c);
                    b._hideBusy()
                }, k = 0;
                a.each(function () {
                    var g = c(this);
                    b._deleteRecordFromServer(g, function () {
                        ++k;
                        ++e;
                        g.addClass("jtable-row-ready-to-remove");
                        b._showBusy(b._formatString(b.options.messages.deleteProggress,
                                                    k, a.length));
                        e >= a.length && h()
                    }, function () {
                        ++e;
                        e >= a.length && h()
                    })
                })
            }
        }, deleteRecord: function (a) {
            var b = this;
            a = c.extend({
                             clientOnly: !1,
                             animationsEnabled: b.options.animationsEnabled,
                             url: b.options.actions.deleteAction,
                             success: function () {
                             },
                             error: function () {
                             }
                         }, a);
            if (void 0 == a.key) {
                b._logWarn("options parameter in deleteRecord method must contain a key property.");
            } else {
                var e = b.getRowByKey(a.key);
                null == e ? b._logWarn("Can not found any row by key: " + a.key) : a.clientOnly ? (b._removeRowsFromTableWithAnimation(e, a.animationsEnabled),
                        a.success()) : b._deleteRecordFromServer(e, function (c) {
                    b._removeRowsFromTableWithAnimation(e, a.animationsEnabled);
                    a.success(c)
                }, function (c) {
                    b._showError(c);
                    a.error(c)
                }, a.url)
            }
        }, _addColumnsToHeaderRow: function (b) {
            a.apply(this, arguments);
            void 0 != this.options.actions.deleteAction && b.append(this._createEmptyCommandHeader())
        }, _addCellsToRowUsingRecord: function (a) {
            b.apply(this, arguments);
            var f = this;
            if (void 0 != f.options.actions.deleteAction) {
                var e = c("<span></span>").html(f.options.messages.deleteText), e = c('<button title="' +
                                                                                      f.options.messages.deleteText + '"></button>').addClass("jtable-command-button jtable-delete-command-button").append(e).click(function (b) {
                    b.preventDefault();
                    b.stopPropagation();
                    f._deleteButtonClickedForRow(a)
                });
                c("<td></td>").addClass("jtable-command-column").append(e).appendTo(a)
            }
        }, _deleteButtonClickedForRow: function (a) {
            var b = this, e, h = b.options.messages.deleteConfirmation;
            if (c.isFunction(b.options.deleteConfirmation)) {
                e = {
                    row: a, record: a.data("record"), deleteConfirm: !0, deleteConfirmMessage: h, cancel: !1,
                    cancelMessage: null
                };
                b.options.deleteConfirmation(e);
                if (e.cancel) {
                    e.cancelMessage && b._showError(e.cancelMessage);
                    return
                }
                h = e.deleteConfirmMessage;
                e = e.deleteConfirm
            } else {
                e = b.options.deleteConfirmation;
            }
            !1 != e ? (b._$deleteRecordDiv.find(".jtable-delete-confirm-message").html(h), b._showDeleteDialog(a)) : b._deleteRecordFromServer(a, function () {
                b._removeRowsFromTableWithAnimation(a)
            }, function (a) {
                b._showError(a)
            })
        }, _showDeleteDialog: function (a) {
            this._$deletingRow = a;
            this._$deleteRecordDiv.dialog("open")
        }, _deleteRecordFromServer: function (a,
                                              b, e, h) {
            var k = this, g = function (c) {
                "OK" != c.Result ? (a.data("deleting", !1), e && e(c.Message)) : (k._trigger("recordDeleted", null, {
                    record: a.data("record"),
                    row: a,
                    serverResponse: c
                }), b && b(c))
            };
            if (!0 != a.data("deleting")) {
                a.data("deleting", !0);
                var m = {};
                m[k._keyField] = k._getKeyValueOfRecord(a.data("record"));
                !h && c.isFunction(k.options.actions.deleteAction) ? (h = k.options.actions.deleteAction(m), k._isDeferredObject(h) ? h.done(function (a) {
                    g(a)
                }).fail(function () {
                    a.data("deleting", !1);
                    e && e(k.options.messages.serverCommunicationError)
                }) :
                                                                                                             g(h)) : this._ajax({
                                                                                                                                    url: h || k.options.actions.deleteAction,
                                                                                                                                    data: m,
                                                                                                                                    success: function (a) {
                                                                                                                                        g(a)
                                                                                                                                    },
                                                                                                                                    error: function () {
                                                                                                                                        a.data("deleting", !1);
                                                                                                                                        e && e(k.options.messages.serverCommunicationError)
                                                                                                                                    }
                                                                                                                                })
            }
        }, _removeRowsFromTableWithAnimation: function (a, b) {
            var c = this;
            void 0 == b && (b = c.options.animationsEnabled);
            if (b) {
                var h = "jtable-row-deleting";
                this.options.jqueryuiTheme && (h += " ui-state-disabled");
                a.stop(!0, !0).addClass(h, "slow", "").promise().done(function () {
                    c._removeRowsFromTable(a, "deleted")
                })
            } else {
                c._removeRowsFromTable(a,
                                       "deleted")
            }
        }
    })
})(jQuery);
(function (c) {
    var g = c.hik.jtable.prototype._create, a = c.hik.jtable.prototype._addColumnsToHeaderRow, b = c.hik.jtable.prototype._addCellsToRowUsingRecord, d = c.hik.jtable.prototype._onLoadingRecords, f = c.hik.jtable.prototype._onRecordsLoaded, e = c.hik.jtable.prototype._onRowsRemoved;
    c.extend(!0, c.hik.jtable.prototype, {
        options: {
            selecting: !1,
            multiselect: !1,
            selectingCheckboxes: !1,
            selectOnRowClick: !0,
            selectionChanged: function (a, b) {
            }
        }, _selectedRecordIdsBeforeLoad: null, _$selectAllCheckbox: null, _shiftKeyDown: !1, _create: function () {
            this.options.selecting &&
            this.options.selectingCheckboxes && (++this._firstDataColumnOffset, this._bindKeyboardEvents());
            g.apply(this, arguments)
        }, _bindKeyboardEvents: function () {
            var a = this;
            c(document).keydown(function (b) {
                switch (b.which) {
                    case 16:
                        a._shiftKeyDown = !0
                }
            }).keyup(function (b) {
                switch (b.which) {
                    case 16:
                        a._shiftKeyDown = !1
                }
            })
        }, selectedRows: function () {
            return this._getSelectedRows()
        }, selectRows: function (a) {
            this._selectRows(a);
            this._onSelectionChanged()
        }, _addColumnsToHeaderRow: function (b) {
            this.options.selecting && this.options.selectingCheckboxes &&
            (this.options.multiselect ? b.append(this._createSelectAllHeader()) : b.append(this._createEmptyCommandHeader()));
            a.apply(this, arguments)
        }, _addCellsToRowUsingRecord: function (a) {
            this.options.selecting && this._makeRowSelectable(a);
            b.apply(this, arguments)
        }, _onLoadingRecords: function () {
            this.options.selecting && this._storeSelectionList();
            d.apply(this, arguments)
        }, _onRecordsLoaded: function () {
            this.options.selecting && this._restoreSelectionList();
            f.apply(this, arguments)
        }, _onRowsRemoved: function (a, b) {
            this.options.selecting &&
            "reloading" != b && 0 < a.filter(".jtable-row-selected").length && this._onSelectionChanged();
            e.apply(this, arguments)
        }, _createSelectAllHeader: function () {
            var a = this, b = c('<th class=""></th>').addClass("jtable-command-column-header jtable-column-header-selecting");
            this._jqueryuiThemeAddClass(b, "ui-state-default");
            var d = c("<div />").addClass("jtable-column-header-container").appendTo(b);
            a._$selectAllCheckbox = c('<input type="checkbox" />').appendTo(d).click(function () {
                if (0 >= a._$tableRows.length) {
                    a._$selectAllCheckbox.attr("checked",
                                               !1);
                } else {
                    var b = a._$tableBody.find(">tr.jtable-data-row");
                    a._$selectAllCheckbox.is(":checked") ? a._selectRows(b) : a._deselectRows(b);
                    a._onSelectionChanged()
                }
            });
            return b
        }, _storeSelectionList: function () {
            var a = this;
            a.options.selecting && (a._selectedRecordIdsBeforeLoad = [], a._getSelectedRows().each(function () {
                a._selectedRecordIdsBeforeLoad.push(a._getKeyValueOfRecord(c(this).data("record")))
            }))
        }, _restoreSelectionList: function () {
            if (this.options.selecting) {
                for (var a = 0, b = 0; b < this._$tableRows.length; ++b) {
                    var d =
                            this._getKeyValueOfRecord(this._$tableRows[b].data("record"));
                    -1 < c.inArray(d, this._selectedRecordIdsBeforeLoad) && (this._selectRows(this._$tableRows[b]), ++a)
                }
                0 < this._selectedRecordIdsBeforeLoad.length && this._selectedRecordIdsBeforeLoad.length != a && this._onSelectionChanged();
                this._selectedRecordIdsBeforeLoad = [];
                this._refreshSelectAllCheckboxState()
            }
        }, _getSelectedRows: function () {
            return this._$tableBody.find(">tr.jtable-row-selected")
        }, _makeRowSelectable: function (a) {
            var b = this;
            b.options.selectOnRowClick &&
            a.click(function () {
                b._invertRowSelection(a)
            });
            if (b.options.selectingCheckboxes) {
                var d = c("<td></td>").addClass("jtable-selecting-column"), e = c('<input type="checkbox" />').appendTo(d);
                b.options.selectOnRowClick || e.click(function () {
                    b._invertRowSelection(a)
                });
                a.append(d)
            }
        }, _invertRowSelection: function (a) {
            if (a.hasClass("jtable-row-selected")) {
                this._deselectRows(a);
            } else if (this._shiftKeyDown) {
                var b = this._findRowIndex(a), c = this._findFirstSelectedRowIndexBeforeIndex(b) + 1;
                0 < c && c < b ? this._selectRows(this._$tableBody.find("tr").slice(c,
                                                                                    b + 1)) : (c = this._findFirstSelectedRowIndexAfterIndex(b) - 1, c > b ? this._selectRows(this._$tableBody.find("tr").slice(b, c + 1)) : this._selectRows(a))
            } else {
                this._selectRows(a);
            }
            this._onSelectionChanged()
        }, _findFirstSelectedRowIndexBeforeIndex: function (a) {
            for (a -= 1; 0 <= a; --a) {
                if (this._$tableRows[a].hasClass("jtable-row-selected")) {
                    return a;
                }
            }
            return -1
        }, _findFirstSelectedRowIndexAfterIndex: function (a) {
            for (a += 1; a < this._$tableRows.length; ++a) {
                if (this._$tableRows[a].hasClass("jtable-row-selected")) {
                    return a;
                }
            }
            return -1
        }, _selectRows: function (a) {
            this.options.multiselect ||
            this._deselectRows(this._getSelectedRows());
            a.addClass("jtable-row-selected");
            this._jqueryuiThemeAddClass(a, "ui-state-highlight");
            this.options.selectingCheckboxes && a.find(">td.jtable-selecting-column >input").prop("checked", !0);
            this._refreshSelectAllCheckboxState()
        }, _deselectRows: function (a) {
            a.removeClass("jtable-row-selected ui-state-highlight");
            this.options.selectingCheckboxes && a.find(">td.jtable-selecting-column >input").prop("checked", !1);
            this._refreshSelectAllCheckboxState()
        }, _refreshSelectAllCheckboxState: function () {
            if (this.options.selectingCheckboxes &&
                this.options.multiselect) {
                var a = this._$tableRows.length, b = this._getSelectedRows().length;
                0 == b ? (this._$selectAllCheckbox.prop("indeterminate", !1), this._$selectAllCheckbox.attr("checked", !1)) : b == a ? (this._$selectAllCheckbox.prop("indeterminate", !1), this._$selectAllCheckbox.attr("checked", !0)) : (this._$selectAllCheckbox.attr("checked", !1), this._$selectAllCheckbox.prop("indeterminate", !0))
            }
        }, _onSelectionChanged: function () {
            this._trigger("selectionChanged", null, {})
        }
    })
})(jQuery);
(function (c) {
    var g = c.hik.jtable.prototype.load, a = c.hik.jtable.prototype._create, b = c.hik.jtable.prototype._setOption, d = c.hik.jtable.prototype._createRecordLoadUrl, f = c.hik.jtable.prototype._createJtParamsForLoading, e = c.hik.jtable.prototype._addRowToTable, h = c.hik.jtable.prototype._addRow, k = c.hik.jtable.prototype._removeRowsFromTable, l = c.hik.jtable.prototype._onRecordsLoaded;
    c.extend(!0, c.hik.jtable.prototype, {
        options: {
            paging: !1,
            pageList: "normal",
            pageSize: 10,
            pageSizes: [10, 25, 50, 100, 250, 500],
            pageSizeChangeArea: !0,
            gotoPageArea: "combobox",
            messages: {
                pagingInfo: "Showing {0}-{1} of {2}",
                pageSizeChangeLabel: "Row count",
                gotoPageLabel: "Go to page"
            }
        },
        _$bottomPanel: null,
        _$pagingListArea: null,
        _$pageSizeChangeArea: null,
        _$pageInfoSpan: null,
        _$gotoPageArea: null,
        _$gotoPageInput: null,
        _totalRecordCount: 0,
        _currentPageNo: 1,
        _create: function () {
            a.apply(this, arguments);
            this.options.paging && (this._loadPagingSettings(), this._createBottomPanel(), this._createPageListArea(), this._createGotoPageInput(), this._createPageSizeSelection())
        },
        _loadPagingSettings: function () {
            if (this.options.saveUserPreferences) {
                var a = this._getCookie("page-size");
                a && (this.options.pageSize = this._normalizeNumber(a, 1, 1E6, this.options.pageSize))
            }
        },
        _createBottomPanel: function () {
            this._$bottomPanel = c("<div />").addClass("jtable-bottom-panel").insertAfter(this._$table);
            this._jqueryuiThemeAddClass(this._$bottomPanel, "ui-state-default");
            c("<div />").addClass("jtable-left-area").appendTo(this._$bottomPanel);
            c("<div />").addClass("jtable-right-area").appendTo(this._$bottomPanel)
        },
        _createPageListArea: function () {
            this._$pagingListArea = c("<span></span>").addClass("jtable-page-list").appendTo(this._$bottomPanel.find(".jtable-left-area"));
            this._$pageInfoSpan = c("<span></span>").addClass("jtable-page-info").appendTo(this._$bottomPanel.find(".jtable-right-area"))
        },
        _createPageSizeSelection: function () {
            var a = this;
            if (a.options.pageSizeChangeArea) {
                0 > a._findIndexInArray(a.options.pageSize, a.options.pageSizes) && (a.options.pageSizes.push(parseInt(a.options.pageSize)), a.options.pageSizes.sort(function (a,
                                                                                                                                                                                b) {
                    return a - b
                }));
                a._$pageSizeChangeArea = c("<span></span>").addClass("jtable-page-size-change").appendTo(a._$bottomPanel.find(".jtable-left-area"));
                a._$pageSizeChangeArea.append("<span>" + a.options.messages.pageSizeChangeLabel + ": </span>");
                for (var b = c("<select></select>").appendTo(a._$pageSizeChangeArea), d = 0; d < a.options.pageSizes.length; d++) {
                    b.append('<option value="' + a.options.pageSizes[d] + '">' + a.options.pageSizes[d] + "</option>");
                }
                b.val(a.options.pageSize);
                b.change(function () {
                    a._changePageSize(parseInt(c(this).val()))
                })
            }
        },
        _createGotoPageInput: function () {
            var a = this;
            a.options.gotoPageArea && "none" != a.options.gotoPageArea && (this._$gotoPageArea = c("<span></span>").addClass("jtable-goto-page").appendTo(a._$bottomPanel.find(".jtable-left-area")), this._$gotoPageArea.append("<span>" + a.options.messages.gotoPageLabel + ": </span>"), "combobox" == a.options.gotoPageArea ? (a._$gotoPageInput = c("<select></select>").appendTo(this._$gotoPageArea).data("pageCount", 1).change(function () {
                a._changePage(parseInt(c(this).val()))
            }), a._$gotoPageInput.append('<option value="1">1</option>')) :
                                                                                                                                                                                                                                                                                             a._$gotoPageInput = c('<input type="text" maxlength="10" value="' + a._currentPageNo + '" />').appendTo(this._$gotoPageArea).keypress(function (b) {
                                                                                                                                                                                                                                                                                                 13 == b.which ? (b.preventDefault(), a._changePage(parseInt(a._$gotoPageInput.val()))) : 43 == b.which ? (b.preventDefault(), a._changePage(parseInt(a._$gotoPageInput.val()) + 1)) : 45 == b.which ? (b.preventDefault(), a._changePage(parseInt(a._$gotoPageInput.val()) - 1)) : 47 < b.keyCode && 58 > b.keyCode && !1 == b.shiftKey && !1 == b.altKey || 8 == b.keyCode || 9 == b.keyCode || b.preventDefault()
                                                                                                                                                                                                                                                                                             }))
        },
        _refreshGotoPageInput: function () {
            if (this.options.gotoPageArea &&
                "none" != this.options.gotoPageArea) {
                0 >= this._totalRecordCount ? this._$gotoPageArea.hide() : this._$gotoPageArea.show();
                if ("combobox" == this.options.gotoPageArea) {
                    var a = this._$gotoPageInput.data("pageCount"), b = this._calculatePageCount();
                    if (a != b) {
                        this._$gotoPageInput.empty();
                        a = 1;
                        1E4 < b ? a = 100 : 5E3 < b ? a = 10 : 2E3 < b ? a = 5 : 1E3 < b && (a = 2);
                        for (var c = a; c <= b; c += a) {
                            this._$gotoPageInput.append('<option value="' + c + '">' + c + "</option>");
                        }
                        this._$gotoPageInput.data("pageCount", b)
                    }
                }
                this._$gotoPageInput.val(this._currentPageNo)
            }
        },
        load: function () {
            this._currentPageNo =
            1;
            g.apply(this, arguments)
        },
        _setOption: function (a, c) {
            b.apply(this, arguments);
            "pageSize" == a && this._changePageSize(parseInt(c))
        },
        _changePageSize: function (a) {
            if (a != this.options.pageSize) {
                this.options.pageSize = a;
                var b = this._calculatePageCount();
                this._currentPageNo > b && (this._currentPageNo = b);
                0 >= this._currentPageNo && (this._currentPageNo = 1);
                b = this._$bottomPanel.find(".jtable-page-size-change select");
                0 < b.length && parseInt(b.val()) != a && 0 < b.find("option[value=" + a + "]").length && b.val(a);
                this._savePagingSettings();
                this._reloadTable()
            }
        },
        _savePagingSettings: function () {
            this.options.saveUserPreferences && this._setCookie("page-size", this.options.pageSize)
        },
        _createRecordLoadUrl: function () {
            var a = d.apply(this, arguments);
            return a = this._addPagingInfoToUrl(a, this._currentPageNo)
        },
        _createJtParamsForLoading: function () {
            var a = f.apply(this, arguments);
            this.options.paging && (a.jtStartIndex = (this._currentPageNo - 1) * this.options.pageSize, a.jtPageSize = this.options.pageSize);
            return a
        },
        _addRowToTable: function (a, b, c) {
            c && this.options.paging ?
            this._reloadTable() : e.apply(this, arguments)
        },
        _addRow: function (a, b) {
            b && b.isNewRow && this.options.paging ? this._reloadTable() : h.apply(this, arguments)
        },
        _removeRowsFromTable: function (a, b) {
            k.apply(this, arguments);
            this.options.paging && (0 >= this._$tableRows.length && 1 < this._currentPageNo && --this._currentPageNo, this._reloadTable())
        },
        _onRecordsLoaded: function (a) {
            this.options.paging && (this._totalRecordCount = a.TotalRecordCount, this._createPagingList(), this._createPagingInfo(), this._refreshGotoPageInput());
            l.apply(this,
                    arguments)
        },
        _addPagingInfoToUrl: function (a, b) {
            if (!this.options.paging) {
                return a;
            }
            var c = (b - 1) * this.options.pageSize, d = this.options.pageSize;
            return a + (0 > a.indexOf("?") ? "?" : "&") + "jtStartIndex=" + c + "&jtPageSize=" + d
        },
        _createPagingList: function () {
            if (!(0 >= this.options.pageSize || (this._$pagingListArea.empty(), 0 >= this._totalRecordCount))) {
                var a = this._calculatePageCount();
                this._createFirstAndPreviousPageButtons();
                "normal" == this.options.pageList && this._createPageNumberButtons(this._calculatePageNumbers(a));
                this._createLastAndNextPageButtons(a);
                this._bindClickEventsToPageNumberButtons()
            }
        },
        _createFirstAndPreviousPageButtons: function () {
            var a = c("<span></span>").addClass("jtable-page-number-first").html("&lt&lt").data("pageNumber", 1).appendTo(this._$pagingListArea), b = c("<span></span>").addClass("jtable-page-number-previous").html("&lt").data("pageNumber", this._currentPageNo - 1).appendTo(this._$pagingListArea);
            this._jqueryuiThemeAddClass(a, "ui-button ui-state-default", "ui-state-hover");
            this._jqueryuiThemeAddClass(b, "ui-button ui-state-default",
                                        "ui-state-hover");
            1 >= this._currentPageNo && (a.addClass("jtable-page-number-disabled"), b.addClass("jtable-page-number-disabled"), this._jqueryuiThemeAddClass(a, "ui-state-disabled"), this._jqueryuiThemeAddClass(b, "ui-state-disabled"))
        },
        _createLastAndNextPageButtons: function (a) {
            var b = c("<span></span>").addClass("jtable-page-number-next").html("&gt").data("pageNumber", this._currentPageNo + 1).appendTo(this._$pagingListArea), d = c("<span></span>").addClass("jtable-page-number-last").html("&gt&gt").data("pageNumber",
                                                                                                                                                                                                                                                   a).appendTo(this._$pagingListArea);
            this._jqueryuiThemeAddClass(b, "ui-button ui-state-default", "ui-state-hover");
            this._jqueryuiThemeAddClass(d, "ui-button ui-state-default", "ui-state-hover");
            this._currentPageNo >= a && (b.addClass("jtable-page-number-disabled"), d.addClass("jtable-page-number-disabled"), this._jqueryuiThemeAddClass(b, "ui-state-disabled"), this._jqueryuiThemeAddClass(d, "ui-state-disabled"))
        },
        _createPageNumberButtons: function (a) {
            for (var b = 0, d = 0; d < a.length; d++) {
                1 < a[d] - b && c("<span></span>").addClass("jtable-page-number-space").html("...").appendTo(this._$pagingListArea),
                        this._createPageNumberButton(a[d]), b = a[d]
            }
        },
        _createPageNumberButton: function (a) {
            var b = c("<span></span>").addClass("jtable-page-number").html(a).data("pageNumber", a).appendTo(this._$pagingListArea);
            this._jqueryuiThemeAddClass(b, "ui-button ui-state-default", "ui-state-hover");
            this._currentPageNo == a && (b.addClass("jtable-page-number-active jtable-page-number-disabled"), this._jqueryuiThemeAddClass(b, "ui-state-active"))
        },
        _calculatePageCount: function () {
            var a = Math.floor(this._totalRecordCount / this.options.pageSize);
            0 != this._totalRecordCount % this.options.pageSize && ++a;
            return a
        },
        _calculatePageNumbers: function (a) {
            if (4 >= a) {
                for (var b = [], c = 1; c <= a; ++c) {
                    b.push(c);
                }
                return b
            }
            b = [1, 2, a - 1, a];
            c = this._normalizeNumber(this._currentPageNo - 1, 1, a, 1);
            a = this._normalizeNumber(this._currentPageNo + 1, 1, a, 1);
            this._insertToArrayIfDoesNotExists(b, c);
            this._insertToArrayIfDoesNotExists(b, this._currentPageNo);
            this._insertToArrayIfDoesNotExists(b, a);
            b.sort(function (a, b) {
                return a - b
            });
            return b
        },
        _createPagingInfo: function () {
            if (0 >= this._totalRecordCount) {
                this._$pageInfoSpan.empty();
            } else {
                var a = (this._currentPageNo - 1) * this.options.pageSize + 1, b = this._currentPageNo * this.options.pageSize, b = this._normalizeNumber(b, a, this._totalRecordCount, 0);
                b >= a && (a = this._formatString(this.options.messages.pagingInfo, a, b, this._totalRecordCount), this._$pageInfoSpan.html(a))
            }
        },
        _bindClickEventsToPageNumberButtons: function () {
            var a = this;
            a._$pagingListArea.find(".jtable-page-number,.jtable-page-number-previous,.jtable-page-number-next,.jtable-page-number-first,.jtable-page-number-last").not(".jtable-page-number-disabled").click(function (b) {
                b.preventDefault();
                a._changePage(c(this).data("pageNumber"))
            })
        },
        _changePage: function (a) {
            a = this._normalizeNumber(a, 1, this._calculatePageCount(), 1);
            a == this._currentPageNo ? this._refreshGotoPageInput() : (this._currentPageNo = a, this._reloadTable())
        }
    })
})(jQuery);
(function (c) {
    var g = c.hik.jtable.prototype._initializeFields, a = c.hik.jtable.prototype._normalizeFieldOptions, b = c.hik.jtable.prototype._createHeaderCellForField, d = c.hik.jtable.prototype._createRecordLoadUrl, f = c.hik.jtable.prototype._createJtParamsForLoading;
    c.extend(!0, c.hik.jtable.prototype, {
        options: {sorting: !1, multiSorting: !1, defaultSorting: ""},
        _lastSorting: null,
        _initializeFields: function () {
            g.apply(this, arguments);
            this._lastSorting = [];
            this.options.sorting && this._buildDefaultSortingArray()
        },
        _normalizeFieldOptions: function (b,
                                          c) {
            a.apply(this, arguments);
            c.sorting = !1 != c.sorting
        },
        _createHeaderCellForField: function (a, c) {
            var d = b.apply(this, arguments);
            this.options.sorting && c.sorting && this._makeColumnSortable(d, a);
            return d
        },
        _createRecordLoadUrl: function () {
            var a = d.apply(this, arguments);
            return a = this._addSortingInfoToUrl(a)
        },
        _buildDefaultSortingArray: function () {
            var a = this;
            c.each(a.options.defaultSorting.split(","), function (b, d) {
                c.each(a.options.fields, function (b, c) {
                    if (c.sorting) {
                        var f = d.indexOf(b);
                        -1 < f && (-1 < d.toUpperCase().indexOf(" DESC",
                                                                f) ? a._lastSorting.push({
                                                                                             fieldName: b,
                                                                                             sortOrder: "DESC"
                                                                                         }) : a._lastSorting.push({
                                                                                                                      fieldName: b,
                                                                                                                      sortOrder: "ASC"
                                                                                                                  }))
                    }
                })
            })
        },
        _makeColumnSortable: function (a, b) {
            var d = this;
            a.addClass("jtable-column-header-sortable").click(function (b) {
                b.preventDefault();
                d.options.multiSorting && b.ctrlKey || (d._lastSorting = []);
                d._sortTableByColumn(a)
            });
            c.each(this._lastSorting, function (c, d) {
                d.fieldName == b && ("DESC" == d.sortOrder ? a.addClass("jtable-column-header-sorted-desc") : a.addClass("jtable-column-header-sorted-asc"))
            })
        },
        _sortTableByColumn: function (a) {
            0 ==
            this._lastSorting.length && a.siblings().removeClass("jtable-column-header-sorted-asc jtable-column-header-sorted-desc");
            for (var b = 0; b < this._lastSorting.length; b++) {
                this._lastSorting[b].fieldName == a.data("fieldName") && this._lastSorting.splice(b--, 1);
            }
            a.hasClass("jtable-column-header-sorted-asc") ? (a.removeClass("jtable-column-header-sorted-asc").addClass("jtable-column-header-sorted-desc"), this._lastSorting.push({
                                                                                                                                                                                       fieldName: a.data("fieldName"),
                                                                                                                                                                                       sortOrder: "DESC"
                                                                                                                                                                                   })) : (a.removeClass("jtable-column-header-sorted-desc").addClass("jtable-column-header-sorted-asc"),
                    this._lastSorting.push({fieldName: a.data("fieldName"), sortOrder: "ASC"}));
            this._reloadTable()
        },
        _addSortingInfoToUrl: function (a) {
            if (!this.options.sorting || 0 == this._lastSorting.length) {
                return a;
            }
            var b = [];
            c.each(this._lastSorting, function (a, c) {
                b.push(c.fieldName + " " + c.sortOrder)
            });
            return a + (0 > a.indexOf("?") ? "?" : "&") + "jtSorting=" + b.join(",")
        },
        _createJtParamsForLoading: function () {
            var a = f.apply(this, arguments);
            if (this.options.sorting && this._lastSorting.length) {
                var b = [];
                c.each(this._lastSorting, function (a,
                                                    c) {
                    b.push(c.fieldName + " " + c.sortOrder)
                });
                a.jtSorting = b.join(",")
            }
            return a
        }
    })
})(jQuery);
(function (c) {
    var g = c.hik.jtable.prototype._create, a = c.hik.jtable.prototype._normalizeFieldOptions, b = c.hik.jtable.prototype._createHeaderCellForField, d = c.hik.jtable.prototype._createCellForRecordField;
    c.extend(!0, c.hik.jtable.prototype, {
        options: {tableId: void 0, columnResizable: !0, columnSelectable: !0},
        _$columnSelectionDiv: null,
        _$columnResizeBar: null,
        _cookieKeyPrefix: null,
        _currentResizeArgs: null,
        _create: function () {
            g.apply(this, arguments);
            this._createColumnResizeBar();
            this._createColumnSelection();
            this.options.saveUserPreferences &&
            this._loadColumnSettings();
            this._normalizeColumnWidths()
        },
        _normalizeFieldOptions: function (b, c) {
            a.apply(this, arguments);
            this.options.columnResizable && (c.columnResizable = !1 != c.columnResizable);
            c.visibility || (c.visibility = "visible")
        },
        _createHeaderCellForField: function (a, c) {
            var d = b.apply(this, arguments);
            this.options.columnResizable && c.columnResizable && a != this._columnList[this._columnList.length - 1] && this._makeColumnResizable(d);
            "hidden" == c.visibility && d.hide();
            return d
        },
        _createCellForRecordField: function (a,
                                             b) {
            var c = d.apply(this, arguments);
            "hidden" == this.options.fields[b].visibility && c.hide();
            return c
        },
        changeColumnVisibility: function (a, b) {
            this._changeColumnVisibilityInternal(a, b);
            this._normalizeColumnWidths();
            this.options.saveUserPreferences && this._saveColumnSettings()
        },
        _changeColumnVisibilityInternal: function (a, b) {
            var c = this._columnList.indexOf(a);
            if (0 > c) {
                this._logWarn('Column "' + a + '" does not exist in fields!');
            } else if (0 > ["visible", "hidden", "fixed"].indexOf(b)) {
                this._logWarn('Visibility value is not valid: "' +
                              b + '"! Options are: visible, hidden, fixed.');
            } else {
                var d = this.options.fields[a];
                d.visibility != b && (c = this._firstDataColumnOffset + c + 1, "hidden" != d.visibility && "hidden" == b ? this._$table.find(">thead >tr >th:nth-child(" + c + "),>tbody >tr >td:nth-child(" + c + ")").hide() : "hidden" == d.visibility && "hidden" != b && this._$table.find(">thead >tr >th:nth-child(" + c + "),>tbody >tr >td:nth-child(" + c + ")").show().css("display", "table-cell"), d.visibility = b)
            }
        },
        _createColumnSelection: function () {
            var a = this;
            this._$columnSelectionDiv =
            c("<div />").addClass("jtable-column-selection-container").appendTo(a._$mainContainer);
            this._$table.children("thead").bind("contextmenu", function (b) {
                if (a.options.columnSelectable) {
                    b.preventDefault();
                    c("<div />").addClass("jtable-contextmenu-overlay").click(function () {
                        c(this).remove();
                        a._$columnSelectionDiv.hide()
                    }).bind("contextmenu", function () {
                        return !1
                    }).appendTo(document.body);
                    a._fillColumnSelection();
                    var d = a._$mainContainer.offset(), g = b.pageY - d.top;
                    b = b.pageX - d.left;
                    d = a._$mainContainer.width();
                    100 < d && b > d - 100 && (b = d - 100);
                    a._$columnSelectionDiv.css({left: b, top: g, "min-width": "100px"}).show()
                }
            })
        },
        _fillColumnSelection: function () {
            for (var a = this, b = c("<ul></ul>").addClass("jtable-column-select-list"), d = 0; d < this._columnList.length; d++) {
                var g = this._columnList[d], l = this.options.fields[g], m = c("<li></li>").appendTo(b), m = c('<label for="' + g + '"></label>').append(c("<span>" + (l.title || g) + "</span>")).appendTo(m), g = c('<input type="checkbox" name="' + g + '">').prependTo(m).click(function () {
                    var b = c(this), d = b.attr("name");
                    "fixed" != a.options.fields[d].visibility && a.changeColumnVisibility(d, b.is(":checked") ? "visible" : "hidden")
                });
                "hidden" != l.visibility && g.attr("checked", "checked");
                "fixed" == l.visibility && g.attr("disabled", "disabled")
            }
            this._$columnSelectionDiv.html(b)
        },
        _createColumnResizeBar: function () {
            this._$columnResizeBar = c("<div />").addClass("jtable-column-resize-bar").appendTo(this._$mainContainer).hide()
        },
        _makeColumnResizable: function (a) {
            var b = this;
            c("<div />").addClass("jtable-column-resize-handler").appendTo(a.find(".jtable-column-header-container")).mousedown(function (d) {
                d.preventDefault();
                d.stopPropagation();
                var g = b._$mainContainer.offset(), l = a.nextAll("th.jtable-column-header:visible:first");
                if (l.length) {
                    b._currentResizeArgs = {
                        currentColumnStartWidth: a.outerWidth(),
                        minWidth: 10,
                        maxWidth: a.outerWidth() + l.outerWidth() - 10,
                        mouseStartX: d.pageX,
                        minResizeX: function () {
                            return this.mouseStartX - (this.currentColumnStartWidth - this.minWidth)
                        },
                        maxResizeX: function () {
                            return this.mouseStartX + (this.maxWidth - this.currentColumnStartWidth)
                        }
                    };
                    var m = function (a) {
                        b._currentResizeArgs && (a = b._normalizeNumber(a.pageX,
                                                                        b._currentResizeArgs.minResizeX(), b._currentResizeArgs.maxResizeX()), b._$columnResizeBar.css("left", a - g.left + "px"))
                    }, n = function (d) {
                        if (b._currentResizeArgs) {
                            c(document).unbind("mousemove", m);
                            c(document).unbind("mouseup", n);
                            b._$columnResizeBar.hide();
                            d = b._normalizeNumber(b._currentResizeArgs.currentColumnStartWidth + (d.pageX - b._currentResizeArgs.mouseStartX), b._currentResizeArgs.minWidth, b._currentResizeArgs.maxWidth);
                            var g = l.outerWidth() + (b._currentResizeArgs.currentColumnStartWidth - d), h = a.data("width-in-percent") /
                                                                                                             b._currentResizeArgs.currentColumnStartWidth;
                            a.data("width-in-percent", d * h);
                            l.data("width-in-percent", g * h);
                            a.css("width", a.data("width-in-percent") + "%");
                            l.css("width", l.data("width-in-percent") + "%");
                            b._normalizeColumnWidths();
                            b._currentResizeArgs = null;
                            b.options.saveUserPreferences && b._saveColumnSettings()
                        }
                    };
                    b._$columnResizeBar.show().css({
                                                       top:    a.offset().top - g.top + "px",
                                                       left:   d.pageX - g.left + "px",
                                                       height: b._$table.outerHeight() + "px"
                                                   });
                    c(document).bind("mousemove", m);
                    c(document).bind("mouseup", n)
                }
            })
        },
        _normalizeColumnWidths: function () {
            var a =
                    this._$table.find(">thead th.jtable-command-column-header").data("width-in-percent", 1).css("width", "1%"), b = this._$table.find(">thead th.jtable-column-header"), d = 0;
            b.each(function () {
                var a = c(this);
                a.is(":visible") && (d += a.outerWidth())
            });
            var g = {}, l = 100 - a.length;
            b.each(function () {
                var a = c(this);
                if (a.is(":visible")) {
                    var b = a.data("fieldName"), a = a.outerWidth() * l / d;
                    g[b] = a
                }
            });
            b.each(function () {
                var a = c(this);
                if (a.is(":visible")) {
                    var b = a.data("fieldName");
                    a.data("width-in-percent", g[b]).css("width", g[b] + "%")
                }
            })
        },
        _saveColumnSettings: function () {
            var a = this, b = "";
            this._$table.find(">thead >tr >th.jtable-column-header").each(function () {
                var d = c(this), g = d.data("fieldName"), d = d.data("width-in-percent");
                b = b + (g + "=" + a.options.fields[g].visibility + ";" + d) + "|"
            });
            this._setCookie("column-settings", b.substr(0, b.length - 1))
        },
        _loadColumnSettings: function () {
            var a = this, b = this._getCookie("column-settings");
            if (b) {
                var d = {};
                c.each(b.split("|"), function (a, b) {
                    var c = b.split("="), e = c[0], c = c[1].split(";");
                    d[e] = {columnVisibility: c[0], columnWidth: c[1]}
                });
                this._$table.find(">thead >tr >th.jtable-column-header").each(function () {
                    var b = c(this), e = b.data("fieldName"), g = a.options.fields[e];
                    d[e] && ("fixed" != g.visibility && a._changeColumnVisibilityInternal(e, d[e].columnVisibility), b.data("width-in-percent", d[e].columnWidth).css("width", d[e].columnWidth + "%"))
                })
            }
        }
    })
})(jQuery);
(function (c) {
    var g = c.hik.jtable.prototype._removeRowsFromTable;
    c.extend(!0, c.hik.jtable.prototype, {
        options: {openChildAsAccordion: !1}, openChildTable: function (a, b, d) {
            var f = this;
            void 0 == b.jqueryuiTheme && (b.jqueryuiTheme = f.options.jqueryuiTheme);
            b.showCloseButton = !1 != b.showCloseButton;
            b.showCloseButton && !b.closeRequested && (b.closeRequested = function () {
                f.closeChildTable(a)
            });
            f.options.openChildAsAccordion && a.siblings(".jtable-data-row").each(function () {
                f.closeChildTable(c(this))
            });
            f.closeChildTable(a, function () {
                var e =
                        f.getChildRow(a).children("td").empty(), g = c("<div />").addClass("jtable-child-table-container").appendTo(e);
                e.data("childTable", g);
                g.jtable(b);
                f.openChildRow(a);
                g.hide().slideDown("fast", function () {
                    d && d({childTable: g})
                })
            })
        }, closeChildTable: function (a, b) {
            var c = this, f = this.getChildRow(a).children("td"), e = f.data("childTable");
            e ? (f.data("childTable", null), e.slideUp("fast", function () {
                e.jtable("destroy");
                e.remove();
                c.closeChildRow(a);
                b && b()
            })) : b && b()
        }, isChildRowOpen: function (a) {
            return this.getChildRow(a).is(":visible")
        },
        getChildRow: function (a) {
            return a.data("childRow") || this._createChildRow(a)
        }, openChildRow: function (a) {
            a = this.getChildRow(a);
            a.is(":visible") || a.show();
            return a
        }, closeChildRow: function (a) {
            a = this.getChildRow(a);
            a.is(":visible") && a.hide()
        }, _removeRowsFromTable: function (a, b) {
            "deleted" == b && a.each(function () {
                var a = c(this).data("childRow");
                a && a.remove()
            });
            g.apply(this, arguments)
        }, _createChildRow: function (a) {
            var b = this._$table.find("thead th").length, b = c("<tr></tr>").addClass("jtable-child-row").append('<td colspan="' +
                                                                                                                 b + '"></td>');
            a.after(b);
            a.data("childRow", b);
            b.hide();
            return b
        }
    })
})(jQuery);