/*
 * Copyright (c) 2015, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.wso2.carbon.analytics.restapi.beans;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;

/**
 * The bean class for column types
 */
@XmlType(name = "columnType")
@XmlEnum
public enum  ColumnTypeBean {

    @XmlEnumValue("STRING")
    STRING,

    @XmlEnumValue("INTEGER")
    INTEGER,

    @XmlEnumValue("LONG")
    LONG,

    @XmlEnumValue("FLOAT")
    FLOAT,

    @XmlEnumValue("DOUBLE")
    DOUBLE,

    @XmlEnumValue("BOOLEAN")
    BOOLEAN,

    @XmlEnumValue("BINARY")
    BINARY,

    @XmlEnumValue("FACET")
    FACET

}
