/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.daohib.bpel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.ProcessState;
import org.apache.ode.bpel.dao.ActivityRecoveryDAO;
import org.apache.ode.bpel.dao.BpelDAOConnection;
import org.apache.ode.bpel.dao.CorrelationSetDAO;
import org.apache.ode.bpel.dao.CorrelatorDAO;
import org.apache.ode.bpel.dao.FaultDAO;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.dao.ProcessDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.bpel.dao.ScopeDAO;
import org.apache.ode.bpel.dao.ScopeStateEnum;
import org.apache.ode.bpel.dao.XmlDataDAO;
import org.apache.ode.bpel.evt.BpelEvent;
import org.apache.ode.bpel.evt.ProcessInstanceEvent;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.daohib.SessionManager;
import org.apache.ode.daohib.bpel.ActivityRecoveryDaoImpl;
import org.apache.ode.daohib.bpel.BpelDAOConnectionImpl;
import org.apache.ode.daohib.bpel.CorrelationSetDaoImpl;
import org.apache.ode.daohib.bpel.CorrelatorDaoImpl;
import org.apache.ode.daohib.bpel.FaultDAOImpl;
import org.apache.ode.daohib.bpel.HibernateDao;
import org.apache.ode.daohib.bpel.MessageExchangeDaoImpl;
import org.apache.ode.daohib.bpel.ProcessDaoImpl;
import org.apache.ode.daohib.bpel.ScopeDaoImpl;
import org.apache.ode.daohib.bpel.XmlDataDaoImpl;
import org.apache.ode.daohib.bpel.hobj.HActivityRecovery;
import org.apache.ode.daohib.bpel.hobj.HBpelEvent;
import org.apache.ode.daohib.bpel.hobj.HCorrelationProperty;
import org.apache.ode.daohib.bpel.hobj.HCorrelationSet;
import org.apache.ode.daohib.bpel.hobj.HCorrelatorMessage;
import org.apache.ode.daohib.bpel.hobj.HCorrelatorSelector;
import org.apache.ode.daohib.bpel.hobj.HFaultData;
import org.apache.ode.daohib.bpel.hobj.HMessage;
import org.apache.ode.daohib.bpel.hobj.HMessageExchange;
import org.apache.ode.daohib.bpel.hobj.HMessageExchangeProperty;
import org.apache.ode.daohib.bpel.hobj.HPartnerLink;
import org.apache.ode.daohib.bpel.hobj.HProcessInstance;
import org.apache.ode.daohib.bpel.hobj.HScope;
import org.apache.ode.daohib.bpel.hobj.HVariableProperty;
import org.apache.ode.daohib.bpel.hobj.HXmlData;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.QNameUtils;
import org.apache.ode.utils.stl.CollectionsX;
import org.apache.ode.utils.stl.UnaryFunction;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.w3c.dom.Element;

public class ProcessInstanceDaoImpl
extends HibernateDao
implements ProcessInstanceDAO {
    private static final Log __log = LogFactory.getLog(ProcessInstanceDaoImpl.class);
    private static final String QRY_DELSELECTORS = "delete from " + HCorrelatorSelector.class.getName() + " where instance = ?";
    private static final String QRY_VARIABLES = "from " + HXmlData.class.getName() + " as x where x.name = ? and x.scope.scopeModelId = ? and x.scope.instance.id = ?";
    private static final String QRY_RECOVERIES = "from " + HActivityRecovery.class.getName() + " AS x WHERE x.instance.id = ?";
    private HProcessInstance _instance;
    private ScopeDAO _root;

    public ProcessInstanceDaoImpl(SessionManager sm, HProcessInstance instance) {
        super(sm, instance);
        this.entering("ProcessInstanceDaoImpl.ProcessInstanceDaoImpl");
        this._instance = instance;
    }

    public Date getCreateTime() {
        return this._instance.getCreated();
    }

    public void setFault(FaultDAO fault) {
        this.entering("ProcessInstanceDaoImpl.setFault");
        this._instance.setFault(((FaultDAOImpl)fault)._self);
        this.getSession().update((Object)this._instance);
    }

    public void setFault(QName name, String explanation, int lineNo, int activityId, Element faultData) {
        this.entering("ProcessInstanceDaoImpl.setFault");
        if (this._instance.getFault() != null) {
            this.getSession().delete((Object)this._instance.getFault());
        }
        HFaultData fault = new HFaultData();
        fault.setName(QNameUtils.fromQName((QName)name));
        fault.setExplanation(explanation);
        fault.setLineNo(lineNo);
        fault.setActivityId(activityId);
        if (faultData != null) {
            fault.setData(DOMUtils.domToBytes((Element)faultData));
        }
        this._instance.setFault(fault);
        this.getSession().save((Object)fault);
        this.getSession().update((Object)this._instance);
    }

    public FaultDAO getFault() {
        this.entering("ProcessInstanceDaoImpl.getFault");
        if (this._instance.getFault() == null) {
            return null;
        }
        return new FaultDAOImpl(this._sm, this._instance.getFault());
    }

    public byte[] getExecutionState() {
        this.entering("ProcessInstanceDaoImpl.getExecutionState");
        if (this._instance.getJacobState() == null) {
            return null;
        }
        return this._instance.getJacobState();
    }

    public void setExecutionState(byte[] bytes) {
        this.entering("ProcessInstanceDaoImpl.setExecutionState");
        if (bytes.length > 0) {
            this._instance.setJacobState(bytes);
        }
        this.getSession().update((Object)this._instance);
    }

    public ProcessDAO getProcess() {
        this.entering("ProcessInstanceDaoImpl.getProcess");
        return new ProcessDaoImpl(this._sm, this._instance.getProcess());
    }

    public ScopeDAO getRootScope() {
        this.entering("ProcessInstanceDaoImpl.getRootScope");
        if (this._root != null) {
            return this._root;
        }
        Query rootQry = this.getSession().createFilter(this._instance.getScopes(), "where this.parentScope is null");
        HScope hroot = (HScope)rootQry.uniqueResult();
        if (hroot == null) {
            return null;
        }
        this._root = new ScopeDaoImpl(this._sm, hroot);
        return this._root;
    }

    public void setState(short state) {
        this.entering("ProcessInstanceDaoImpl.setState");
        this._instance.setPreviousState(this._instance.getState());
        this._instance.setState(state);
        if (state == 60) {
            this.clearSelectors();
        }
        this.getSession().update((Object)this._instance);
    }

    public short getState() {
        return this._instance.getState();
    }

    public short getPreviousState() {
        return this._instance.getPreviousState();
    }

    public ScopeDAO createScope(ScopeDAO parentScope, String name, int scopeModelId) {
        this.entering("ProcessInstanceDaoImpl.createScope");
        HScope scope = new HScope();
        scope.setParentScope(parentScope != null ? (HScope)((ScopeDaoImpl)parentScope).getHibernateObj() : null);
        scope.setName(name);
        scope.setScopeModelId(scopeModelId);
        scope.setState(ScopeStateEnum.NEW.toString());
        scope.setInstance(this._instance);
        scope.setCreated(new Date());
        this.getSession().save((Object)scope);
        return new ScopeDaoImpl(this._sm, scope);
    }

    public Long getInstanceId() {
        return this._instance.getId();
    }

    public ScopeDAO getScope(Long scopeInstanceId) {
        this.entering("ProcessInstanceDaoImpl.getScope");
        Long id = (long)scopeInstanceId;
        HScope scope = (HScope)this.getSession().get(HScope.class, (Serializable)id);
        return scope != null ? new ScopeDaoImpl(this._sm, scope) : null;
    }

    public Collection<ScopeDAO> getScopes(String scopeName) {
        List hscopes;
        this.entering("ProcessInstanceDaoImpl.getScopes");
        if (scopeName != null) {
            Query filter = this._sm.getSession().createFilter(this._instance.getScopes(), "where this.name=?");
            filter.setString(0, scopeName);
            hscopes = filter.list();
        } else {
            hscopes = this._instance.getScopes();
        }
        ArrayList<ScopeDAO> ret = new ArrayList<ScopeDAO>();
        CollectionsX.transform(ret, hscopes, (UnaryFunction)new UnaryFunction<HScope, ScopeDAO>(){

            public ScopeDAO apply(HScope x) {
                return new ScopeDaoImpl(ProcessInstanceDaoImpl.this._sm, x);
            }
        });
        return ret;
    }

    public Collection<ScopeDAO> getScopes() {
        return this.getScopes(null);
    }

    public CorrelatorDAO getInstantiatingCorrelator() {
        this.entering("ProcessInstanceDaoImpl.getInstantiatingCorrelator");
        return new CorrelatorDaoImpl(this._sm, this._instance.getInstantiatingCorrelator());
    }

    public Date getLastActiveTime() {
        return this._instance.getLastActiveTime();
    }

    public void setLastActiveTime(Date dt) {
        this.entering("ProcessInstanceDaoImpl.setLastActiveTime");
        this._instance.setLastActiveTime(dt);
    }

    public Set<CorrelationSetDAO> getCorrelationSets() {
        this.entering("ProcessInstanceDaoImpl.getCorrelationSets");
        HashSet<CorrelationSetDAO> results = new HashSet<CorrelationSetDAO>();
        for (HCorrelationSet hCorrelationSet : this._instance.getCorrelationSets()) {
            results.add(new CorrelationSetDaoImpl(this._sm, hCorrelationSet));
        }
        return results;
    }

    public CorrelationSetDAO getCorrelationSet(String name) {
        this.entering("ProcessInstanceDaoImpl.getCorrelationSet");
        for (HCorrelationSet hCorrelationSet : this._instance.getCorrelationSets()) {
            if (!hCorrelationSet.getName().equals(name)) continue;
            return new CorrelationSetDaoImpl(this._sm, hCorrelationSet);
        }
        return null;
    }

    public XmlDataDAO[] getVariables(String variableName, int scopeModelId) {
        this.entering("ProcessInstanceDaoImpl.getVariables");
        ArrayList<XmlDataDaoImpl> results = new ArrayList<XmlDataDaoImpl>();
        Query qry = this.getSession().createQuery(QRY_VARIABLES);
        qry.setString(0, variableName);
        qry.setInteger(1, scopeModelId);
        qry.setLong(2, this._instance.getId().longValue());
        Iterator iter = qry.iterate();
        while (iter.hasNext()) {
            results.add(new XmlDataDaoImpl(this._sm, (HXmlData)iter.next()));
        }
        Hibernate.close((Iterator)iter);
        return results.toArray(new XmlDataDAO[results.size()]);
    }

    public void finishCompletion() {
        this.entering("ProcessInstanceDaoImpl.finishCompletion");
        assert (ProcessState.isFinished((short)this.getState()));
        this.getProcess().instanceCompleted((ProcessInstanceDAO)this);
    }

    public void delete(Set<ProcessConf.CLEANUP_CATEGORY> cleanupCategories) {
        this.delete(cleanupCategories, true);
    }

    public void delete(Set<ProcessConf.CLEANUP_CATEGORY> cleanupCategories, boolean deleteMyRoleMex) {
        this.entering("ProcessInstanceDaoImpl.delete");
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Cleaning up instance data with categories = " + cleanupCategories));
        }
        if (this._instance.getJacobState() != null) {
            this._instance.setJacobState(null);
        }
        HProcessInstance[] instances = new HProcessInstance[]{this._instance};
        if (cleanupCategories.contains(ProcessConf.CLEANUP_CATEGORY.EVENTS)) {
            this.deleteEvents(instances);
        }
        if (cleanupCategories.contains(ProcessConf.CLEANUP_CATEGORY.CORRELATIONS)) {
            this.deleteCorrelations(instances);
        }
        if (cleanupCategories.contains(ProcessConf.CLEANUP_CATEGORY.MESSAGES)) {
            this.deleteMessages(instances, deleteMyRoleMex);
        }
        if (cleanupCategories.contains(ProcessConf.CLEANUP_CATEGORY.VARIABLES)) {
            this.deleteVariables(instances);
        }
        if (cleanupCategories.contains(ProcessConf.CLEANUP_CATEGORY.INSTANCE)) {
            this.deleteInstances(instances);
        }
        this.getSession().flush();
        if (__log.isDebugEnabled()) {
            __log.debug((Object)"Instance data cleaned up and flushed.");
        }
    }

    private void deleteInstances(HProcessInstance[] instances) {
        this.deleteByIds(HFaultData.class, this.getSession().getNamedQuery("SELECT_FAULT_IDS_BY_INSTANCES").setParameterList("instances", (Object[])instances).list());
        this.getSession().delete((Object)this._instance);
    }

    private void deleteVariables(HProcessInstance[] instances) {
        this.deleteByIds(HCorrelationProperty.class, this.getSession().getNamedQuery("SELECT_CORPROP_IDS_BY_INSTANCES").setParameterList("instances", (Object[])instances).list());
        this.deleteByIds(HCorrelationSet.class, this.getSession().getNamedQuery("SELECT_CORSET_IDS_BY_INSTANCES").setParameterList("instances", (Object[])instances).list());
        this.deleteByIds(HVariableProperty.class, this.getSession().getNamedQuery("SELECT_VARIABLE_PROPERTY_IDS_BY_INSTANCES").setParameterList("instances", (Object[])instances).list());
        this.deleteByIds(HXmlData.class, this.getSession().getNamedQuery("SELECT_XMLDATA_IDS_BY_INSTANCES").setParameterList("instances", (Object[])instances).list());
        this.deleteByIds(HPartnerLink.class, this.getSession().getNamedQuery("SELECT_PARTNER_LINK_IDS_BY_INSTANCES").setParameterList("instances", (Object[])instances).list());
        this.deleteByIds(HScope.class, this.getSession().getNamedQuery("SELECT_SCOPE_IDS_BY_INSTANCES").setParameterList("instances", (Object[])instances).list());
    }

    private void deleteMessages(HProcessInstance[] instances, boolean deleteMyRoleMex) {
        List allMexes = this.getSession().getNamedQuery("SELECT_MEX_IDS_BY_INSTANCES").setParameterList("instances", (Object[])instances).list();
        this.deleteByColumn(HMessageExchangeProperty.class, "mex.id", allMexes);
        if (deleteMyRoleMex) {
            this.deleteByIds(HMessage.class, this.getSession().getNamedQuery("SELECT_MESSAGE_IDS_BY_INSTANCES").setParameterList("instances", (Object[])instances).list());
            this.deleteByIds(HMessageExchange.class, allMexes);
        } else {
            List unmatchedMex = this.getSession().getNamedQuery("SELECT_UNMATCHED_MEX_BY_INSTANCES").setParameterList("instances", (Object[])instances).list();
            if (!unmatchedMex.isEmpty()) {
                ArrayList<Long> mexIdList = new ArrayList<Long>();
                for (HMessageExchange mex : unmatchedMex) {
                    mexIdList.add(mex.getId());
                }
                this.getSession().delete((Object)unmatchedMex);
            }
        }
        this.deleteByIds(HCorrelatorMessage.class, this.getSession().getNamedQuery("SELECT_CORMESSAGE_IDS_BY_INSTANCES").setParameterList("instances", (Object[])instances).list());
        this.deleteByIds(HCorrelatorSelector.class, this.getSession().getNamedQuery("SELECT_MESSAGE_ROUTE_IDS_BY_INSTANCES").setParameterList("instances", (Object[])instances).list());
    }

    private void deleteCorrelations(HProcessInstance[] instances) {
        this.deleteByIds(HCorrelationProperty.class, this.getSession().getNamedQuery("SELECT_CORPROP_IDS_BY_INSTANCES").setParameterList("instances", (Object[])instances).list());
        this.deleteByIds(HCorrelationSet.class, this.getSession().getNamedQuery("SELECT_CORSET_IDS_BY_INSTANCES").setParameterList("instances", (Object[])instances).list());
    }

    private void deleteEvents(HProcessInstance[] instances) {
        this.deleteByIds(HBpelEvent.class, this.getSession().getNamedQuery("SELECT_EVENT_IDS_BY_INSTANCES").setParameterList("instances", (Object[])instances).list());
    }

    public void insertBpelEvent(ProcessInstanceEvent event) {
        this.entering("ProcessInstanceDaoImpl.insertBpelEvent");
        BpelDAOConnectionImpl._insertBpelEvent(this.getSession(), (BpelEvent)event, this.getProcess(), this);
    }

    public ProcessInstanceDAO.EventsFirstLastCountTuple getEventsFirstLastCount() {
        this.entering("ProcessInstanceDaoImpl.getEventsFirstLastCount");
        Criteria c = this.getSession().createCriteria(HBpelEvent.class);
        c.add((Criterion)Restrictions.eq((String)"instance", (Object)this._instance));
        c.setProjection((Projection)Projections.projectionList().add((Projection)Projections.min((String)"tstamp")).add((Projection)Projections.max((String)"tstamp")).add((Projection)Projections.count((String)"tstamp")));
        Object[] ret = (Object[])c.uniqueResult();
        ProcessInstanceDAO.EventsFirstLastCountTuple flc = new ProcessInstanceDAO.EventsFirstLastCountTuple();
        flc.first = (Date)ret[0];
        flc.last = (Date)ret[1];
        flc.count = (Integer)ret[2];
        return flc;
    }

    public Collection<MessageExchangeDAO> getMessageExchanges() {
        ArrayList<MessageExchangeDAO> exchanges = new ArrayList<MessageExchangeDAO>();
        for (HMessageExchange exchange : this._instance.getMessageExchanges()) {
            exchanges.add(new MessageExchangeDaoImpl(this._sm, exchange));
        }
        return exchanges;
    }

    public long genMonotonic() {
        this.entering("ProcessInstanceDaoImpl.genMonotonic");
        long seq = this._instance.getSequence() + 1L;
        this._instance.setSequence(seq);
        return seq;
    }

    protected void clearSelectors() {
        this.entering("ProcessInstanceDaoImpl.clearSelectors");
        Query q = this.getSession().createQuery(QRY_DELSELECTORS);
        q.setEntity(0, (Object)this._instance);
        q.executeUpdate();
    }

    public int getActivityFailureCount() {
        return this._instance.getActivityFailureCount();
    }

    public Date getActivityFailureDateTime() {
        return this._instance.getActivityFailureDateTime();
    }

    public Collection<ActivityRecoveryDAO> getActivityRecoveries() {
        this.entering("ProcessInstanceDaoImpl.getActivityRecoveries");
        ArrayList<ActivityRecoveryDAO> results = new ArrayList<ActivityRecoveryDAO>();
        Query qry = this.getSession().createQuery(QRY_RECOVERIES);
        qry.setLong(0, this._instance.getId().longValue());
        Iterator iter = qry.iterate();
        while (iter.hasNext()) {
            results.add(new ActivityRecoveryDaoImpl(this._sm, (HActivityRecovery)iter.next()));
        }
        Hibernate.close((Iterator)iter);
        return results;
    }

    public void setActivityRecoveries(Collection<ActivityRecoveryDAO> recoveries) {
        throw new UnsupportedOperationException("This method is not implemented in this version of the ODE");
    }

    public void createActivityRecovery(String channel, long activityId, String reason, Date dateTime, Element data, String[] actions, int retries) {
        this.entering("ProcessInstanceDaoImpl.createActivityRecovery");
        HActivityRecovery recovery = new HActivityRecovery();
        recovery.setInstance(this._instance);
        recovery.setChannel(channel);
        recovery.setActivityId(activityId);
        recovery.setReason(reason);
        recovery.setDateTime(dateTime);
        recovery.setRetries(retries);
        if (data != null) {
            recovery.setDetails(DOMUtils.domToBytes((Element)data));
        }
        String list = actions[0];
        for (int i = 1; i < actions.length; ++i) {
            list = list + " " + actions[i];
        }
        recovery.setActions(list);
        this.getSession().save((Object)recovery);
        this._instance.setActivityFailureDateTime(dateTime);
        this._instance.setActivityFailureCount(this._instance.getActivityFailureCount() + 1);
        this.getSession().update((Object)this._instance);
    }

    public void deleteActivityRecovery(String channel) {
        this.entering("ProcessInstanceDaoImpl.deleteActivityRecovery");
        for (HActivityRecovery recovery : this._instance.getActivityRecoveries()) {
            if (!recovery.getChannel().equals(channel)) continue;
            this.getSession().delete((Object)recovery);
            this._instance.setActivityFailureCount(this._instance.getActivityFailureCount() - 1);
            this.getSession().update((Object)this._instance);
            return;
        }
    }

    public BpelDAOConnection getConnection() {
        this.entering("ProcessInstanceDaoImpl.getConnection");
        return new BpelDAOConnectionImpl(this._sm);
    }

    public Collection<String> getMessageExchangeIds() {
        HashSet<String> c = new HashSet<String>();
        for (HMessageExchange m : this._instance.getMessageExchanges()) {
            c.add(m.getId().toString());
        }
        return c;
    }

    public void addMessageExchange(MessageExchangeDAO dao) {
    }
}

