/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.daohib.bpel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.dao.CorrelatorDAO;
import org.apache.ode.bpel.dao.DeferredProcessInstanceCleanable;
import org.apache.ode.bpel.dao.ProcessDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.daohib.SessionManager;
import org.apache.ode.daohib.bpel.BpelDAOConnectionImpl;
import org.apache.ode.daohib.bpel.CorrelatorDaoImpl;
import org.apache.ode.daohib.bpel.HibernateDao;
import org.apache.ode.daohib.bpel.ProcessInstanceDaoImpl;
import org.apache.ode.daohib.bpel.hobj.HActivityRecovery;
import org.apache.ode.daohib.bpel.hobj.HBpelEvent;
import org.apache.ode.daohib.bpel.hobj.HCorrelationProperty;
import org.apache.ode.daohib.bpel.hobj.HCorrelationSet;
import org.apache.ode.daohib.bpel.hobj.HCorrelator;
import org.apache.ode.daohib.bpel.hobj.HFaultData;
import org.apache.ode.daohib.bpel.hobj.HMessage;
import org.apache.ode.daohib.bpel.hobj.HMessageExchange;
import org.apache.ode.daohib.bpel.hobj.HMessageExchangeProperty;
import org.apache.ode.daohib.bpel.hobj.HPartnerLink;
import org.apache.ode.daohib.bpel.hobj.HProcess;
import org.apache.ode.daohib.bpel.hobj.HProcessInstance;
import org.apache.ode.daohib.bpel.hobj.HScope;
import org.apache.ode.daohib.bpel.hobj.HVariableProperty;
import org.apache.ode.daohib.bpel.hobj.HXmlData;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.StaleStateException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.Order;

public class ProcessDaoImpl
extends HibernateDao
implements ProcessDAO,
DeferredProcessInstanceCleanable {
    private static final Log __log = LogFactory.getLog(ProcessDaoImpl.class);
    private static final String QRY_CORRELATOR = "where this.correlatorId = ?";
    private HProcess _process;

    public ProcessDaoImpl(SessionManager sm, HProcess process) {
        super(sm, process);
        this.entering("ProcessDaoImpl.ProcessDaoImpl");
        this._process = process;
    }

    public Long getPidId() {
        return (Long)this.getId();
    }

    public QName getProcessId() {
        return QName.valueOf(this._process.getProcessId());
    }

    public ProcessInstanceDAO getInstance(Long iid) {
        this.entering("ProcessDaoImpl.getInstance");
        ProcessInstanceDAO instance = BpelDAOConnectionImpl._getInstance(this._sm, this.getSession(), iid);
        if (instance == null || !instance.getProcess().getProcessId().equals(this.getProcessId())) {
            return null;
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CorrelatorDAO getCorrelator(String corrId) {
        this.entering("ProcessDaoImpl.getCorrelator");
        Query q = this.getSession().createFilter(this._process.getCorrelators(), QRY_CORRELATOR);
        Iterator results = q.setString(0, corrId).iterate();
        if (!results.hasNext()) {
            String msg = "no such correlator: corrId = " + corrId;
            throw new IllegalArgumentException(msg);
        }
        try {
            CorrelatorDaoImpl correlatorDaoImpl = new CorrelatorDaoImpl(this._sm, (HCorrelator)results.next());
            return correlatorDaoImpl;
        }
        finally {
            Hibernate.close((Iterator)results);
        }
    }

    public Set<String> getCorrelatorsSet() {
        Set<HCorrelator> correlators = this._process.getCorrelators();
        HashSet<String> correlatorIDs = new HashSet<String>();
        for (HCorrelator correlator : correlators) {
            correlatorIDs.add(correlator.getCorrelatorId());
        }
        return correlatorIDs;
    }

    public void removeRoutes(String routeId, ProcessInstanceDAO target) {
        this.entering("ProcessDaoImpl.removeRoutes");
        for (HCorrelator hCorrelator : this._process.getCorrelators()) {
            new CorrelatorDaoImpl(this._sm, hCorrelator).removeRoutes(routeId, target);
        }
    }

    public ProcessInstanceDAO createInstance(CorrelatorDAO correlator) {
        this.entering("ProcessDaoImpl.createInstance");
        HProcessInstance instance = new HProcessInstance();
        instance.setInstantiatingCorrelator((HCorrelator)((CorrelatorDaoImpl)correlator).getHibernateObj());
        instance.setProcess(this._process);
        instance.setCreated(new Date());
        this.getSession().save((Object)instance);
        return new ProcessInstanceDaoImpl(this._sm, instance);
    }

    public Collection<ProcessInstanceDAO> findInstance(CorrelationKey ckeyValue) {
        this.entering("ProcessDaoImpl.findInstance");
        Criteria criteria = this.getSession().createCriteria(HCorrelationSet.class);
        criteria.add((Criterion)Expression.eq((String)"scope.instance.process.id", (Object)this._process.getId()));
        criteria.add((Criterion)Expression.eq((String)"value", (Object)ckeyValue.toCanonicalString()));
        criteria.addOrder(Order.desc((String)"scope.instance.created"));
        return criteria.list();
    }

    public void instanceCompleted(ProcessInstanceDAO instance) {
    }

    public void deleteProcessAndRoutes() {
        try {
            this.getSession().refresh((Object)this._process);
            this.getSession().delete((Object)this._process);
            this.getSession().flush();
        }
        catch (UnresolvableObjectException sse) {
            __log.debug((Object)("Process: " + this.getProcessId() + " has been already deleted."));
        }
        catch (StaleStateException sse) {
            __log.debug((Object)("Process: " + this.getProcessId() + " has been already deleted."));
        }
    }

    public int deleteInstances(int transactionSize) {
        List instances;
        this.entering("ProcessDaoImpl.delete");
        if (transactionSize < 1) {
            if (__log.isWarnEnabled()) {
                __log.warn((Object)"A zero or negative value was given for the transaction size of process dao deletion; overriding to '1'. Not using bulk deletion of rows may result in performance degradation.");
            }
            transactionSize = 1;
        }
        if (!(instances = this.getSession().getNamedQuery("SELECT_INSTANCES_BY_PROCESS").setParameter("process", (Object)this._process).setMaxResults(transactionSize).list()).isEmpty()) {
            this.deleteEvents(instances);
            this.deleteCorrelations(instances);
            this.deleteMessages(instances);
            this.deleteVariables(instances);
            this.deleteProcessInstances(instances);
        }
        return instances.size();
    }

    public int deleteInstances(Collection<HProcessInstance> instances, Set<ProcessConf.CLEANUP_CATEGORY> categories) {
        this.entering("ProcessDaoImpl.deleteInstances");
        if (!instances.isEmpty()) {
            if (categories.contains(ProcessConf.CLEANUP_CATEGORY.EVENTS)) {
                this.deleteEvents(instances);
            }
            if (categories.contains(ProcessConf.CLEANUP_CATEGORY.CORRELATIONS)) {
                this.deleteCorrelations(instances);
            }
            if (categories.contains(ProcessConf.CLEANUP_CATEGORY.MESSAGES)) {
                this.deleteMessages(instances);
            }
            if (categories.contains(ProcessConf.CLEANUP_CATEGORY.VARIABLES)) {
                this.deleteVariables(instances);
            }
            if (categories.contains(ProcessConf.CLEANUP_CATEGORY.INSTANCE)) {
                this.deleteProcessInstances(instances);
            }
        }
        return instances.size();
    }

    private void deleteProcessInstances(Collection<HProcessInstance> instances) {
        this.deleteByIds(HActivityRecovery.class, this.getSession().getNamedQuery("SELECT_ACTIVITY_RECOVERY_IDS_BY_INSTANCES").setParameterList("instances", instances).list());
        this.deleteByIds(HFaultData.class, this.getSession().getNamedQuery("SELECT_FAULT_IDS_BY_INSTANCES").setParameterList("instances", instances).list());
        ArrayList<Long> instanceIds = new ArrayList<Long>();
        for (HProcessInstance instance : instances) {
            instanceIds.add(instance.getId());
        }
        this.deleteByIds(HProcessInstance.class, instanceIds);
    }

    private void deleteVariables(Collection<HProcessInstance> instances) {
        this.deleteByIds(HVariableProperty.class, this.getSession().getNamedQuery("SELECT_VARIABLE_PROPERTY_IDS_BY_INSTANCES").setParameterList("instances", instances).list());
        this.deleteByIds(HXmlData.class, this.getSession().getNamedQuery("SELECT_XMLDATA_IDS_BY_INSTANCES").setParameterList("instances", instances).list());
        this.deleteByIds(HPartnerLink.class, this.getSession().getNamedQuery("SELECT_PARTNER_LINK_IDS_BY_INSTANCES").setParameterList("instances", instances).list());
        this.deleteByIds(HScope.class, this.getSession().getNamedQuery("SELECT_SCOPE_IDS_BY_INSTANCES").setParameterList("instances", instances).list());
    }

    private void deleteMessages(Collection<HProcessInstance> instances) {
        this.deleteByIds(HActivityRecovery.class, this.getSession().getNamedQuery("SELECT_CORMESSAGE_IDS_BY_INSTANCES").setParameterList("instances", instances).list());
        this.deleteByIds(HMessage.class, this.getSession().getNamedQuery("SELECT_MESSAGE_IDS_BY_INSTANCES").setParameterList("instances", instances).list());
        List mex = this.getSession().getNamedQuery("SELECT_MEX_IDS_BY_INSTANCES").setParameterList("instances", instances).list();
        this.deleteByColumn(HMessageExchangeProperty.class, "mex.id", mex);
        this.deleteByIds(HMessageExchange.class, mex);
    }

    private void deleteCorrelations(Collection<HProcessInstance> instances) {
        this.deleteByIds(HCorrelationProperty.class, this.getSession().getNamedQuery("SELECT_CORPROP_IDS_BY_INSTANCES").setParameterList("instances", instances).list());
        this.deleteByIds(HCorrelationSet.class, this.getSession().getNamedQuery("SELECT_CORSET_IDS_BY_INSTANCES").setParameterList("instances", instances).list());
    }

    private void deleteEvents(Collection<HProcessInstance> instances) {
        this.deleteByIds(HBpelEvent.class, this.getSession().getNamedQuery("SELECT_EVENT_IDS_BY_INSTANCES").setParameterList("instances", instances).list());
    }

    public QName getType() {
        return new QName(this._process.getTypeNamespace(), this._process.getTypeName());
    }

    public long getVersion() {
        return this._process.getVersion();
    }

    public CorrelatorDAO addCorrelator(String corrid) {
        this.entering("ProcessDaoImpl.addCorrelator");
        HCorrelator correlator = new HCorrelator();
        correlator.setCorrelatorId(corrid);
        correlator.setProcess(this._process);
        correlator.setCreated(new Date());
        this.getSession().save((Object)correlator);
        this.getSession().saveOrUpdate((Object)this._process);
        return new CorrelatorDaoImpl(this._sm, correlator);
    }

    public Collection<ProcessInstanceDAO> getActiveInstances() {
        ArrayList<ProcessInstanceDAO> instDaos = new ArrayList<ProcessInstanceDAO>();
        List insts = this.getSession().getNamedQuery("SELECT_INSTANCES_BY_PROCESS_AND_STATES").setParameter("process", (Object)this._process).setParameterList("states", new Object[]{(short)20}).list();
        for (HProcessInstance inst : insts) {
            instDaos.add(new ProcessInstanceDaoImpl(this._sm, inst));
        }
        return instDaos;
    }

    public int getNumInstances() {
        this.entering("ProcessDaoImpl.getNumInstances");
        return this._process.getInstances().size();
    }

    public String getGuid() {
        return this._process.getGuid();
    }
}

