/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.daohib.bpel;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.daohib.SessionManager;
import org.apache.ode.daohib.bpel.HibernateHandle;
import org.apache.ode.daohib.bpel.hobj.HObject;
import org.hibernate.Query;
import org.hibernate.Session;

public abstract class HibernateDao {
    static final Log logDao = LogFactory.getLog((String)"org.apache.ode.bpel.DAO");
    protected final SessionManager _sm;
    protected final HObject _hobj;

    protected HibernateDao(SessionManager sessionManager, HObject hobj) {
        this._sm = sessionManager;
        this._hobj = hobj;
    }

    void entering(String msg) {
        if (logDao.isDebugEnabled()) {
            logDao.debug((Object)("entering " + msg));
        }
    }

    void leaving(String msg) {
        if (logDao.isDebugEnabled()) {
            logDao.debug((Object)("leaving " + msg));
        }
    }

    public Serializable getDHandle() {
        return new HibernateHandle(this.getClass(), this._hobj.getClass(), this.getSession().getIdentifier((Object)this._hobj));
    }

    protected Session getSession() {
        return this._sm.getSession();
    }

    public HObject getHibernateObj() {
        return this._hobj;
    }

    public Serializable getId() {
        if (this._hobj != null) {
            return this._hobj.getId();
        }
        return null;
    }

    public boolean equals(Object obj) {
        assert (obj instanceof HibernateDao);
        return this._hobj.getId().equals(((HibernateDao)obj)._hobj.getId());
    }

    public int hashCode() {
        return this._hobj.getId().hashCode();
    }

    protected void update() {
        this._sm.getSession().update((Object)this._hobj);
    }

    protected void deleteByIds(Class entity, List<Long> ids) {
        this.deleteByColumn(entity, "id", ids);
    }

    protected void deleteByColumn(Class entity, String column, List<Long> values) {
        if (values != null && values.size() > 0) {
            String delete = "delete from " + entity.getName() + " as e where e." + column + " in (:values)";
            int batchSize = 100;
            for (int index = 0; index < values.size(); index += 100) {
                List<Long> subList = values.subList(index, Math.min(index + 100, values.size()));
                Query query = this.getSession().createQuery(delete);
                query.setParameterList("values", subList);
                query.executeUpdate();
            }
        }
    }
}

