/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.samples.hierarchical.resource;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.wso2.balana.attr.AttributeValue;
import org.wso2.balana.attr.BagAttribute;
import org.wso2.balana.attr.StringAttribute;
import org.wso2.balana.cond.EvaluationResult;
import org.wso2.balana.ctx.EvaluationCtx;
import org.wso2.balana.finder.AttributeFinderModule;

public class SampleAttributeFinderModule
extends AttributeFinderModule {
    private URI defaultSubjectId;

    public SampleAttributeFinderModule() {
        try {
            this.defaultSubjectId = new URI("urn:oasis:names:tc:xacml:1.0:subject:subject-id");
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    public Set<String> getSupportedCategories() {
        HashSet<String> categories = new HashSet<String>();
        categories.add("urn:oasis:names:tc:xacml:1.0:subject-category:access-subject");
        return categories;
    }

    public Set getSupportedIds() {
        HashSet<String> ids = new HashSet<String>();
        ids.add("http://test.org/claim/role");
        return ids;
    }

    public EvaluationResult findAttribute(URI attributeType, URI attributeId, String issuer, URI category, EvaluationCtx context) {
        BagAttribute bagAttribute;
        String roleName = null;
        ArrayList<StringAttribute> attributeValues = new ArrayList<StringAttribute>();
        EvaluationResult result = context.getAttribute(attributeType, this.defaultSubjectId, issuer, category);
        if (result != null && result.getAttributeValue() != null && result.getAttributeValue().isBag() && (bagAttribute = (BagAttribute)result.getAttributeValue()).size() > 0) {
            String userName = ((AttributeValue)bagAttribute.iterator().next()).encode();
            roleName = this.findRole(userName);
        }
        if (roleName != null) {
            attributeValues.add(new StringAttribute(roleName));
        }
        return new EvaluationResult((AttributeValue)new BagAttribute(attributeType, attributeValues));
    }

    public boolean isDesignatorSupported() {
        return true;
    }

    private String findRole(String userName) {
        if (userName.equals("bob")) {
            return "User";
        }
        if (userName.equals("alice")) {
            return "Employee";
        }
        if (userName.equals("peter")) {
            return "Manager";
        }
        return null;
    }
}

