/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.samples.hierarchical.resource;

import java.io.ByteArrayInputStream;
import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.wso2.balana.Balana;
import org.wso2.balana.PDP;
import org.wso2.balana.PDPConfig;
import org.wso2.balana.ParsingException;
import org.wso2.balana.ctx.AbstractResult;
import org.wso2.balana.ctx.Attribute;
import org.wso2.balana.ctx.ResponseCtx;
import org.wso2.balana.ctx.xacml3.Result;
import org.wso2.balana.finder.AttributeFinder;
import org.wso2.balana.finder.ResourceFinder;
import org.wso2.balana.samples.hierarchical.resource.HierarchicalResourceFinder;
import org.wso2.balana.samples.hierarchical.resource.SampleAttributeFinderModule;
import org.wso2.balana.xacml3.Attributes;

public class Main {
    private static Balana balana;

    public static void main(String[] args) {
        String userName = null;
        String type = null;
        Main.printDescription();
        Main.initBalana();
        System.out.println("\nYou can check the authorization for children or descendants resource under root resources \n");
        System.out.println("root-");
        System.out.println("    ------ private ---- leadership");
        System.out.println("    -              ---- support");
        System.out.println("    -              ---- team");
        System.out.println("    -              ---- business");
        System.out.println("    -");
        System.out.println("    ------ public  ---- developments");
        System.out.println("    -              ---- news");
        System.out.println();
        Console console = System.console();
        if (console != null) {
            userName = console.readLine("\nCheck authorized resources for user : ", new Object[0]);
        }
        if ((console = System.console()) != null) {
            type = console.readLine("\nDescendants or Children resources [D|C] : ", new Object[0]);
        }
        if (userName != null && userName.trim().length() > 0) {
            type = type != null && type.toLowerCase().equals("d") ? "Descendants" : "Children";
            String request = Main.createXACMLRequest(userName, type);
            PDP pdp = Main.getPDPNewInstance();
            System.out.println("\n======================== XACML Request ====================");
            System.out.println(request);
            System.out.println("===========================================================");
            String response = pdp.evaluate(request);
            System.out.println("\n======================== XACML Response ===================");
            System.out.println(response);
            System.out.println("===========================================================");
            HashSet<String> permitResources = new HashSet<String>();
            HashSet<String> denyResources = new HashSet<String>();
            try {
                ResponseCtx responseCtx = ResponseCtx.getInstance((Node)Main.getXacmlResponse(response));
                Set results = responseCtx.getResults();
                for (AbstractResult result : results) {
                    Set attributesSet = ((Result)result).getAttributes();
                    for (Attributes attributes : attributesSet) {
                        for (Attribute attribute : attributes.getAttributes()) {
                            if (0 == result.getDecision()) {
                                permitResources.add(attribute.getValue().encode());
                                continue;
                            }
                            denyResources.add(attribute.getValue().encode());
                        }
                    }
                }
            }
            catch (ParsingException e) {
                e.printStackTrace();
            }
            if (permitResources.size() > 0) {
                System.out.println("\n" + userName + " is authorized for following resources...\n");
                for (String result : permitResources) {
                    System.out.print(result + "\t");
                }
                System.out.println("\n");
            } else {
                System.out.println("\n" + userName + " is NOT authorized access any resource..!!!\n");
            }
        } else {
            System.err.println("\nUser name can not be empty\n");
        }
        System.exit(0);
    }

    private static void initBalana() {
        try {
            String policyLocation = new File(".").getCanonicalPath() + File.separator + "resources";
            System.setProperty("org.wso2.balana.PolicyDirectory", policyLocation);
        }
        catch (IOException e) {
            System.err.println("Can not locate policy repository");
        }
        balana = Balana.getInstance();
    }

    private static PDP getPDPNewInstance() {
        PDPConfig pdpConfig = balana.getPdpConfig();
        AttributeFinder attributeFinder = pdpConfig.getAttributeFinder();
        List finderModules = attributeFinder.getModules();
        finderModules.add(new SampleAttributeFinderModule());
        attributeFinder.setModules(finderModules);
        ResourceFinder resourceFinder = pdpConfig.getResourceFinder();
        List resourceModules = resourceFinder.getModules();
        resourceModules.add(new HierarchicalResourceFinder());
        resourceFinder.setModules(resourceModules);
        return new PDP(new PDPConfig(attributeFinder, pdpConfig.getPolicyFinder(), resourceFinder, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element getXacmlResponse(String response) {
        Document doc;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(response.getBytes());
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        try {
            doc = dbf.newDocumentBuilder().parse(inputStream);
        }
        catch (Exception e) {
            System.err.println("DOM of request element can not be created from String");
            Element element = null;
            return element;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                System.err.println("Error in closing input stream of XACML response");
            }
        }
        return doc.getDocumentElement();
    }

    public static void printDescription() {
        System.out.println("\nThis sample shows the use of Multiple decision profile and Hierarchical resource  profile in XACML 3.0 \n");
    }

    public static String createXACMLRequest(String userName, String type) {
        return "<Request xmlns=\"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17\" CombinedDecision=\"false\" ReturnPolicyIdList=\"false\">\n<Attributes Category=\"urn:oasis:names:tc:xacml:3.0:attribute-category:action\">\n<Attribute AttributeId=\"urn:oasis:names:tc:xacml:1.0:action:action-id\" IncludeInResult=\"false\">\n<AttributeValue DataType=\"http://www.w3.org/2001/XMLSchema#string\">access</AttributeValue>\n</Attribute>\n</Attributes>\n<Attributes Category=\"urn:oasis:names:tc:xacml:1.0:subject-category:access-subject\">\n<Attribute AttributeId=\"urn:oasis:names:tc:xacml:1.0:subject:subject-id\" IncludeInResult=\"false\">\n<AttributeValue DataType=\"http://www.w3.org/2001/XMLSchema#string\">" + userName + "</AttributeValue>\n" + "</Attribute>\n" + "</Attributes>\n" + "<Attributes Category=\"urn:oasis:names:tc:xacml:3.0:attribute-category:resource\">\n" + "<Attribute AttributeId=\"urn:oasis:names:tc:xacml:1.0:resource:resource-id\" IncludeInResult=\"true\">\n" + "<AttributeValue DataType=\"http://www.w3.org/2001/XMLSchema#string\">root</AttributeValue>\n" + "</Attribute>\n" + "<Attribute AttributeId=\"urn:oasis:names:tc:xacml:2.0:resource:scope\" IncludeInResult=\"false\">\n" + "<AttributeValue DataType=\"http://www.w3.org/2001/XMLSchema#string\">" + type + "</AttributeValue>\n" + "</Attribute>\n" + "</Attributes>\n" + "</Request>";
    }
}

