/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.samples.hierarchical.resource;

import java.net.URI;
import java.util.HashSet;
import org.wso2.balana.Balana;
import org.wso2.balana.attr.AttributeValue;
import org.wso2.balana.ctx.EvaluationCtx;
import org.wso2.balana.finder.ResourceFinderModule;
import org.wso2.balana.finder.ResourceFinderResult;

public class HierarchicalResourceFinder
extends ResourceFinderModule {
    private static final String DATA_TYPE = "http://www.w3.org/2001/XMLSchema#string";

    public boolean isChildSupported() {
        return true;
    }

    public boolean isDescendantSupported() {
        return true;
    }

    public ResourceFinderResult findChildResources(AttributeValue parentResourceId, EvaluationCtx context) {
        ResourceFinderResult result = new ResourceFinderResult();
        if (!DATA_TYPE.equals(parentResourceId.getType().toString())) {
            return result;
        }
        if ("root".equals(parentResourceId.encode())) {
            HashSet<AttributeValue> set = new HashSet<AttributeValue>();
            try {
                set.add(Balana.getInstance().getAttributeFactory().createValue(new URI(DATA_TYPE), "private"));
                set.add(Balana.getInstance().getAttributeFactory().createValue(new URI(DATA_TYPE), "public"));
            }
            catch (Exception e) {
                // empty catch block
            }
            result = new ResourceFinderResult(set);
        }
        return result;
    }

    public ResourceFinderResult findDescendantResources(AttributeValue parentResourceId, EvaluationCtx context) {
        ResourceFinderResult result = new ResourceFinderResult();
        if (!DATA_TYPE.equals(parentResourceId.getType().toString())) {
            return result;
        }
        if ("root".equals(parentResourceId.encode())) {
            HashSet<AttributeValue> set = new HashSet<AttributeValue>();
            try {
                set.add(Balana.getInstance().getAttributeFactory().createValue(new URI(DATA_TYPE), "private"));
                set.add(Balana.getInstance().getAttributeFactory().createValue(new URI(DATA_TYPE), "public"));
                set.add(Balana.getInstance().getAttributeFactory().createValue(new URI(DATA_TYPE), "public/developments"));
                set.add(Balana.getInstance().getAttributeFactory().createValue(new URI(DATA_TYPE), "public/news"));
                set.add(Balana.getInstance().getAttributeFactory().createValue(new URI(DATA_TYPE), "private/leadership"));
                set.add(Balana.getInstance().getAttributeFactory().createValue(new URI(DATA_TYPE), "private/business"));
                set.add(Balana.getInstance().getAttributeFactory().createValue(new URI(DATA_TYPE), "private/support"));
                set.add(Balana.getInstance().getAttributeFactory().createValue(new URI(DATA_TYPE), "private/team"));
            }
            catch (Exception e) {
                // empty catch block
            }
            result = new ResourceFinderResult(set);
        }
        return result;
    }
}

