/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.appserver.monitoring;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import javax.servlet.ServletException;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.wso2.appserver.configuration.listeners.ServerConfigurationLoader;
import org.wso2.appserver.configuration.server.AppServerStatsPublishing;
import org.wso2.appserver.monitoring.exceptions.StatPublisherException;
import org.wso2.appserver.monitoring.utils.EventBuilder;
import org.wso2.appserver.utils.PathUtils;
import org.wso2.carbon.databridge.agent.AgentHolder;
import org.wso2.carbon.databridge.agent.DataPublisher;
import org.wso2.carbon.databridge.agent.exception.DataEndpointAgentConfigurationException;
import org.wso2.carbon.databridge.agent.exception.DataEndpointAuthenticationException;
import org.wso2.carbon.databridge.agent.exception.DataEndpointConfigurationException;
import org.wso2.carbon.databridge.agent.exception.DataEndpointException;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.exception.TransportException;

public class HttpStatValve
extends ValveBase {
    private static final Log LOG = LogFactory.getLog(HttpStatValve.class);
    private DataPublisher dataPublisher;
    private AppServerStatsPublishing statsPublisherConfiguration;

    protected void initInternal() throws LifecycleException {
        super.initInternal();
        LOG.debug((Object)"The HttpStatValve initialized.");
        this.setTrustStorePath();
        this.statsPublisherConfiguration = ServerConfigurationLoader.getServerConfiguration().getStatsPublisherConfiguration();
        try {
            this.dataPublisher = this.getDataPublisher();
        }
        catch (StatPublisherException e) {
            LOG.error((Object)"Initializing DataPublisher failed:", (Throwable)e);
            throw new LifecycleException("Initializing DataPublisher failed: " + e);
        }
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        Long startTime = System.currentTimeMillis();
        this.getNext().invoke(request, response);
        long responseTime = System.currentTimeMillis() - startTime;
        if (this.filterResponse(response)) {
            Event event;
            try {
                event = EventBuilder.buildEvent(this.statsPublisherConfiguration.getStreamId(), request, response, startTime, responseTime);
            }
            catch (StatPublisherException e) {
                LOG.error((Object)("Creating the Event failed: " + e));
                throw new IOException("Creating the Event failed: " + e);
            }
            this.dataPublisher.publish(event);
        }
    }

    private String getDataAgentConfigPath() {
        Path path = Paths.get(PathUtils.getAppServerConfigurationBase().toString(), "data-agent-conf.xml");
        return path.toString();
    }

    private DataPublisher getDataPublisher() throws StatPublisherException {
        DataPublisher dataPublisher;
        AgentHolder.setConfigPath((String)this.getDataAgentConfigPath());
        try {
            dataPublisher = !Optional.ofNullable(this.statsPublisherConfiguration.getAuthenticationURL()).isPresent() ? new DataPublisher(this.statsPublisherConfiguration.getPublisherURL(), this.statsPublisherConfiguration.getUsername(), this.statsPublisherConfiguration.getPassword()) : new DataPublisher(this.statsPublisherConfiguration.getDataAgentType(), this.statsPublisherConfiguration.getPublisherURL(), this.statsPublisherConfiguration.getAuthenticationURL(), this.statsPublisherConfiguration.getUsername(), this.statsPublisherConfiguration.getPassword());
        }
        catch (DataEndpointAgentConfigurationException e) {
            LOG.error((Object)("Data Endpoint Agent configuration failed: " + (Object)((Object)e)));
            throw new StatPublisherException("Data Endpoint Agent configuration failed: ", e);
        }
        catch (DataEndpointException e) {
            LOG.error((Object)("Communication with Data Endpoint failed: " + (Object)((Object)e)));
            throw new StatPublisherException("Communication with Data Endpoint failed: ", e);
        }
        catch (DataEndpointConfigurationException e) {
            LOG.error((Object)("Parsing Data Endpoint configurations failed: " + (Object)((Object)e)));
            throw new StatPublisherException("Parsing Data Endpoint configurations failed: ", e);
        }
        catch (DataEndpointAuthenticationException e) {
            LOG.error((Object)("Connection to Data Endpoint failed during authentication: " + (Object)((Object)e)));
            throw new StatPublisherException("Connection to Data Endpoint failed during authentication: ", e);
        }
        catch (TransportException e) {
            LOG.error((Object)("Connection failed: " + (Object)((Object)e)));
            throw new StatPublisherException("Connection failed: ", e);
        }
        return dataPublisher;
    }

    private boolean filterResponse(Response response) {
        String responseContentType = response.getContentType();
        return responseContentType != null && responseContentType.contains("text/html");
    }

    private void setTrustStorePath() {
        String pathToBeReplaced = System.getProperty("javax.net.ssl.trustStore");
        System.setProperty("javax.net.ssl.trustStore", pathToBeReplaced);
    }
}

