/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.apuava.settings.env;

import com.google.common.base.Optional;
import java.util.Arrays;
import org.wisepersist.apuava.settings.env.EnvType;

public enum EnvTypeImpl implements EnvType
{
    PROD("prod", "/prod/config.xml"),
    STAGE("stage", "/stage/config.xml"),
    DEV("dev", "/dev/config.xml"),
    TEST("test", "/test/config.xml");

    private final String name;
    private final String[] configFile;

    private EnvTypeImpl(String name, String ... configFile) {
        this.name = name;
        this.configFile = configFile;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String[] getConfigFile() {
        return Arrays.copyOf(this.configFile, this.configFile.length);
    }

    public static Optional<EnvType> fromString(String value) {
        Optional matchEnv = Optional.absent();
        for (EnvTypeImpl env : EnvTypeImpl.values()) {
            if (!env.getName().equalsIgnoreCase(value)) continue;
            matchEnv = Optional.of((Object)env);
            break;
        }
        return matchEnv;
    }
}

