/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.apuava.settings;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisepersist.apuava.resource.ResourceHandler;
import org.wisepersist.apuava.resource.ResourceManager;
import org.wisepersist.apuava.settings.Settings;
import org.wisepersist.apuava.settings.env.EnvType;

public abstract class AbstractSettings
implements Settings {
    private static final Logger log = LoggerFactory.getLogger(AbstractSettings.class);
    private ResourceManager resourceManager = new ResourceManager();
    private Properties mergedProperties;

    public AbstractSettings(EnvType env) {
        this(env.getConfigFile());
    }

    public AbstractSettings(String ... paths) {
        this.initialize(paths);
    }

    private void initialize(String ... paths) {
        this.ensureConfigNotNull();
        for (String path : paths) {
            this.readConfigFile(path);
        }
    }

    protected final void ensureConfigNotNull() {
        if (this.mergedProperties == null) {
            this.mergedProperties = new Properties();
        }
    }

    private void readConfigFile(final String path) {
        String filePath = this.composeResourceFilePath(path);
        try {
            final InputStream inputStream = this.getClassType().getResourceAsStream(filePath);
            this.resourceManager.with(inputStream).run(new ResourceHandler<Void>(){

                @Override
                public Void handle(Closeable closeable) throws IOException {
                    AbstractSettings.this.ensureInputStreamIsValid(inputStream);
                    AbstractSettings.this.mergedProperties.putAll((Map<?, ?>)AbstractSettings.this.loadProperties(path, inputStream));
                    return null;
                }
            });
        }
        catch (IOException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            throw new IllegalStateException("Couldn't process resource file.", ex);
        }
    }

    private Properties loadProperties(String path, InputStream inputStream) throws IOException {
        Properties configFile = new Properties();
        if (path.endsWith(".xml")) {
            configFile.loadFromXML(inputStream);
        } else if (path.endsWith(".properties") || path.endsWith(".config")) {
            configFile.load(inputStream);
        }
        return configFile;
    }

    private void ensureInputStreamIsValid(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IOException("Invalid file.");
        }
    }

    private String composeResourceFilePath(String path) {
        String filePath = this.getAppConfigFolder();
        filePath = StringUtils.isEmpty((CharSequence)filePath) ? path : "/".concat(filePath).concat(path);
        return filePath;
    }

    protected final String get(String name, String defaultVal) {
        String value = System.getProperty(name);
        if (StringUtils.isBlank((CharSequence)value)) {
            value = this.mergedProperties.getProperty(name, defaultVal);
        } else {
            log.info("get {} from system property instead of system config file", (Object)name);
        }
        return value;
    }

    protected final String get(String name) {
        return this.get(name, "").trim();
    }

    protected abstract Class getClassType();

    protected abstract String getAppConfigFolder();

    @Override
    public final String getString(String key) {
        return this.get(key);
    }

    @Override
    public final String getString(String key, String defaultVal) {
        return this.get(key, defaultVal);
    }

    @Override
    public final Integer getInt(String key) {
        return this.getInt(key, 0);
    }

    @Override
    public final Integer getInt(String key, int defaultVal) {
        String value = this.getString(key);
        int valueInt = defaultVal;
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            valueInt = NumberUtils.toInt((String)value, (int)defaultVal);
        }
        return valueInt;
    }

    @Override
    public final Boolean getBoolean(String key) {
        String value = this.getString(key);
        boolean valueBoolean = false;
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            valueBoolean = BooleanUtils.toBoolean((String)value);
        }
        return valueBoolean;
    }

    @Override
    public final Double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    @Override
    public final Double getDouble(String key, double defaultVal) {
        String value = this.getString(key);
        double valueDouble = defaultVal;
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            valueDouble = NumberUtils.toDouble((String)value, (double)defaultVal);
        }
        return valueDouble;
    }
}

