/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.apuava.cli;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;

public final class Console {
    private static int currLineLength;

    private Console() {
    }

    public static void done(String message) {
        Console.done(message, "");
    }

    public static void done(String message, String highlight) {
        Console.clearCurrLine();
        System.out.println(Console.createAnsi("Done", message, highlight));
    }

    public static void progress(String label, String message) {
        Console.progress(label, message, "");
    }

    public static void progress(String label, String message, String highlight) {
        Console.clearCurrLine();
        System.out.print(Console.createAnsi(label, message, highlight));
        System.out.flush();
    }

    public static void error(String message) {
        Console.clearCurrLine();
        System.out.println(Console.createAnsi("Error", message, ""));
    }

    private static Ansi createAnsi(String label, String message, String highlight) {
        Ansi.Color labelColor = Ansi.Color.CYAN;
        if (StringUtils.containsIgnoreCase((CharSequence)label, (CharSequence)"Done")) {
            labelColor = Ansi.Color.GREEN;
        } else if (StringUtils.containsIgnoreCase((CharSequence)label, (CharSequence)"Error")) {
            labelColor = Ansi.Color.RED;
        }
        Ansi ansi = Ansi.ansi().fg(labelColor).a("[" + label + "] ").reset().a(message);
        if (StringUtils.isNotBlank((CharSequence)highlight)) {
            ansi = ansi.a(" ").fg(Ansi.Color.YELLOW).a(highlight).reset();
        }
        Console.saveLineLength(label, message, highlight);
        return ansi;
    }

    private static void saveLineLength(String label, String message, String highlight) {
        String line = "[" + label + "] " + message + " " + StringUtils.trimToEmpty((String)highlight);
        currLineLength = line.length();
    }

    private static void clearCurrLine() {
        if (SystemUtils.IS_OS_WINDOWS) {
            System.out.print("\r");
            for (int i = 0; i < currLineLength; ++i) {
                System.out.print(" ");
            }
        } else {
            System.out.print("\u001b[2K");
        }
        System.out.print("\r");
        System.out.flush();
    }

    static {
        AnsiConsole.systemInstall();
    }
}

