/*
 * Decompiled with CFR 0.152.
 */
package org.wing4j.orm.test.spring;

import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.wing4j.orm.WordMode;
import org.wing4j.orm.entity.utils.SqlScriptUtils;
import org.wing4j.orm.test.spring.datasource.TestDataSourceUtils;
import org.wing4j.test.CreateTable;
import org.wing4j.test.DevDataSourceType;

public class CreateTableTestExecutionListener
extends AbstractTestExecutionListener {
    private static final Logger log = LoggerFactory.getLogger(CreateTableTestExecutionListener.class);
    ApplicationContext ctx;

    public void beforeTestMethod(TestContext testContext) throws Exception {
        Method testMethod = testContext.getTestMethod();
        String dsn = TestDataSourceUtils.lookupDataSource();
        CreateTable createTable = testMethod.getAnnotation(CreateTable.class);
        if (createTable != null) {
            Class[] clazzs = createTable.entities();
            boolean test = createTable.createBeforeTest();
            boolean drop = createTable.testBeforeDrop();
            WordMode sqlMode = createTable.sqlMode();
            WordMode keywordMode = createTable.keywordMode();
            String schema = createTable.schema();
            for (Class clazz : clazzs) {
                JdbcTemplate jdbcTemplate = (JdbcTemplate)testContext.getApplicationContext().getBean(JdbcTemplate.class);
                if (drop) {
                    String dropSql = SqlScriptUtils.generateDropTable((Class)clazz, (String)"", (WordMode)sqlMode, (WordMode)keywordMode, (boolean)drop);
                    jdbcTemplate.execute(dropSql);
                }
                String createSql = SqlScriptUtils.generateCreateTable((Class)clazz, (String)"", (String)"", (WordMode)sqlMode, (WordMode)keywordMode, (boolean)test);
                jdbcTemplate.execute(createSql);
            }
        }
    }

    public void afterTestMethod(TestContext testContext) throws Exception {
        Method testMethod = testContext.getTestMethod();
        Class testClass = testContext.getTestClass();
        String dsn = TestDataSourceUtils.lookupDataSource();
        CreateTable createTable = testMethod.getAnnotation(CreateTable.class);
        if (createTable != null) {
            Class[] clazzs = createTable.entities();
            boolean drop = createTable.testBeforeDrop();
            WordMode sqlMode = createTable.sqlMode();
            WordMode keywordMode = createTable.keywordMode();
            if (drop && DevDataSourceType.h2DataSource.name().equals(dsn)) {
                for (Class clazz : clazzs) {
                    JdbcTemplate jdbcTemplate = (JdbcTemplate)testContext.getApplicationContext().getBean(JdbcTemplate.class);
                    String dropSql = SqlScriptUtils.generateDropTable((Class)clazz, (String)"", (WordMode)sqlMode, (WordMode)keywordMode, (boolean)drop);
                    jdbcTemplate.execute(dropSql);
                }
            }
        }
    }

    public int getOrder() {
        return 0x7FFFFFFE;
    }
}

