/*
 * Decompiled with CFR 0.152.
 */
package org.wing4j.orm.test.spring.datasource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wing4j.orm.test.EnvironmentUtils;
import org.wing4j.orm.test.FrameworkTestRuntimeException;

public class DevDataSourceUtils {
    private static final Logger logger = LoggerFactory.getLogger(DevDataSourceUtils.class);
    static ThreadLocal<String> currentDataSource = new ThreadLocal();
    static final String H2_DATASOURCE = "h2DataSource";
    static final String MYSQL_DATASOURCE = "mysqlDataSource";

    public static String setDevDateSourceName(String name) {
        currentDataSource.set(name);
        return currentDataSource.get();
    }

    public static String lookupDataSource() {
        EnvironmentUtils.Environment environment = EnvironmentUtils.determineRuntime();
        if (MYSQL_DATASOURCE.equals(currentDataSource.get()) && EnvironmentUtils.Environment.MAVEN_JUNIT == environment) {
            logger.error("maven runtime environment not allow use mySql database!");
            logger.error("maven\u73af\u5883\u8fdb\u884c\u5355\u5143\u6d4b\u8bd5\u4e0d\u5141\u8bb8\u4f7f\u7528mySql\u6570\u636e\u5e93!");
            throw new FrameworkTestRuntimeException("maven runtime environment not allow use mySql database!");
        }
        if (MYSQL_DATASOURCE.equals(currentDataSource.get()) || H2_DATASOURCE.equals(currentDataSource.get())) {
            logger.info("\u5355\u5143\u6d4b\u8bd5\u4f7f\u7528\u6570\u636e\u6e90{}!", (Object)currentDataSource.get());
            return currentDataSource.get();
        }
        if (EnvironmentUtils.Environment.MAVEN_JUNIT == environment) {
            logger.info("\u5355\u5143\u6d4b\u8bd5\u4f7f\u7528\u6570\u636e\u6e90{}!", (Object)H2_DATASOURCE);
            return H2_DATASOURCE;
        }
        if (EnvironmentUtils.Environment.IDE_JUNIT == environment) {
            logger.info("\u5355\u5143\u6d4b\u8bd5\u4f7f\u7528\u6570\u636e\u6e90{}!", (Object)H2_DATASOURCE);
            return H2_DATASOURCE;
        }
        return H2_DATASOURCE;
    }
}

