/*
 * Decompiled with CFR 0.152.
 */
package org.wing4j.orm.test.spring;

import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.wing4j.orm.WordMode;
import org.wing4j.orm.entity.utils.SqlScriptUtils;
import org.wing4j.orm.test.spring.datasource.DevDataSourceUtils;
import org.wing4j.test.CreateTable;
import org.wing4j.test.DevDataSourceName;

public class CreateTableTestExecutionListener
extends AbstractTestExecutionListener {
    private static final Logger logger = LoggerFactory.getLogger(CreateTableTestExecutionListener.class);

    public void beforeTestMethod(TestContext testContext) throws Exception {
        Method testMethod = testContext.getTestMethod();
        Class testClass = testContext.getTestClass();
        String dsn = DevDataSourceUtils.lookupDataSource();
        CreateTable createTable = testMethod.getAnnotation(CreateTable.class);
        if (createTable != null) {
            Class[] clazzs = createTable.entities();
            boolean test = createTable.createBeforeTest();
            boolean drop = createTable.testBeforeDrop();
            WordMode sqlMode = createTable.sqlMode();
            WordMode keywordMode = createTable.keywordMode();
            for (Class clazz : clazzs) {
                JdbcTemplate jdbcTemplate = (JdbcTemplate)testContext.getApplicationContext().getBean(JdbcTemplate.class);
                if (drop && DevDataSourceName.h2DataSource.name().equals(dsn)) {
                    String dropSql = SqlScriptUtils.generateDropTable((Class)clazz, (String)"", (WordMode)sqlMode, (WordMode)keywordMode, (boolean)drop);
                    logger.info("this is a auto drop table sql:\n" + dropSql);
                    jdbcTemplate.execute(dropSql);
                }
                String createSql = SqlScriptUtils.generateCreateTable((Class)clazz, (String)"", (String)"", (WordMode)sqlMode, (WordMode)keywordMode, (boolean)test);
                logger.info("this is a auto create table sql:\n" + createSql);
                jdbcTemplate.execute(createSql);
            }
        }
    }

    public void afterTestMethod(TestContext testContext) throws Exception {
        Method testMethod = testContext.getTestMethod();
        Class testClass = testContext.getTestClass();
        String dsn = DevDataSourceUtils.lookupDataSource();
        CreateTable createTable = testMethod.getAnnotation(CreateTable.class);
        if (createTable != null) {
            Class[] clazzs = createTable.entities();
            boolean test = createTable.createBeforeTest();
            boolean drop = createTable.testBeforeDrop();
            WordMode sqlMode = createTable.sqlMode();
            WordMode keywordMode = createTable.keywordMode();
            if (drop && DevDataSourceName.h2DataSource.name().equals(dsn)) {
                for (Class clazz : clazzs) {
                    JdbcTemplate jdbcTemplate = (JdbcTemplate)testContext.getApplicationContext().getBean(JdbcTemplate.class);
                    String dropSql = SqlScriptUtils.generateDropTable((Class)clazz, (String)"", (WordMode)sqlMode, (WordMode)keywordMode, (boolean)drop);
                    logger.info("this is a auto drop table sql:\n" + dropSql);
                    jdbcTemplate.execute(dropSql);
                }
            }
        }
    }

    public int getOrder() {
        return 0x7FFFFFFE;
    }
}

