package org.wing4j.orm.test.spring.datasource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wing4j.orm.test.EnvironmentUtils;
import org.wing4j.orm.test.FrameworkTestRuntimeException;

/**
 * Created by Administrator on 2016/7/24.
 */
public class DevDataSourceUtils {
    private static final Logger logger = LoggerFactory.getLogger(DevDataSourceUtils.class);

    static ThreadLocal<String> currentDataSource = new ThreadLocal<String>();
    static final String H2_DATASOURCE = "h2DataSource";
    static final String MYSQL_DATASOURCE = "mysqlDataSource";

    public static String setDevDateSourceName(String name) {
        currentDataSource.set(name);
        return currentDataSource.get();
    }

    public static String lookupDataSource() {
        EnvironmentUtils.Environment environment = EnvironmentUtils.determineRuntime();
        //如果注解上指定了数据源，运行环境是MAVEN，则抛出异常
        if (MYSQL_DATASOURCE.equals(currentDataSource.get())
                && EnvironmentUtils.Environment.MAVEN_JUNIT == environment) {
            logger.error("maven runtime environment not allow use mySql database!");
            logger.error("maven环境进行单元测试不允许使用mySql数据库!");
            throw new FrameworkTestRuntimeException("maven runtime environment not allow use mySql database!");
        }
        //如果注解上指定了数据源，符合规则，则直接使用
        if ((MYSQL_DATASOURCE.equals(currentDataSource.get())
                || H2_DATASOURCE.equals(currentDataSource.get()))) {
            logger.info("单元测试使用数据源{}!", currentDataSource.get());
            return currentDataSource.get();

        }
        //如果是Maven环境则直接使用H2
        if (EnvironmentUtils.Environment.MAVEN_JUNIT == environment) {
            logger.info("单元测试使用数据源{}!", H2_DATASOURCE);
            return H2_DATASOURCE;
        }
        //如果是IDE环境则直接使用H2
        if (EnvironmentUtils.Environment.IDE_JUNIT == environment) {
            logger.info("单元测试使用数据源{}!", H2_DATASOURCE);
            return H2_DATASOURCE;
        }
        //这种情况绝对不会有，除非识别环境代码有问题
        return H2_DATASOURCE;
    }
}
