/*
 * Decompiled with CFR 0.152.
 */
package org.wing4j.orm.mybatis.spring.mapper;

import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.Configuration;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.wing4j.orm.DatabaseType;
import org.wing4j.orm.WordMode;
import org.wing4j.orm.mybatis.plugins.PaginationStage1Interceptor;
import org.wing4j.orm.mybatis.plugins.PaginationStage2Interceptor;
import org.wing4j.orm.mybatis.sequnece.SequenceServiceConfigure;
import org.wing4j.orm.mybatis.spring.SqlSessionDaoSupport;
import org.wing4j.orm.mybatis.spring.mapper.MappedStatementRegister;

public class MapperFactoryBean<T>
extends SqlSessionDaoSupport
implements FactoryBean<T> {
    Class<T> mapperInterface;
    boolean addToConfig = true;
    String sqlMode = WordMode.lowerCase.name();
    String keywordMode = WordMode.lowerCase.name();
    boolean strictWing4j;
    @Autowired(required=false)
    SequenceServiceConfigure sequenceConfigure;
    String databaseType = DatabaseType.MySQL.name();

    public MapperFactoryBean(Class<T> mapperInterface) {
        this.mapperInterface = mapperInterface;
    }

    public MapperFactoryBean() {
    }

    @Override
    protected void checkDaoConfig() {
        Assert.notNull((Object)this.sqlMode, (String)"Property 'sqlMode' is required");
        Assert.notNull((Object)this.sqlMode, (String)"Property 'keywordMode' is required");
        Assert.notNull((Object)this.databaseType, (String)"Property 'databaseType' is required");
        WordMode sqlMode0 = null;
        WordMode keywordMode0 = null;
        DatabaseType databaseType0 = null;
        sqlMode0 = WordMode.valueOf((String)this.sqlMode);
        if (sqlMode0 == null) {
            throw new IllegalArgumentException("Property 'sqlMode' must is lowerCase or upperCase ");
        }
        keywordMode0 = WordMode.valueOf((String)this.keywordMode);
        if (keywordMode0 == null) {
            throw new IllegalArgumentException("Property 'keywordMode' must is lowerCase or upperCase ");
        }
        databaseType0 = DatabaseType.valueOf((String)this.databaseType);
        if (databaseType0 == null) {
            throw new IllegalArgumentException("Property 'databaseType' must is lowerCase or upperCase ");
        }
        super.checkDaoConfig();
        Assert.notNull(this.mapperInterface, (String)"Property 'mapperInterface' is required");
        Configuration configuration = this.getSqlSession().getConfiguration();
        configuration.addInterceptor((Interceptor)new PaginationStage1Interceptor(databaseType0));
        configuration.addInterceptor((Interceptor)new PaginationStage2Interceptor());
        MappedStatementRegister.scan(configuration, this.mapperInterface, sqlMode0, keywordMode0, this.strictWing4j, this.sequenceConfigure);
        if (this.addToConfig && !configuration.hasMapper(this.mapperInterface)) {
            try {
                configuration.addMapper(this.mapperInterface);
            }
            catch (Exception e) {
                this.logger.error((Object)("Error while adding the mapper '" + this.mapperInterface + "' to configuration."), (Throwable)e);
                throw new IllegalArgumentException(e);
            }
            finally {
                ErrorContext.instance().reset();
            }
        }
    }

    public T getObject() throws Exception {
        return (T)this.getSqlSession().getMapper(this.mapperInterface);
    }

    public Class<T> getObjectType() {
        return this.mapperInterface;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setMapperInterface(Class<T> mapperInterface) {
        this.mapperInterface = mapperInterface;
    }

    public void setAddToConfig(boolean addToConfig) {
        this.addToConfig = addToConfig;
    }

    public void setSqlMode(String sqlMode) {
        this.sqlMode = sqlMode;
    }

    public void setKeywordMode(String keywordMode) {
        this.keywordMode = keywordMode;
    }

    public void setStrictWing4j(boolean strictWing4j) {
        this.strictWing4j = strictWing4j;
    }

    public void setSequenceConfigure(SequenceServiceConfigure sequenceConfigure) {
        this.sequenceConfigure = sequenceConfigure;
    }

    public void setDatabaseType(String databaseType) {
        this.databaseType = databaseType;
    }
}

