/*
 * Decompiled with CFR 0.152.
 */
package org.wing4j.orm.mybatis.mapper.builder.update;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMap;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.scripting.xmltags.DynamicSqlSource;
import org.apache.ibatis.scripting.xmltags.IfSqlNode;
import org.apache.ibatis.scripting.xmltags.MixedSqlNode;
import org.apache.ibatis.scripting.xmltags.SqlNode;
import org.apache.ibatis.scripting.xmltags.TextSqlNode;
import org.apache.ibatis.scripting.xmltags.TrimSqlNode;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.JdbcType;
import org.wing4j.orm.WordMode;
import org.wing4j.orm.entity.metadata.ColumnMetadata;
import org.wing4j.orm.entity.metadata.TableMetadata;
import org.wing4j.orm.entity.utils.EntityExtracteUtils;
import org.wing4j.orm.entity.utils.GenericityExtracteUtils;
import org.wing4j.orm.entity.utils.KeywordsUtils;
import org.wing4j.orm.mybatis.mapper.builder.MappedStatementBuilder;
import org.wing4j.orm.select.SelectMapper;

public class UpdateByPrimaryKeySelectiveMappedStatementBuilder
extends MappedStatementBuilder {
    public UpdateByPrimaryKeySelectiveMappedStatementBuilder(Configuration config, Class mapperClass, WordMode sqlMode, WordMode keywordMode, boolean strictWing4j) {
        super(config, mapperClass.getName(), mapperClass, GenericityExtracteUtils.extractEntityClass((Class)mapperClass, SelectMapper.class), GenericityExtracteUtils.extractKeyClass((Class)mapperClass, SelectMapper.class), sqlMode, keywordMode, strictWing4j);
    }

    @Override
    public MappedStatement build() {
        TableMetadata tableMetadata = EntityExtracteUtils.extractTable((Class)this.entityClass, (boolean)this.strictWing4j);
        String primaryKeyName = (String)tableMetadata.getPrimaryKeys().get(0);
        Map fields = tableMetadata.getColumnMetadatas();
        ColumnMetadata primaryKeyColumn = (ColumnMetadata)fields.get(primaryKeyName);
        String update = KeywordsUtils.convert((String)"UPDATE", (WordMode)this.keywordMode);
        String where = KeywordsUtils.convert((String)"WHERE", (WordMode)this.keywordMode);
        StringBuilder headBuilder = new StringBuilder();
        headBuilder.append(update).append(" ");
        headBuilder.append(KeywordsUtils.convert((String)tableMetadata.getTableName(), (WordMode)this.sqlMode)).append(" ");
        String primaryKeySql = "#{" + primaryKeyColumn.getJavaName() + ":" + primaryKeyColumn.getJdbcType() + " }";
        StringBuilder footBuilder = new StringBuilder();
        footBuilder.append(where).append(" ");
        footBuilder.append(KeywordsUtils.convert((String)primaryKeyName, (WordMode)this.sqlMode)).append(" = ").append(primaryKeySql);
        ArrayList<IfSqlNode> sets = new ArrayList<IfSqlNode>();
        ArrayList<ParameterMapping> parameterMappings = new ArrayList<ParameterMapping>();
        for (String column : tableMetadata.getOrderColumns()) {
            if (column.equals(primaryKeyName)) continue;
            ColumnMetadata columnMetadata = (ColumnMetadata)fields.get(column);
            String valueSql = "#{" + columnMetadata.getJavaName() + ":" + columnMetadata.getJdbcType() + " }";
            StringBuilder sqlBuilder = new StringBuilder();
            sqlBuilder.append(KeywordsUtils.convert((String)column, (WordMode)this.sqlMode)).append(" = ").append(valueSql).append(" , ");
            sets.add(new IfSqlNode((SqlNode)new TextSqlNode(sqlBuilder.toString()), MessageFormat.format("{0} != null", columnMetadata.getJavaName())));
            ParameterMapping.Builder builder = new ParameterMapping.Builder(this.config, columnMetadata.getJavaName(), columnMetadata.getJavaType());
            builder.jdbcType(JdbcType.valueOf((String)columnMetadata.getJdbcType()));
            parameterMappings.add(builder.build());
        }
        DynamicSqlSource sqlSource = new DynamicSqlSource(this.config, (SqlNode)this.mixedContents(new SqlNode[]{new TextSqlNode(headBuilder.toString()), new TrimSqlNode(this.config, (SqlNode)new MixedSqlNode(sets), KeywordsUtils.convert((String)"SET", (WordMode)this.keywordMode), "", "", ","), new TextSqlNode(footBuilder.toString())}));
        MappedStatement.Builder msBuilder = new MappedStatement.Builder(this.config, this.namespace + "." + "updateByPrimaryKeySelective", (SqlSource)sqlSource, SqlCommandType.UPDATE);
        ParameterMap.Builder paramBuilder = new ParameterMap.Builder(this.config, "BaseParameterMap", this.entityClass, parameterMappings);
        msBuilder.parameterMap(paramBuilder.build());
        MappedStatement ms = msBuilder.build();
        return ms;
    }
}

