/*
 * Decompiled with CFR 0.152.
 */
package org.wing4j.orm.mybatis.mapper.builder.select;

import java.util.ArrayList;
import java.util.Map;
import org.apache.ibatis.builder.StaticSqlSource;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.session.Configuration;
import org.wing4j.orm.WordMode;
import org.wing4j.orm.entity.metadata.ColumnMetadata;
import org.wing4j.orm.entity.metadata.TableMetadata;
import org.wing4j.orm.entity.utils.EntityExtracteUtils;
import org.wing4j.orm.entity.utils.GenericityExtracteUtils;
import org.wing4j.orm.entity.utils.KeywordsUtils;
import org.wing4j.orm.entity.utils.SqlScriptUtils;
import org.wing4j.orm.mybatis.mapper.builder.MappedStatementBuilder;
import org.wing4j.orm.select.SelectMapper;

public class SelectAllMappedStatementBuilder
extends MappedStatementBuilder {
    public SelectAllMappedStatementBuilder(Configuration config, Class mapperClass, WordMode sqlMode, WordMode keywordMode, boolean strictWing4j) {
        super(config, mapperClass.getName(), mapperClass, GenericityExtracteUtils.extractEntityClass((Class)mapperClass, SelectMapper.class), GenericityExtracteUtils.extractKeyClass((Class)mapperClass, SelectMapper.class), sqlMode, keywordMode, strictWing4j);
    }

    @Override
    public MappedStatement build() {
        TableMetadata tableMetadata = EntityExtracteUtils.extractTable((Class)this.entityClass, (boolean)this.strictWing4j);
        Map fields = tableMetadata.getColumnMetadatas();
        String select = KeywordsUtils.convert((String)"SELECT", (WordMode)this.keywordMode);
        String from = KeywordsUtils.convert((String)"FROM", (WordMode)this.keywordMode);
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append(select).append(" ");
        sqlBuilder.append(SqlScriptUtils.genreateSqlHead((Class)this.entityClass, (WordMode)this.keywordMode, (WordMode)this.sqlMode, (boolean)false)).append(" ");
        sqlBuilder.append(from).append(" ");
        sqlBuilder.append(KeywordsUtils.convert((String)tableMetadata.getTableName(), (WordMode)this.sqlMode)).append(" ");
        StaticSqlSource sqlSource = new StaticSqlSource(this.config, sqlBuilder.toString());
        MappedStatement.Builder msBuilder = new MappedStatement.Builder(this.config, this.namespace + "." + "selectAll", (SqlSource)sqlSource, SqlCommandType.SELECT);
        ArrayList<ResultMapping> resultMappings = new ArrayList<ResultMapping>();
        for (String column : fields.keySet()) {
            ColumnMetadata columnMetadata = (ColumnMetadata)fields.get(column);
            ResultMapping.Builder builder = new ResultMapping.Builder(this.config, columnMetadata.getJavaName(), columnMetadata.getJdbcName(), columnMetadata.getJavaType());
            resultMappings.add(builder.build());
        }
        ResultMap resultMap = new ResultMap.Builder(this.config, "BaseResultMap", this.entityClass, resultMappings).build();
        ArrayList<ResultMap> resultMaps = new ArrayList<ResultMap>();
        resultMaps.add(resultMap);
        msBuilder.resultMaps(resultMaps);
        MappedStatement ms = msBuilder.build();
        return ms;
    }
}

