/*
 * Decompiled with CFR 0.152.
 */
package org.wing4j.orm.mybatis.mapper.builder.insert;

import java.lang.reflect.Method;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.keygen.Jdbc3KeyGenerator;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMap;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.scripting.xmltags.DynamicSqlSource;
import org.apache.ibatis.scripting.xmltags.MixedSqlNode;
import org.apache.ibatis.scripting.xmltags.SqlNode;
import org.apache.ibatis.scripting.xmltags.TextSqlNode;
import org.apache.ibatis.scripting.xmltags.TrimSqlNode;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.JdbcType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wing4j.common.logtrack.ErrorContextFactory;
import org.wing4j.common.sequence.SequenceService;
import org.wing4j.common.utils.DateStyle;
import org.wing4j.common.utils.DateUtils;
import org.wing4j.common.utils.StringUtils;
import org.wing4j.orm.PrimaryKeyStrategy;
import org.wing4j.orm.WordMode;
import org.wing4j.orm.entity.exception.OrmEntityRuntimeException;
import org.wing4j.orm.entity.metadata.ColumnMetadata;
import org.wing4j.orm.entity.metadata.TableMetadata;
import org.wing4j.orm.entity.utils.EntityExtracteUtils;
import org.wing4j.orm.entity.utils.GenericityExtracteUtils;
import org.wing4j.orm.entity.utils.KeywordsUtils;
import org.wing4j.orm.mybatis.mapper.builder.MappedStatementBuilder;
import org.wing4j.orm.mybatis.sequnece.SequenceServiceConfigure;
import org.wing4j.orm.select.SelectMapper;

public class InsertMappedStatementBuilder
extends MappedStatementBuilder {
    private static final Logger log = LoggerFactory.getLogger(InsertMappedStatementBuilder.class);
    protected SequenceServiceConfigure sequenceConfigure;

    public InsertMappedStatementBuilder(Configuration config, Class mapperClass, WordMode sqlMode, WordMode keywordMode, boolean strictWing4j, SequenceServiceConfigure sequenceConfigure) {
        super(config, mapperClass.getName(), mapperClass, GenericityExtracteUtils.extractEntityClass((Class)mapperClass, SelectMapper.class), GenericityExtracteUtils.extractKeyClass((Class)mapperClass, SelectMapper.class), sqlMode, keywordMode, strictWing4j);
        this.sequenceConfigure = sequenceConfigure;
    }

    @Override
    public MappedStatement build() {
        TableMetadata tableMetadata = EntityExtracteUtils.extractTable((Class)this.entityClass, (boolean)this.strictWing4j);
        TextSqlNode insertIntoSqlNode = new TextSqlNode(KeywordsUtils.convert((String)"INSERT INTO ", (WordMode)this.keywordMode) + KeywordsUtils.convert((String)tableMetadata.getTableName(), (WordMode)this.keywordMode) + "(");
        ArrayList<TextSqlNode> heads = new ArrayList<TextSqlNode>();
        ArrayList<TextSqlNode> values = new ArrayList<TextSqlNode>();
        Map fields = tableMetadata.getColumnMetadatas();
        for (String column : tableMetadata.getOrderColumns()) {
            ColumnMetadata columnMetadata = (ColumnMetadata)fields.get(column);
            heads.add(new TextSqlNode(KeywordsUtils.convert((String)columnMetadata.getJdbcName(), (WordMode)this.sqlMode) + ","));
            String valueExp = "#{" + columnMetadata.getJavaName() + ":" + columnMetadata.getJdbcType() + " },";
            values.add(new TextSqlNode(valueExp));
        }
        MixedSqlNode headsSqlNode = new MixedSqlNode(heads);
        MixedSqlNode valuesSqlNode = new MixedSqlNode(values);
        DynamicSqlSource sqlSource = new DynamicSqlSource(this.config, (SqlNode)this.mixedContents(new SqlNode[]{insertIntoSqlNode, new TrimSqlNode(this.config, (SqlNode)headsSqlNode, "", "", "", ","), new TextSqlNode(") "), new TextSqlNode(KeywordsUtils.convert((String)"VALUES", (WordMode)this.keywordMode)), new TextSqlNode(" ("), new TrimSqlNode(this.config, (SqlNode)valuesSqlNode, "", "", "", ","), new TextSqlNode(")")}));
        MappedStatement.Builder msBuilder = new MappedStatement.Builder(this.config, this.namespace + "." + "insert", (SqlSource)sqlSource, SqlCommandType.INSERT);
        msBuilder = msBuilder.flushCacheRequired(true).useCache(false);
        ArrayList<ParameterMapping> parameterMappings = new ArrayList<ParameterMapping>();
        for (String column : fields.keySet()) {
            ColumnMetadata columnMetadata = (ColumnMetadata)fields.get(column);
            ParameterMapping.Builder builder = new ParameterMapping.Builder(this.config, columnMetadata.getJavaName(), columnMetadata.getJavaType());
            builder.jdbcType(JdbcType.valueOf((String)columnMetadata.getJdbcType()));
            parameterMappings.add(builder.build());
        }
        ParameterMap.Builder paramBuilder = new ParameterMap.Builder(this.config, "BaseParameterMap", this.entityClass, parameterMappings);
        List primaryKeys = tableMetadata.getPrimaryKeys();
        if (!primaryKeys.isEmpty()) {
            String pkColumonName = (String)primaryKeys.get(0);
            final ColumnMetadata primaryKeyMetadata = (ColumnMetadata)fields.get(pkColumonName);
            if (primaryKeyMetadata.getPrimaryKeyStrategy() == PrimaryKeyStrategy.IDENTITY) {
                log.debug("use int increment");
                msBuilder.keyColumn(primaryKeyMetadata.getJdbcName());
                msBuilder.keyProperty(primaryKeyMetadata.getJavaName());
                msBuilder.keyGenerator((KeyGenerator)new Jdbc3KeyGenerator());
            } else if (primaryKeyMetadata.getPrimaryKeyStrategy() == PrimaryKeyStrategy.UUID) {
                log.debug("use uuid");
                Class entityClass1 = this.entityClass;
                String getterMethodName = "get" + StringUtils.firstCharToUpper((String)primaryKeyMetadata.getJavaName());
                String setterMethodName = "set" + StringUtils.firstCharToUpper((String)primaryKeyMetadata.getJavaName());
                Method getMethod0 = null;
                Method setMethod0 = null;
                try {
                    getMethod0 = entityClass1.getMethod(getterMethodName, new Class[0]);
                    setMethod0 = entityClass1.getMethod(setterMethodName, primaryKeyMetadata.getJavaType());
                }
                catch (NoSuchMethodException e) {
                    throw new OrmEntityRuntimeException(ErrorContextFactory.instance().activity("\u6b63\u5728\u4f7f\u7528wing4j orm \u7684\u81ea\u52a8\u751f\u6210\u4e3b\u952e", new Object[0]).message("\u83b7\u53d6\u8bbe\u7f6e\u5b57\u6bb5{}\u4e3b\u952e\u503c\u53d1\u751f\u9519\u8bef", new Object[]{primaryKeyMetadata.getJavaName()}).solution("\u68c0\u67e5\u5b9e\u4f53{}\u5b57\u6bb5{}\u662f\u5426\u4e3apublic", new Object[]{primaryKeyMetadata.getEntityClass(), primaryKeyMetadata.getJavaName()}).cause((Throwable)e));
                }
                final Method setMethod = setMethod0;
                final Method getMethod = getMethod0;
                msBuilder.keyGenerator(new KeyGenerator(){

                    public void processBefore(Executor executor, MappedStatement ms, Statement stmt, Object parameter) {
                        try {
                            if (getMethod.invoke(parameter, new Object[0]) != null) {
                                return;
                            }
                            setMethod.invoke(parameter, UUID.randomUUID().toString());
                        }
                        catch (Exception e) {
                            throw new OrmEntityRuntimeException(ErrorContextFactory.instance().activity("\u6b63\u5728\u4f7f\u7528wing4j orm \u7684\u81ea\u52a8\u751f\u6210\u4e3b\u952e", new Object[0]).message("\u83b7\u53d6\u8bbe\u7f6e\u5b57\u6bb5{}\u4e3b\u952e\u503c\u53d1\u751f\u9519\u8bef", new Object[]{primaryKeyMetadata.getJavaName()}).solution("\u68c0\u67e5\u5b9e\u4f53{}\u5b57\u6bb5{}\u662f\u5426\u4e3apublic", new Object[]{primaryKeyMetadata.getEntityClass(), primaryKeyMetadata.getJavaName()}));
                        }
                    }

                    public void processAfter(Executor executor, MappedStatement ms, Statement stmt, Object parameter) {
                    }
                });
            } else if (primaryKeyMetadata.getPrimaryKeyStrategy() == PrimaryKeyStrategy.SEQUENCE) {
                log.debug("use sequence");
                final String schema = primaryKeyMetadata.getTableMetadata().getSchema();
                final String tableName = primaryKeyMetadata.getTableMetadata().getTableName();
                final String tablePrefix = KeywordsUtils.convert((String)tableName.substring(0, tableName.indexOf("_")), (WordMode)this.sqlMode);
                String feature = primaryKeyMetadata.getPrimaryKeyFeature();
                String getterMethodName = "get" + StringUtils.firstCharToUpper((String)primaryKeyMetadata.getJavaName());
                String setterMethodName = "set" + StringUtils.firstCharToUpper((String)primaryKeyMetadata.getJavaName());
                Method setMethod0 = null;
                try {
                    setMethod0 = tableMetadata.getEntityClass().getMethod(setterMethodName, primaryKeyMetadata.getJavaType());
                }
                catch (NoSuchMethodException e) {
                    throw new OrmEntityRuntimeException(ErrorContextFactory.instance().activity("\u6b63\u5728\u4f7f\u7528wing4j orm \u7684\u81ea\u52a8\u751f\u6210\u4e3b\u952e", new Object[0]).message("\u83b7\u53d6\u8bbe\u7f6e\u5b57\u6bb5{}\u4e3b\u952e\u503c\u53d1\u751f\u9519\u8bef", new Object[]{primaryKeyMetadata.getJavaName()}).solution("\u68c0\u67e5\u5b9e\u4f53{}\u5b57\u6bb5{}\u662f\u5426\u4e3apublic", new Object[]{primaryKeyMetadata.getEntityClass(), primaryKeyMetadata.getJavaName()}).cause((Throwable)e));
                }
                final Method setMethod = setMethod0;
                String seqFeature0 = null;
                seqFeature0 = feature.equals("${new Date()}") ? DateUtils.toFullString((Date)new Date()) : (feature.equals("${yyyyMMddHHmmssSSS}") ? DateUtils.toString((Date)new Date(), (DateStyle)DateStyle.FILE_FORMAT2) : (feature.equals("${yyyyMMddHHmmss}") ? DateUtils.toString((Date)new Date(), (DateStyle)DateStyle.FILE_FORMAT3) : (feature.equals("${yyyyMMddHHmm}") ? DateUtils.toString((Date)new Date(), (DateStyle)DateStyle.FILE_FORMAT4) : (feature.equals("${yyyyMMddHH}") ? DateUtils.toString((Date)new Date(), (DateStyle)DateStyle.FILE_FORMAT5) : (feature.equals("${yyyyMMdd}") ? DateUtils.toString((Date)new Date(), (DateStyle)DateStyle.FILE_FORMAT6) : feature)))));
                final String seqFeature = seqFeature0;
                final SequenceService sequenceService = this.sequenceConfigure.getSequenceService(tableMetadata.getTableName());
                msBuilder.keyGenerator(new KeyGenerator(){

                    public void processBefore(Executor executor, MappedStatement ms, Statement stmt, Object parameter) {
                        int pk = 0;
                        try {
                            pk = sequenceService.nextval(schema, tablePrefix, tableName, seqFeature);
                        }
                        catch (Exception e) {
                            throw new OrmEntityRuntimeException(ErrorContextFactory.instance().activity("\u6b63\u5728\u4f7f\u7528wing4j orm \u7684\u81ea\u52a8\u751f\u6210\u4e3b\u952e", new Object[0]).message("\u751f\u6210\u5e8f\u5217\u53f7\u53d1\u751f\u5f02\u5e38", new Object[0]).solution("\u68c0\u67e5\u5e8f\u5217\u53f7\u4ecb\u8d28\u662f\u5426\u5b58\u5728\uff0c\u5728'autoCreate'\u5c5e\u6027\u8bbe\u7f6e\u4e3atrue", new Object[0]));
                        }
                        try {
                            setMethod.invoke(parameter, pk);
                        }
                        catch (Exception e) {
                            throw new OrmEntityRuntimeException(ErrorContextFactory.instance().activity("\u6b63\u5728\u4f7f\u7528wing4j orm \u7684\u81ea\u52a8\u751f\u6210\u4e3b\u952e", new Object[0]).message("\u83b7\u53d6\u8bbe\u7f6e\u5b57\u6bb5{}\u4e3b\u952e\u503c\u53d1\u751f\u9519\u8bef", new Object[]{primaryKeyMetadata.getJavaName()}).solution("\u68c0\u67e5\u5b9e\u4f53{}\u5b57\u6bb5{}\u662f\u5426\u4e3apublic", new Object[]{primaryKeyMetadata.getEntityClass(), primaryKeyMetadata.getJavaName()}));
                        }
                    }

                    public void processAfter(Executor executor, MappedStatement ms, Statement stmt, Object parameter) {
                    }
                });
            }
        }
        msBuilder.parameterMap(paramBuilder.build());
        MappedStatement ms = msBuilder.build();
        return ms;
    }
}

