/*
 * Decompiled with CFR 0.152.
 */
package org.wing4j.orm.mybatis.mapper.builder.lock;

import java.util.Map;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.scripting.xmltags.DynamicSqlSource;
import org.apache.ibatis.scripting.xmltags.SqlNode;
import org.apache.ibatis.scripting.xmltags.TextSqlNode;
import org.apache.ibatis.session.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wing4j.orm.WordMode;
import org.wing4j.orm.entity.metadata.ColumnMetadata;
import org.wing4j.orm.entity.metadata.TableMetadata;
import org.wing4j.orm.entity.utils.EntityExtracteUtils;
import org.wing4j.orm.entity.utils.GenericityExtracteUtils;
import org.wing4j.orm.entity.utils.KeywordsUtils;
import org.wing4j.orm.mybatis.mapper.builder.MappedStatementBuilder;
import org.wing4j.orm.select.SelectMapper;

public class LockByUpdateSetPrimaryKeyMappedStatementBuilder
extends MappedStatementBuilder {
    private static final Logger log = LoggerFactory.getLogger(LockByUpdateSetPrimaryKeyMappedStatementBuilder.class);

    public LockByUpdateSetPrimaryKeyMappedStatementBuilder(Configuration config, Class mapperClass, WordMode sqlMode, WordMode keywordMode) {
        super(config, mapperClass.getName(), mapperClass, GenericityExtracteUtils.extractEntityClass((Class)mapperClass, SelectMapper.class), GenericityExtracteUtils.extractKeyClass((Class)mapperClass, SelectMapper.class), sqlMode, keywordMode);
    }

    @Override
    public MappedStatement build() {
        TableMetadata tableMetadata = EntityExtracteUtils.extractTable((Class)this.entityClass);
        String primaryKeyName = (String)tableMetadata.getPrimaryKeys().get(0);
        Map fields = tableMetadata.getColumnMetadatas();
        ColumnMetadata primaryKeyColumn = (ColumnMetadata)fields.get(primaryKeyName);
        String update = KeywordsUtils.convert((String)"UPDATE", (WordMode)this.keywordMode);
        StringBuilder headBuilder = new StringBuilder();
        headBuilder.append(update).append(" ");
        headBuilder.append(KeywordsUtils.convert((String)tableMetadata.getName(), (WordMode)this.sqlMode)).append(" ");
        headBuilder.append(KeywordsUtils.convert((String)"SET", (WordMode)this.keywordMode)).append(" ");
        headBuilder.append(KeywordsUtils.convert((String)primaryKeyColumn.getJdbcName(), (WordMode)this.sqlMode)).append(" ");
        headBuilder.append("=");
        headBuilder.append(KeywordsUtils.convert((String)primaryKeyColumn.getJdbcName(), (WordMode)this.sqlMode)).append(" ");
        String where = KeywordsUtils.convert((String)"WHERE", (WordMode)this.keywordMode);
        String primaryKeySql = "#{" + primaryKeyColumn.getJavaName() + ":" + primaryKeyColumn.getJdbcType() + " }";
        StringBuilder footBuilder = new StringBuilder();
        footBuilder.append(where).append(" ");
        footBuilder.append(KeywordsUtils.convert((String)primaryKeyName, (WordMode)this.sqlMode)).append(" = ").append(primaryKeySql);
        DynamicSqlSource sqlSource = new DynamicSqlSource(this.config, (SqlNode)this.mixedContents(new SqlNode[]{new TextSqlNode(headBuilder.toString()), new TextSqlNode(footBuilder.toString())}));
        MappedStatement.Builder msBuilder = new MappedStatement.Builder(this.config, this.namespace + "." + "lockByUpdateSetPrimaryKey", (SqlSource)sqlSource, SqlCommandType.UPDATE);
        MappedStatement ms = msBuilder.build();
        return ms;
    }
}

