/*
 * Decompiled with CFR 0.152.
 */
package org.wing4j.orm.mybatis.mapper.builder.insert;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.executor.keygen.Jdbc3KeyGenerator;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMap;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.scripting.xmltags.DynamicSqlSource;
import org.apache.ibatis.scripting.xmltags.IfSqlNode;
import org.apache.ibatis.scripting.xmltags.MixedSqlNode;
import org.apache.ibatis.scripting.xmltags.SqlNode;
import org.apache.ibatis.scripting.xmltags.TextSqlNode;
import org.apache.ibatis.scripting.xmltags.TrimSqlNode;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.JdbcType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wing4j.orm.WordMode;
import org.wing4j.orm.entity.metadata.ColumnMetadata;
import org.wing4j.orm.entity.metadata.TableMetadata;
import org.wing4j.orm.entity.utils.EntityExtracteUtils;
import org.wing4j.orm.entity.utils.GenericityExtracteUtils;
import org.wing4j.orm.entity.utils.KeywordsUtils;
import org.wing4j.orm.mybatis.mapper.builder.MappedStatementBuilder;
import org.wing4j.orm.select.SelectMapper;

public class InsertSelectiveMappedStatementBuilder
extends MappedStatementBuilder {
    private static final Logger log = LoggerFactory.getLogger(InsertSelectiveMappedStatementBuilder.class);

    public InsertSelectiveMappedStatementBuilder(Configuration config, Class mapperClass, WordMode sqlMode, WordMode keywordMode) {
        super(config, mapperClass.getName(), mapperClass, GenericityExtracteUtils.extractEntityClass((Class)mapperClass, SelectMapper.class), GenericityExtracteUtils.extractKeyClass((Class)mapperClass, SelectMapper.class), sqlMode, keywordMode);
    }

    @Override
    public MappedStatement build() {
        String pkColumonName;
        ColumnMetadata primaryKeyMetadata;
        TableMetadata tableMetadata = EntityExtracteUtils.extractTable((Class)this.entityClass);
        TextSqlNode insertIntoSqlNode = new TextSqlNode(KeywordsUtils.convert((String)"INSERT INTO ", (WordMode)this.keywordMode) + KeywordsUtils.convert((String)tableMetadata.getName(), (WordMode)this.keywordMode) + "(");
        ArrayList<IfSqlNode> heads = new ArrayList<IfSqlNode>();
        ArrayList<IfSqlNode> values = new ArrayList<IfSqlNode>();
        Map fields = tableMetadata.getColumnMetadatas();
        for (String column : tableMetadata.getOrderColumns()) {
            ColumnMetadata columnMetadata = (ColumnMetadata)fields.get(column);
            heads.add(new IfSqlNode((SqlNode)new TextSqlNode(KeywordsUtils.convert((String)columnMetadata.getJdbcName(), (WordMode)this.sqlMode) + ","), columnMetadata.getJavaName() + " != null"));
            String valueExp = "#{" + columnMetadata.getJavaName() + ":" + columnMetadata.getJdbcType() + " },";
            values.add(new IfSqlNode((SqlNode)new TextSqlNode(valueExp), columnMetadata.getJavaName() + " != null"));
        }
        MixedSqlNode headsSqlNode = new MixedSqlNode(heads);
        MixedSqlNode valuesSqlNode = new MixedSqlNode(values);
        DynamicSqlSource sqlSource = new DynamicSqlSource(this.config, (SqlNode)this.mixedContents(new SqlNode[]{insertIntoSqlNode, new TrimSqlNode(this.config, (SqlNode)headsSqlNode, "", "", "", ","), new TextSqlNode(") "), new TextSqlNode(KeywordsUtils.convert((String)"VALUES", (WordMode)this.keywordMode)), new TextSqlNode(" ("), new TrimSqlNode(this.config, (SqlNode)valuesSqlNode, "", "", "", ","), new TextSqlNode(")")}));
        MappedStatement.Builder msBuilder = new MappedStatement.Builder(this.config, this.namespace + "." + "insertSelective", (SqlSource)sqlSource, SqlCommandType.INSERT);
        ArrayList<ParameterMapping> parameterMappings = new ArrayList<ParameterMapping>();
        for (String column : fields.keySet()) {
            ColumnMetadata columnMetadata = (ColumnMetadata)fields.get(column);
            ParameterMapping.Builder builder = new ParameterMapping.Builder(this.config, columnMetadata.getJavaName(), columnMetadata.getJavaType());
            builder.jdbcType(JdbcType.valueOf((String)columnMetadata.getJdbcType()));
            parameterMappings.add(builder.build());
        }
        ParameterMap.Builder paramBuilder = new ParameterMap.Builder(this.config, "BaseParameterMap", this.entityClass, parameterMappings);
        List primaryKeys = tableMetadata.getPrimaryKeys();
        if (!primaryKeys.isEmpty() && (primaryKeyMetadata = (ColumnMetadata)fields.get(pkColumonName = (String)primaryKeys.get(0))).getAutoIncrement().booleanValue()) {
            log.debug("use Jdbc3KeyGenerator");
            msBuilder.keyColumn(primaryKeyMetadata.getJdbcName());
            msBuilder.keyProperty(primaryKeyMetadata.getJavaName());
            msBuilder.keyGenerator((KeyGenerator)new Jdbc3KeyGenerator());
        }
        msBuilder.parameterMap(paramBuilder.build());
        MappedStatement ms = msBuilder.build();
        return ms;
    }
}

