/*
 * Decompiled with CFR 0.152.
 */
package org.wing4j.orm.mybatis.mapper.builder.delete;

import org.apache.ibatis.builder.StaticSqlSource;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wing4j.orm.WordMode;
import org.wing4j.orm.entity.metadata.TableMetadata;
import org.wing4j.orm.entity.utils.EntityExtracteUtils;
import org.wing4j.orm.entity.utils.GenericityExtracteUtils;
import org.wing4j.orm.entity.utils.KeywordsUtils;
import org.wing4j.orm.mybatis.mapper.builder.MappedStatementBuilder;
import org.wing4j.orm.select.SelectMapper;

public class TruncateMappedStatementBuilder
extends MappedStatementBuilder {
    private static final Logger log = LoggerFactory.getLogger(TruncateMappedStatementBuilder.class);

    public TruncateMappedStatementBuilder(Configuration config, Class mapperClass, WordMode sqlMode, WordMode keywordMode) {
        super(config, mapperClass.getName(), mapperClass, GenericityExtracteUtils.extractEntityClass((Class)mapperClass, SelectMapper.class), GenericityExtracteUtils.extractKeyClass((Class)mapperClass, SelectMapper.class), sqlMode, keywordMode);
    }

    @Override
    public MappedStatement build() {
        TypeHandlerRegistry registry = this.config.getTypeHandlerRegistry();
        TableMetadata tableMetadata = EntityExtracteUtils.extractTable((Class)this.entityClass);
        String truncate = KeywordsUtils.convert((String)"TRUNCATE TABLE ", (WordMode)this.keywordMode);
        String tableName = KeywordsUtils.convert((String)tableMetadata.getName(), (WordMode)this.keywordMode);
        StaticSqlSource sqlSource = new StaticSqlSource(this.config, truncate + tableName);
        MappedStatement.Builder msBuilder = new MappedStatement.Builder(this.config, this.namespace + "." + "truncate", (SqlSource)sqlSource, SqlCommandType.DELETE);
        MappedStatement ms = msBuilder.build();
        return ms;
    }
}

