package org.wing4j.orm.mybatis.plugins;

import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.*;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.wing4j.orm.Pagination;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

@Intercepts({@Signature(method = "query", type = Executor.class, args = {MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class PaginationStage2Interceptor implements Interceptor {

    private String databaseType;//数据库类型，不同的数据库有不同的分页方法

    /**
     * 拦截后要执行的方法
     */
    public Object intercept(Invocation invocation) throws Throwable {
        Object obj = invocation.getArgs()[1];
        //这里我们简单的通过传入的是Page对象就认定它是需要进行分页操作的。
        if (obj instanceof Pagination) {
            Pagination pagination = (Pagination) obj;
            List result = (List) invocation.proceed();
            pagination.setRecords(result);
            List<Pagination> list = new ArrayList<>();
            list.add(pagination);
            return list;
        } else {
            Object result = invocation.proceed();
            return result;
        }

    }


    /**
     * 拦截器对应的封装原始对象的方法
     */
    public Object plugin(Object target) {
        return Plugin.wrap(target, this);
    }

    @Override
    public void setProperties(Properties properties) {

    }
}