/*
 * Decompiled with CFR 0.152.
 */
package org.wikimedia.search.extra.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.function.IntPredicate;
import lombok.Generated;

public abstract class ConcreteIntPredicate
implements IntPredicate {
    private ConcreteIntPredicate() {
    }

    @Override
    public final ConcreteIntPredicate and(IntPredicate intPredicate) {
        if (!(intPredicate instanceof ConcreteIntPredicate)) {
            throw new IllegalArgumentException("intPredicate must be an instance of ConcreteIntPredicate");
        }
        return new ConjunctionIntPredicate(this, intPredicate);
    }

    @Override
    public final ConcreteIntPredicate negate() {
        return new NegationIntPredicate(this);
    }

    @Override
    public final ConcreteIntPredicate or(IntPredicate intPredicate) {
        if (!(intPredicate instanceof ConcreteIntPredicate)) {
            throw new IllegalArgumentException("intPredicate must be an instance of ConcreteIntPredicate");
        }
        return new DisjunctionIntPredicate(this, intPredicate);
    }

    @SuppressFBWarnings(value={"AOM_ABSTRACT_OVERRIDDEN_METHOD"}, justification="We want subclasses to implement this")
    public abstract int hashCode();

    @SuppressFBWarnings(value={"AOM_ABSTRACT_OVERRIDDEN_METHOD"}, justification="We want subclasses to implement this")
    public abstract boolean equals(Object var1);

    @SuppressFBWarnings(value={"AOM_ABSTRACT_OVERRIDDEN_METHOD"}, justification="We want subclasses to implement this")
    public abstract String toString();

    public static ConcreteIntPredicate gt(int i) {
        return new GTIntPredicate(i);
    }

    public static ConcreteIntPredicate gte(int i) {
        return new GTEIntPredicate(i);
    }

    public static ConcreteIntPredicate lte(int i) {
        return new LTEIntPredicate(i);
    }

    public static ConcreteIntPredicate lt(int i) {
        return new LTIntPredicate(i);
    }

    public static ConcreteIntPredicate eq(int i) {
        return new EqualsIntPredicate(i);
    }

    private static class LTEIntPredicate
    extends ConcreteIntPredicate {
        private final int value;

        LTEIntPredicate(int value) {
            this.value = value;
        }

        @Override
        public boolean test(int i) {
            return i <= this.value;
        }

        @Override
        public String toString() {
            return "<= " + this.value;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LTEIntPredicate)) {
                return false;
            }
            LTEIntPredicate other = (LTEIntPredicate)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.value == other.value;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LTEIntPredicate;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.value;
            return result;
        }
    }

    private static class LTIntPredicate
    extends ConcreteIntPredicate {
        private final int value;

        LTIntPredicate(int value) {
            this.value = value;
        }

        @Override
        public boolean test(int i) {
            return i < this.value;
        }

        @Override
        public String toString() {
            return "< " + this.value;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LTIntPredicate)) {
                return false;
            }
            LTIntPredicate other = (LTIntPredicate)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.value == other.value;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LTIntPredicate;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.value;
            return result;
        }
    }

    private static class GTEIntPredicate
    extends ConcreteIntPredicate {
        private final int value;

        GTEIntPredicate(int value) {
            this.value = value;
        }

        @Override
        public boolean test(int i) {
            return i >= this.value;
        }

        @Override
        public String toString() {
            return ">= " + this.value;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GTEIntPredicate)) {
                return false;
            }
            GTEIntPredicate other = (GTEIntPredicate)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.value == other.value;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof GTEIntPredicate;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.value;
            return result;
        }
    }

    private static class GTIntPredicate
    extends ConcreteIntPredicate {
        private final int value;

        GTIntPredicate(int value) {
            this.value = value;
        }

        @Override
        public boolean test(int i) {
            return i > this.value;
        }

        @Override
        public String toString() {
            return "> " + this.value;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GTIntPredicate)) {
                return false;
            }
            GTIntPredicate other = (GTIntPredicate)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.value == other.value;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof GTIntPredicate;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.value;
            return result;
        }
    }

    private static class EqualsIntPredicate
    extends ConcreteIntPredicate {
        private final int value;

        EqualsIntPredicate(int value) {
            this.value = value;
        }

        @Override
        public boolean test(int i) {
            return i == this.value;
        }

        @Override
        public String toString() {
            return "= " + this.value;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EqualsIntPredicate)) {
                return false;
            }
            EqualsIntPredicate other = (EqualsIntPredicate)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.value == other.value;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof EqualsIntPredicate;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.value;
            return result;
        }
    }

    class DisjunctionIntPredicate
    extends CompositeIntPredicate {
        DisjunctionIntPredicate(IntPredicate left, IntPredicate right) {
            super(left, right);
        }

        @Override
        public boolean test(int i) {
            return this.left.test(i) || this.right.test(i);
        }

        @Override
        public String toString() {
            return this.left + " or " + this.right;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DisjunctionIntPredicate)) {
                return false;
            }
            DisjunctionIntPredicate other = (DisjunctionIntPredicate)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DisjunctionIntPredicate;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }
    }

    class NegationIntPredicate
    extends ConcreteIntPredicate {
        private final IntPredicate predicate;

        NegationIntPredicate(IntPredicate predicate) {
            this.predicate = predicate;
        }

        @Override
        public boolean test(int i) {
            return !this.predicate.test(i);
        }

        @Override
        public String toString() {
            return "not " + this.predicate;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NegationIntPredicate)) {
                return false;
            }
            NegationIntPredicate other = (NegationIntPredicate)o;
            if (!other.canEqual(this)) {
                return false;
            }
            IntPredicate this$predicate = this.predicate;
            IntPredicate other$predicate = other.predicate;
            return !(this$predicate == null ? other$predicate != null : !this$predicate.equals(other$predicate));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof NegationIntPredicate;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            IntPredicate $predicate = this.predicate;
            result = result * 59 + ($predicate == null ? 43 : $predicate.hashCode());
            return result;
        }
    }

    class ConjunctionIntPredicate
    extends CompositeIntPredicate {
        ConjunctionIntPredicate(IntPredicate left, IntPredicate right) {
            super(left, right);
        }

        @Override
        public boolean test(int i) {
            return this.left.test(i) && this.right.test(i);
        }

        @Override
        public String toString() {
            return this.left + " and " + this.right;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConjunctionIntPredicate)) {
                return false;
            }
            ConjunctionIntPredicate other = (ConjunctionIntPredicate)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ConjunctionIntPredicate;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }
    }

    abstract class CompositeIntPredicate
    extends ConcreteIntPredicate {
        final IntPredicate left;
        final IntPredicate right;

        CompositeIntPredicate(IntPredicate left, IntPredicate right) {
            this.left = left;
            this.right = right;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CompositeIntPredicate)) {
                return false;
            }
            CompositeIntPredicate other = (CompositeIntPredicate)o;
            if (!other.canEqual(this)) {
                return false;
            }
            IntPredicate this$left = this.left;
            IntPredicate other$left = other.left;
            if (this$left == null ? other$left != null : !this$left.equals(other$left)) {
                return false;
            }
            IntPredicate this$right = this.right;
            IntPredicate other$right = other.right;
            return !(this$right == null ? other$right != null : !this$right.equals(other$right));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CompositeIntPredicate;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            IntPredicate $left = this.left;
            result = result * 59 + ($left == null ? 43 : $left.hashCode());
            IntPredicate $right = this.right;
            result = result * 59 + ($right == null ? 43 : $right.hashCode());
            return result;
        }
    }
}

