/*
 * Decompiled with CFR 0.152.
 */
package org.wikimedia.search.extra.analysis.slovak;

import org.apache.lucene.analysis.util.StemmerUtil;

public class SlovakStemmer {
    public int stem(char[] s, int len) {
        len = this.removeCase(s, len);
        len = this.removePossessives(s, len);
        return this.removePrefixes(s, len);
    }

    private int removePrefixes(char[] s, int len) {
        if (len > 5 && StemmerUtil.startsWith((char[])s, (int)len, (String)"naj")) {
            return StemmerUtil.deleteN((char[])s, (int)0, (int)len, (int)3);
        }
        return len;
    }

    private int removeCase(char[] s, int len) {
        if (len > 7 && StemmerUtil.endsWith((char[])s, (int)len, (String)"atoch")) {
            return len - 5;
        }
        if (len > 6 && StemmerUtil.endsWith((char[])s, (int)len, (String)"a\u0165om")) {
            return this.palatalize(s, len - 3);
        }
        if (len > 5) {
            if (StemmerUtil.endsWith((char[])s, (int)len, (String)"och") || StemmerUtil.endsWith((char[])s, (int)len, (String)"ich") || StemmerUtil.endsWith((char[])s, (int)len, (String)"\u00edch") || StemmerUtil.endsWith((char[])s, (int)len, (String)"\u00e9ho") || StemmerUtil.endsWith((char[])s, (int)len, (String)"ami") || StemmerUtil.endsWith((char[])s, (int)len, (String)"emi") || StemmerUtil.endsWith((char[])s, (int)len, (String)"\u00e9mu") || StemmerUtil.endsWith((char[])s, (int)len, (String)"ete") || StemmerUtil.endsWith((char[])s, (int)len, (String)"eti") || StemmerUtil.endsWith((char[])s, (int)len, (String)"iho") || StemmerUtil.endsWith((char[])s, (int)len, (String)"\u00edho") || StemmerUtil.endsWith((char[])s, (int)len, (String)"\u00edmi") || StemmerUtil.endsWith((char[])s, (int)len, (String)"imu") || StemmerUtil.endsWith((char[])s, (int)len, (String)"a\u0165a")) {
                return this.palatalize(s, len - 2);
            }
            if (StemmerUtil.endsWith((char[])s, (int)len, (String)"\u00e1ch") || StemmerUtil.endsWith((char[])s, (int)len, (String)"ata") || StemmerUtil.endsWith((char[])s, (int)len, (String)"aty") || StemmerUtil.endsWith((char[])s, (int)len, (String)"\u00fdch") || StemmerUtil.endsWith((char[])s, (int)len, (String)"ov\u00e9") || StemmerUtil.endsWith((char[])s, (int)len, (String)"ovi") || StemmerUtil.endsWith((char[])s, (int)len, (String)"\u00fdmi")) {
                return len - 3;
            }
        }
        if (len > 4) {
            if (StemmerUtil.endsWith((char[])s, (int)len, (String)"om")) {
                return this.palatalize(s, len - 1);
            }
            if (StemmerUtil.endsWith((char[])s, (int)len, (String)"es") || StemmerUtil.endsWith((char[])s, (int)len, (String)"\u00e9m") || StemmerUtil.endsWith((char[])s, (int)len, (String)"\u00edm")) {
                return this.palatalize(s, len - 2);
            }
            if (StemmerUtil.endsWith((char[])s, (int)len, (String)"\u00fam") || StemmerUtil.endsWith((char[])s, (int)len, (String)"at") || StemmerUtil.endsWith((char[])s, (int)len, (String)"\u00e1m") || StemmerUtil.endsWith((char[])s, (int)len, (String)"os") || StemmerUtil.endsWith((char[])s, (int)len, (String)"us") || StemmerUtil.endsWith((char[])s, (int)len, (String)"\u00fdm") || StemmerUtil.endsWith((char[])s, (int)len, (String)"mi") || StemmerUtil.endsWith((char[])s, (int)len, (String)"ou") || StemmerUtil.endsWith((char[])s, (int)len, (String)"ej")) {
                return len - 2;
            }
        }
        if (len > 3) {
            switch (s[len - 1]) {
                case 'e': 
                case 'i': 
                case '\u00ed': {
                    return this.palatalize(s, len);
                }
                case 'a': 
                case 'o': 
                case 'y': 
                case '\u00e1': 
                case '\u00e9': 
                case '\u00fa': 
                case '\u00fd': {
                    return len - 1;
                }
            }
        }
        return len;
    }

    private int removePossessives(char[] s, int len) {
        if (len > 5) {
            if (StemmerUtil.endsWith((char[])s, (int)len, (String)"ov")) {
                return len - 2;
            }
            if (StemmerUtil.endsWith((char[])s, (int)len, (String)"in")) {
                return this.palatalize(s, len - 1);
            }
        }
        return len;
    }

    private int palatalize(char[] s, int len) {
        assert (len > 3);
        if (StemmerUtil.endsWith((char[])s, (int)len, (String)"ci") || StemmerUtil.endsWith((char[])s, (int)len, (String)"ce") || StemmerUtil.endsWith((char[])s, (int)len, (String)"\u010di") || StemmerUtil.endsWith((char[])s, (int)len, (String)"\u010de")) {
            s[len - 2] = 107;
        } else if (StemmerUtil.endsWith((char[])s, (int)len, (String)"zi") || StemmerUtil.endsWith((char[])s, (int)len, (String)"ze") || StemmerUtil.endsWith((char[])s, (int)len, (String)"\u017ei") || StemmerUtil.endsWith((char[])s, (int)len, (String)"\u017ee")) {
            s[len - 2] = 104;
        } else if (StemmerUtil.endsWith((char[])s, (int)len, (String)"\u010dte") || StemmerUtil.endsWith((char[])s, (int)len, (String)"\u010dti") || StemmerUtil.endsWith((char[])s, (int)len, (String)"\u010dt\u00ed")) {
            s[len - 3] = 99;
            s[len - 2] = 107;
        } else if (StemmerUtil.endsWith((char[])s, (int)len, (String)"\u0161te") || StemmerUtil.endsWith((char[])s, (int)len, (String)"\u0161ti") || StemmerUtil.endsWith((char[])s, (int)len, (String)"\u0161t\u00ed")) {
            s[len - 3] = 115;
            s[len - 2] = 107;
        }
        return len - 1;
    }
}

