/*
 * Decompiled with CFR 0.152.
 */
package org.wikimedia.search.extra.analysis.serbian;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LjubesicPandzicStemmer {
    private static final Transformations transformations = new Transformations(Collections.unmodifiableMap(LjubesicPandzicStemmer.initTransformations()));
    private static final Set<String> stopset = Collections.unmodifiableSet(LjubesicPandzicStemmer.initStopSet());
    private static final List<Pattern> wordPatterns = Collections.unmodifiableList(LjubesicPandzicStemmer.initWordPatterns());
    private static final Pattern vowelPattern = Pattern.compile("[aeiouR]");
    private static final Pattern syllabicRPattern = Pattern.compile("(^|[^aeiou])r($|[^aeiou])");
    private static final Locale srLocale = new Locale("sr");
    private static final Map<Character, String> cyr2LatMap = Collections.unmodifiableMap(LjubesicPandzicStemmer.initCyr2LatMap());

    public String stemWord(String word) {
        if (stopset.contains((word = this.convertCyrrilicToLatinString(word)).toLowerCase(srLocale))) {
            return word;
        }
        String stemmed = this.transform(word);
        for (Pattern pattern : wordPatterns) {
            String wordStem;
            Matcher matcher = pattern.matcher(stemmed);
            if (!matcher.matches() || !this.hasAVowel(wordStem = matcher.group(1)) || wordStem.length() <= 1) continue;
            return wordStem;
        }
        return stemmed;
    }

    private String transform(String word) {
        int wordLength = word.length();
        if (wordLength < transformations.minLen) {
            return word;
        }
        for (int i = Math.min(wordLength, transformations.maxLen); i >= transformations.minLen; --i) {
            String wordEnding = word.substring(wordLength - i);
            String replacement = (String)transformations.map.get(wordEnding);
            if (replacement == null) continue;
            return word.substring(0, wordLength - i) + replacement;
        }
        return word;
    }

    private String capitalizeSyllabicR(String word) {
        return syllabicRPattern.matcher(word).replaceAll("$1R$2");
    }

    private boolean hasAVowel(String word) {
        Matcher matcher = vowelPattern.matcher(this.capitalizeSyllabicR(word));
        return matcher.find();
    }

    private String convertCyrrilicToLatinString(String word) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < word.length(); ++i) {
            char ch = word.charAt(i);
            sb.append(this.convertCyrillicToLatinCharacter(ch));
        }
        return sb.toString();
    }

    private String convertCyrillicToLatinCharacter(char character) {
        if (cyr2LatMap.containsKey(Character.valueOf(character))) {
            return cyr2LatMap.get(Character.valueOf(character));
        }
        return Character.toString(character);
    }

    private static Set<String> initStopSet() {
        HashSet<String> stops = new HashSet<String>();
        stops.add("biti");
        stops.add("jesam");
        stops.add("budem");
        stops.add("sam");
        stops.add("jesi");
        stops.add("bude\u0161");
        stops.add("si");
        stops.add("jesmo");
        stops.add("budemo");
        stops.add("smo");
        stops.add("jeste");
        stops.add("budete");
        stops.add("ste");
        stops.add("jesu");
        stops.add("budu");
        stops.add("su");
        stops.add("bih");
        stops.add("bijah");
        stops.add("bjeh");
        stops.add("bija\u0161e");
        stops.add("bi");
        stops.add("bje");
        stops.add("bje\u0161e");
        stops.add("bijasmo");
        stops.add("bismo");
        stops.add("bjesmo");
        stops.add("bijaste");
        stops.add("biste");
        stops.add("bjeste");
        stops.add("bijahu");
        stops.add("bi\u0161e");
        stops.add("bjehu");
        stops.add("bio");
        stops.add("bili");
        stops.add("budimo");
        stops.add("budite");
        stops.add("bila");
        stops.add("bilo");
        stops.add("bile");
        stops.add("\u0107u");
        stops.add("\u0107e\u0161");
        stops.add("\u0107e");
        stops.add("\u0107emo");
        stops.add("\u0107ete");
        stops.add("\u017eelim");
        stops.add("\u017eeli\u0161");
        stops.add("\u017eeli");
        stops.add("\u017eelimo");
        stops.add("\u017eelite");
        stops.add("\u017eele");
        stops.add("moram");
        stops.add("mora\u0161");
        stops.add("mora");
        stops.add("moramo");
        stops.add("morate");
        stops.add("moraju");
        stops.add("trebam");
        stops.add("treba\u0161");
        stops.add("treba");
        stops.add("trebamo");
        stops.add("trebate");
        stops.add("trebaju");
        stops.add("mogu");
        stops.add("mo\u017ee\u0161");
        stops.add("mo\u017ee");
        stops.add("mo\u017eemo");
        stops.add("mo\u017eete");
        return stops;
    }

    private static Map<Character, String> initCyr2LatMap() {
        HashMap<Character, String> c2l = new HashMap<Character, String>();
        c2l.put(Character.valueOf('\u0430'), "a");
        c2l.put(Character.valueOf('\u0410'), "A");
        c2l.put(Character.valueOf('\u0431'), "b");
        c2l.put(Character.valueOf('\u0411'), "B");
        c2l.put(Character.valueOf('\u0432'), "v");
        c2l.put(Character.valueOf('\u0412'), "V");
        c2l.put(Character.valueOf('\u0433'), "g");
        c2l.put(Character.valueOf('\u0413'), "G");
        c2l.put(Character.valueOf('\u0434'), "d");
        c2l.put(Character.valueOf('\u0414'), "D");
        c2l.put(Character.valueOf('\u0452'), "\u0111");
        c2l.put(Character.valueOf('\u0402'), "\u0110");
        c2l.put(Character.valueOf('\u0435'), "e");
        c2l.put(Character.valueOf('\u0415'), "E");
        c2l.put(Character.valueOf('\u0436'), "\u017e");
        c2l.put(Character.valueOf('\u0416'), "\u017d");
        c2l.put(Character.valueOf('\u0437'), "z");
        c2l.put(Character.valueOf('\u0417'), "Z");
        c2l.put(Character.valueOf('\u0438'), "i");
        c2l.put(Character.valueOf('\u0418'), "I");
        c2l.put(Character.valueOf('\u0458'), "j");
        c2l.put(Character.valueOf('\u0408'), "J");
        c2l.put(Character.valueOf('\u043a'), "k");
        c2l.put(Character.valueOf('\u041a'), "K");
        c2l.put(Character.valueOf('\u043b'), "l");
        c2l.put(Character.valueOf('\u041b'), "L");
        c2l.put(Character.valueOf('\u0459'), "lj");
        c2l.put(Character.valueOf('\u0409'), "Lj");
        c2l.put(Character.valueOf('\u043c'), "m");
        c2l.put(Character.valueOf('\u041c'), "M");
        c2l.put(Character.valueOf('\u043d'), "n");
        c2l.put(Character.valueOf('\u041d'), "N");
        c2l.put(Character.valueOf('\u045a'), "nj");
        c2l.put(Character.valueOf('\u040a'), "Nj");
        c2l.put(Character.valueOf('\u043e'), "o");
        c2l.put(Character.valueOf('\u041e'), "O");
        c2l.put(Character.valueOf('\u043f'), "p");
        c2l.put(Character.valueOf('\u041f'), "P");
        c2l.put(Character.valueOf('\u0440'), "r");
        c2l.put(Character.valueOf('\u0420'), "R");
        c2l.put(Character.valueOf('\u0441'), "s");
        c2l.put(Character.valueOf('\u0421'), "S");
        c2l.put(Character.valueOf('\u0442'), "t");
        c2l.put(Character.valueOf('\u0422'), "T");
        c2l.put(Character.valueOf('\u045b'), "\u0107");
        c2l.put(Character.valueOf('\u040b'), "\u0106");
        c2l.put(Character.valueOf('\u0443'), "u");
        c2l.put(Character.valueOf('\u0423'), "U");
        c2l.put(Character.valueOf('\u0444'), "f");
        c2l.put(Character.valueOf('\u0424'), "F");
        c2l.put(Character.valueOf('\u0445'), "h");
        c2l.put(Character.valueOf('\u0425'), "H");
        c2l.put(Character.valueOf('\u0446'), "c");
        c2l.put(Character.valueOf('\u0426'), "C");
        c2l.put(Character.valueOf('\u0447'), "\u010d");
        c2l.put(Character.valueOf('\u0427'), "\u010c");
        c2l.put(Character.valueOf('\u045f'), "d\u017e");
        c2l.put(Character.valueOf('\u040f'), "D\u017e");
        c2l.put(Character.valueOf('\u0448'), "\u0161");
        c2l.put(Character.valueOf('\u0428'), "\u0160");
        return c2l;
    }

    private static Map<String, String> initTransformations() {
        HashMap<String, String> transforms = new HashMap<String, String>();
        transforms.put("lozi", "loga");
        transforms.put("lozima", "loga");
        transforms.put("pjesi", "pjeh");
        transforms.put("pjesima", "pjeh");
        transforms.put("vojci", "vojka");
        transforms.put("bojci", "bojka");
        transforms.put("jaci", "jak");
        transforms.put("jacima", "jak");
        transforms.put("\u010dajan", "\u010dajni");
        transforms.put("ijeran", "ijerni");
        transforms.put("laran", "larni");
        transforms.put("ijesan", "ijesni");
        transforms.put("ajac", "ajca");
        transforms.put("ajaca", "ajca");
        transforms.put("ljaca", "ljca");
        transforms.put("ljac", "ljca");
        transforms.put("ejac", "ejca");
        transforms.put("ejaca", "ejca");
        transforms.put("ojac", "ojca");
        transforms.put("ojaca", "ojca");
        transforms.put("ajaka", "ajka");
        transforms.put("ojaka", "ojka");
        transforms.put("\u0161aca", "\u0161ca");
        transforms.put("\u0161ac", "\u0161ca");
        transforms.put("inzima", "ing");
        transforms.put("inzi", "ing");
        transforms.put("tvenici", "tvenik");
        transforms.put("tetici", "tetika");
        transforms.put("teticima", "tetika");
        transforms.put("nstava", "nstva");
        transforms.put("nicima", "nik");
        transforms.put("ticima", "tik");
        transforms.put("zicima", "zik");
        transforms.put("snici", "snik");
        transforms.put("kuse", "kusi");
        transforms.put("kusan", "kusni");
        transforms.put("kustava", "kustva");
        transforms.put("du\u0161an", "du\u0161ni");
        transforms.put("antan", "antni");
        transforms.put("bilan", "bilni");
        transforms.put("tilan", "tilni");
        transforms.put("avilan", "avilni");
        transforms.put("silan", "silni");
        transforms.put("gilan", "gilni");
        transforms.put("rilan", "rilni");
        transforms.put("nilan", "nilni");
        transforms.put("alan", "alni");
        transforms.put("ozan", "ozni");
        transforms.put("rave", "ravi");
        transforms.put("stavan", "stavni");
        transforms.put("pravan", "pravni");
        transforms.put("tivan", "tivni");
        transforms.put("sivan", "sivni");
        transforms.put("atan", "atni");
        transforms.put("cenata", "centa");
        transforms.put("denata", "denta");
        transforms.put("genata", "genta");
        transforms.put("lenata", "lenta");
        transforms.put("menata", "menta");
        transforms.put("jenata", "jenta");
        transforms.put("venata", "venta");
        transforms.put("tetan", "tetni");
        transforms.put("pletan", "pletni");
        transforms.put("\u0161ave", "\u0161avi");
        transforms.put("manata", "manta");
        transforms.put("tanata", "tanta");
        transforms.put("lanata", "lanta");
        transforms.put("sanata", "santa");
        transforms.put("a\u010dak", "a\u010dka");
        transforms.put("a\u010daka", "a\u010dka");
        transforms.put("u\u0161ak", "u\u0161ka");
        transforms.put("atak", "atka");
        transforms.put("ataka", "atka");
        transforms.put("atci", "atka");
        transforms.put("atcima", "atka");
        transforms.put("etak", "etka");
        transforms.put("etaka", "etka");
        transforms.put("itak", "itka");
        transforms.put("itaka", "itka");
        transforms.put("itci", "itka");
        transforms.put("otak", "otka");
        transforms.put("otaka", "otka");
        transforms.put("utak", "utka");
        transforms.put("utaka", "utka");
        transforms.put("utci", "utka");
        transforms.put("utcima", "utka");
        transforms.put("eskan", "eskna");
        transforms.put("ti\u010dan", "ti\u010dni");
        transforms.put("ojsci", "ojska");
        transforms.put("esama", "esma");
        transforms.put("metara", "metra");
        transforms.put("centar", "centra");
        transforms.put("centara", "centra");
        transforms.put("istara", "istra");
        transforms.put("istar", "istra");
        transforms.put("o\u0161\u0107u", "osti");
        transforms.put("daba", "dba");
        transforms.put("\u010dcima", "\u010dka");
        transforms.put("\u010dci", "\u010dka");
        transforms.put("mac", "mca");
        transforms.put("maca", "mca");
        transforms.put("naca", "nca");
        transforms.put("nac", "nca");
        transforms.put("voljan", "voljni");
        transforms.put("anaka", "anki");
        transforms.put("vac", "vca");
        transforms.put("vaca", "vca");
        transforms.put("saca", "sca");
        transforms.put("sac", "sca");
        transforms.put("raca", "rca");
        transforms.put("rac", "rca");
        transforms.put("aoca", "alca");
        transforms.put("alaca", "alca");
        transforms.put("alac", "alca");
        transforms.put("elaca", "elca");
        transforms.put("elac", "elca");
        transforms.put("olaca", "olca");
        transforms.put("olac", "olca");
        transforms.put("olce", "olca");
        transforms.put("njac", "njca");
        transforms.put("njaca", "njca");
        transforms.put("ekata", "ekta");
        transforms.put("ekat", "ekta");
        transforms.put("izam", "izma");
        transforms.put("izama", "izma");
        transforms.put("jebe", "jebi");
        transforms.put("a\u0161an", "a\u0161ni");
        return transforms;
    }

    private static List<Pattern> initWordPatterns() {
        ArrayList<String> wordStart = new ArrayList<String>();
        ArrayList<String> wordEnd = new ArrayList<String>();
        wordStart.add(".+(s|\u0161)k");
        wordEnd.add("ijima|ijega|ijemu|ijem|ijim|ijih|ijoj|ijeg|iji|ije|ija|oga|ome|omu|ima|og|om|im|ih|oj|i|e|o|a|u");
        wordStart.add(".+(s|\u0161)tv");
        wordEnd.add("ima|om|o|a|u");
        wordStart.add(".+(t|m|p|r|g)anij");
        wordEnd.add("ama|ima|om|a|u|e|i|");
        wordStart.add(".+an");
        wordEnd.add("inom|ina|inu|ine|ima|in|om|u|i|a|e|");
        wordStart.add(".+in");
        wordEnd.add("ima|ama|om|a|e|i|u|o|");
        wordStart.add(".+on");
        wordEnd.add("ovima|ova|ove|ovi|ima|om|a|e|i|u|");
        wordStart.add(".+n");
        wordEnd.add("ijima|ijega|ijemu|ijeg|ijem|ijim|ijih|ijoj|iji|ije|ija|iju|ima|ome|omu|oga|oj|om|ih|im|og|o|e|a|u|i|");
        wordStart.add(".+(a|e|u)\u0107");
        wordEnd.add("oga|ome|omu|ega|emu|ima|oj|ih|om|eg|em|og|uh|im|e|a");
        wordStart.add(".+ugov");
        wordEnd.add("ima|i|e|a");
        wordStart.add(".+ug");
        wordEnd.add("ama|om|a|e|i|u|o");
        wordStart.add(".+log");
        wordEnd.add("ama|om|a|u|e|");
        wordStart.add(".+[^eo]g");
        wordEnd.add("ovima|ama|ovi|ove|ova|om|a|e|i|u|o|");
        wordStart.add(".+(rrar|ott|ss|ll)i");
        wordEnd.add("jem|ja|ju|o|");
        wordStart.add(".+uj");
        wordEnd.add("u\u0107i|emo|ete|mo|em|e\u0161|e|u|");
        wordStart.add(".+(c|\u010d|\u0107|\u0111|l|r)aj");
        wordEnd.add("evima|evi|eva|eve|ama|ima|em|a|e|i|u|");
        wordStart.add(".+(b|c|d|l|n|m|\u017e|g|f|p|r|s|t|z)ij");
        wordEnd.add("ima|ama|om|a|e|i|u|o|");
        wordStart.add(".+[^z]nal");
        wordEnd.add("ima|ama|om|a|e|i|u|o|");
        wordStart.add(".+ijal");
        wordEnd.add("ima|ama|om|a|e|i|u|o|");
        wordStart.add(".+ozil");
        wordEnd.add("ima|om|a|e|u|i|");
        wordStart.add(".+olov");
        wordEnd.add("ima|i|a|e");
        wordStart.add(".+ol");
        wordEnd.add("ima|om|a|u|e|i|");
        wordStart.add(".+lem");
        wordEnd.add("ama|ima|om|a|e|i|u|o|");
        wordStart.add(".+ram");
        wordEnd.add("ama|om|a|e|i|u|o");
        wordStart.add(".+(a|d|e|o)r");
        wordEnd.add("ama|ima|om|u|a|e|i|");
        wordStart.add(".+(e|i)s");
        wordEnd.add("ima|om|e|a|u");
        wordStart.add(".+(t|n|j|k|j|t|b|g|v)a\u0161");
        wordEnd.add("ama|ima|om|em|a|u|i|e|");
        wordStart.add(".+(e|i)\u0161");
        wordEnd.add("ima|ama|om|em|i|e|a|u|");
        wordStart.add(".+ikat");
        wordEnd.add("ima|om|a|e|i|u|o|");
        wordStart.add(".+lat");
        wordEnd.add("ima|om|a|e|i|u|o|");
        wordStart.add(".+et");
        wordEnd.add("ama|ima|om|a|e|i|u|o|");
        wordStart.add(".+(e|i|k|o)st");
        wordEnd.add("ima|ama|om|a|e|i|u|o|");
        wordStart.add(".+i\u0161t");
        wordEnd.add("ima|em|a|e|u");
        wordStart.add(".+ova");
        wordEnd.add("smo|ste|hu|ti|\u0161e|li|la|le|lo|t|h|o");
        wordStart.add(".+(a|e|i)v");
        wordEnd.add("ijemu|ijima|ijega|ijeg|ijem|ijim|ijih|ijoj|oga|ome|omu|ima|ama|iji|ije|ija|iju|im|ih|oj|om|og|i|a|u|e|o|");
        wordStart.add(".+[^dkml]ov");
        wordEnd.add("ijemu|ijima|ijega|ijeg|ijem|ijim|ijih|ijoj|oga|ome|omu|ima|iji|ije|ija|iju|im|ih|oj|om|og|i|a|u|e|o|");
        wordStart.add(".+(m|l)ov");
        wordEnd.add("ima|om|a|u|e|i|");
        wordStart.add(".+el");
        wordEnd.add("ijemu|ijima|ijega|ijeg|ijem|ijim|ijih|ijoj|oga|ome|omu|ima|iji|ije|ija|iju|im|ih|oj|om|og|i|a|u|e|o|");
        wordStart.add(".+(a|e|\u0161)nj");
        wordEnd.add("ijemu|ijima|ijega|ijeg|ijem|ijim|ijih|ijoj|oga|ome|omu|ima|iji|ije|ija|iju|ega|emu|eg|em|im|ih|oj|om|og|a|e|i|o|u");
        wordStart.add(".+\u010din");
        wordEnd.add("ama|ome|omu|oga|ima|og|om|im|ih|oj|a|u|i|o|e|");
        wordStart.add(".+ro\u0161i");
        wordEnd.add("v\u0161i|smo|ste|\u0161e|mo|te|ti|li|la|lo|le|m|\u0161|t|h|o");
        wordStart.add(".+o\u0161");
        wordEnd.add("ijemu|ijima|ijega|ijeg|ijem|ijim|ijih|ijoj|oga|ome|omu|ima|iji|ije|ija|iju|im|ih|oj|om|og|i|a|u|e|");
        wordStart.add(".+(e|o)vit");
        wordEnd.add("ijima|ijega|ijemu|ijem|ijim|ijih|ijoj|ijeg|iji|ije|ija|oga|ome|omu|ima|og|om|im|ih|oj|i|e|o|a|u|");
        wordStart.add(".+ast");
        wordEnd.add("ijima|ijega|ijemu|ijem|ijim|ijih|ijoj|ijeg|iji|ije|ija|oga|ome|omu|ima|og|om|im|ih|oj|i|e|o|a|u|");
        wordStart.add(".+k");
        wordEnd.add("ijemu|ijima|ijega|ijeg|ijem|ijim|ijih|ijoj|oga|ome|omu|ima|iji|ije|ija|iju|im|ih|oj|om|og|i|a|u|e|o|");
        wordStart.add(".+(e|a|i|u)va");
        wordEnd.add("ju\u0107i|smo|ste|jmo|jte|ju|la|le|li|lo|mo|na|ne|ni|no|te|ti|\u0161e|hu|h|j|m|n|o|t|v|\u0161|");
        wordStart.add(".+ir");
        wordEnd.add("ujemo|ujete|uju\u0107i|aju\u0107i|ivat|ujem|uje\u0161|ujmo|ujte|av\u0161i|asmo|aste|ati|amo|ate|aju|a\u0161e|ahu|ala|alo|ali|ale|uje|uju|uj|al|an|am|a\u0161|at|ah|ao");
        wordStart.add(".+a\u010d");
        wordEnd.add("ismo|iste|iti|imo|ite|i\u0161e|e\u0107i|ila|ilo|ili|ile|ena|eno|eni|ene|io|im|i\u0161|it|ih|en|i|e");
        wordStart.add(".+a\u010da");
        wordEnd.add("v\u0161i|smo|ste|smo|ste|hu|ti|mo|te|\u0161e|la|lo|li|le|ju|na|no|ni|ne|o|m|\u0161|t|h|n");
        wordStart.add(".+n");
        wordEnd.add("uv\u0161i|usmo|uste|u\u0107i|imo|ite|emo|ete|ula|ulo|ule|uli|uto|uti|uta|em|e\u0161|uo|ut|e|u|i");
        wordStart.add(".+ni");
        wordEnd.add("v\u0161i|smo|ste|ti|mo|te|mo|te|la|lo|le|li|m|\u0161|o");
        wordStart.add(".+((a|r|i|p|e|u)st|[^o]g|ik|uc|oj|aj|lj|ak|ck|\u010dk|\u0161k|uk|nj|im|ar|at|et|\u0161t|it|ot|ut|zn|zv)a");
        wordEnd.add("ju\u0107i|v\u0161i|smo|ste|jmo|jte|jem|mo|te|je|ju|ti|\u0161e|hu|la|li|le|lo|na|no|ni|ne|t|h|o|j|n|m|\u0161");
        wordStart.add(".+ur");
        wordEnd.add("aju\u0107i|asmo|aste|ajmo|ajte|amo|ate|aju|ati|a\u0161e|ahu|ala|ali|ale|alo|ana|ano|ani|ane|al|at|ah|ao|aj|an|am|a\u0161");
        wordStart.add(".+(a|i|o)staj");
        wordEnd.add("asmo|aste|ahu|ati|emo|ete|a\u0161e|ali|u\u0107i|ala|alo|ale|mo|ao|em|e\u0161|at|ah|te|e|u|");
        wordStart.add(".+(b|c|\u010d|\u0107|d|e|f|g|j|k|n|r|t|u|v)a");
        wordEnd.add("lama|lima|lom|lu|li|la|le|lo|l");
        wordStart.add(".+(t|\u010d|j|\u017e|\u0161)aj");
        wordEnd.add("evima|evi|eva|eve|ama|ima|em|a|e|i|u|");
        wordStart.add(".+([^o]m|i\u010d|n\u010d|u\u010d|b|c|\u0107|d|\u0111|h|j|k|l|n|p|r|s|\u0161|v|z|\u017e)a");
        wordEnd.add("ju\u0107i|v\u0161i|smo|ste|jmo|jte|mo|te|ju|ti|\u0161e|hu|la|li|le|lo|na|no|ni|ne|t|h|o|j|n|m|\u0161");
        wordStart.add(".+(a|i|o)sta");
        wordEnd.add("dosmo|doste|do\u0161e|nemo|demo|nete|dete|nimo|nite|nila|v\u0161i|nem|dem|ne\u0161|de\u0161|doh|de|ti|ne|nu|du|la|li|lo|le|t|o");
        wordStart.add(".+ta");
        wordEnd.add("smo|ste|jmo|jte|v\u0161i|ti|mo|te|ju|\u0161e|la|lo|le|li|na|no|ni|ne|n|j|o|m|\u0161|t|h");
        wordStart.add(".+inj");
        wordEnd.add("asmo|aste|ati|emo|ete|ali|ala|alo|ale|a\u0161e|ahu|em|e\u0161|at|ah|ao");
        wordStart.add(".+as");
        wordEnd.add("temo|tete|timo|tite|tu\u0107i|tem|te\u0161|tao|te|li|ti|la|lo|le");
        wordStart.add(".+(elj|ulj|tit|ac|i\u010d|od|oj|et|av|ov)i");
        wordEnd.add("v\u0161i|e\u0107i|smo|ste|\u0161e|mo|te|ti|li|la|lo|le|m|\u0161|t|h|o");
        wordStart.add(".+(tit|jeb|ar|ed|u\u0161|i\u010d)i");
        wordEnd.add("jemo|jete|jem|je\u0161|smo|ste|jmo|jte|v\u0161i|mo|\u0161e|te|ti|ju|je|la|lo|li|le|t|m|\u0161|h|j|o");
        wordStart.add(".+(b|\u010d|d|l|m|p|r|s|\u0161|\u017e)i");
        wordEnd.add("jemo|jete|jem|je\u0161|smo|ste|jmo|jte|v\u0161i|mo|lu|\u0161e|te|ti|ju|je|la|lo|li|le|t|m|\u0161|h|j|o");
        wordStart.add(".+lu\u010d");
        wordEnd.add("ujete|uju\u0107i|ujemo|ujem|uje\u0161|ismo|iste|ujmo|ujte|uje|uju|i\u0161e|iti|imo|ite|ila|ilo|ili|ile|ena|eno|eni|ene|uj|io|en|im|i\u0161|it|ih|e|i");
        wordStart.add(".+jeti");
        wordEnd.add("smo|ste|\u0161e|mo|te|ti|li|la|lo|le|m|\u0161|t|h|o");
        wordStart.add(".+e");
        wordEnd.add("lama|lima|lom|lu|li|la|le|lo|l");
        wordStart.add(".+i");
        wordEnd.add("lama|lima|lom|lu|li|la|le|lo|l");
        wordStart.add(".+at");
        wordEnd.add("ijega|ijemu|ijima|ijeg|ijem|ijih|ijim|ima|oga|ome|omu|iji|ije|ija|iju|oj|og|om|im|ih|a|u|i|e|o|");
        wordStart.add(".+et");
        wordEnd.add("av\u0161i|u\u0107i|emo|imo|em|e\u0161|e|u|i");
        wordStart.add(".+");
        wordEnd.add("aju\u0107i|alima|alom|av\u0161i|asmo|aste|ajmo|ajte|iv\u0161i|amo|ate|aju|ati|a\u0161e|ahu|ali|ala|ale|alo|ana|ano|ani|ane|am|a\u0161|at|ah|ao|aj|an");
        wordStart.add(".+");
        wordEnd.add("anje|enje|anja|enja|enom|enoj|enog|enim|enih|anom|anoj|anog|anim|anih|eno|ovi|ova|oga|ima|ove|enu|anu|ena|ama");
        wordStart.add(".+");
        wordEnd.add("nijega|nijemu|nijima|nijeg|nijem|nijim|nijih|nima|niji|nije|nija|niju|noj|nom|nog|nim|nih|an|na|nu|ni|ne|no");
        wordStart.add(".+");
        wordEnd.add("om|og|im|ih|em|oj|an|u|o|i|e|a");
        assert (wordStart.size() == wordEnd.size());
        ArrayList<Pattern> wordPats = new ArrayList<Pattern>(wordStart.size());
        for (int i = 0; i < wordStart.size(); ++i) {
            String pattern = "^(" + (String)wordStart.get(i) + ")(" + (String)wordEnd.get(i) + ")$";
            wordPats.add(Pattern.compile(pattern));
        }
        return wordPats;
    }

    static class Transformations {
        private final Map<String, String> map;
        private final int minLen;
        private final int maxLen;

        Transformations(Map<String, String> transformations) {
            this.map = transformations;
            int min = Integer.MAX_VALUE;
            int max = 0;
            for (String key : this.map.keySet()) {
                int len = key.length();
                if (len < min) {
                    min = len;
                }
                if (len <= max) continue;
                max = len;
            }
            this.minLen = min;
            this.maxLen = max;
        }
    }
}

