/*
 * Decompiled with CFR 0.152.
 */
package org.wikimedia.search.extra.analysis.serbian;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.elasticsearch.index.analysis.PreConfiguredTokenFilter;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.indices.analysis.AnalysisModule;
import org.elasticsearch.plugins.AnalysisPlugin;
import org.elasticsearch.plugins.Plugin;
import org.wikimedia.search.extra.analysis.serbian.SerbianStemmerTokenFilter;

public class ExtraAnalysisSerbianPlugin
extends Plugin
implements AnalysisPlugin {
    public List<PreConfiguredTokenFilter> getPreConfiguredTokenFilters() {
        return Collections.singletonList(PreConfiguredTokenFilter.singleton((String)"serbian_stemmer", (boolean)true, SerbianStemmerTokenFilter::new));
    }

    public Map<String, AnalysisModule.AnalysisProvider<TokenFilterFactory>> getTokenFilters() {
        return Collections.singletonMap("serbian_stemmer", (isettings, env, name, settings) -> new TokenFilterFactory(){

            public String name() {
                return name;
            }

            public TokenStream create(TokenStream tokenStream) {
                return new SerbianStemmerTokenFilter(tokenStream);
            }
        });
    }
}

