/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.wikibaseapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.wikidata.wdtk.wikibaseapi.ApiConnection;
import org.wikidata.wdtk.wikibaseapi.apierrors.AssertUserFailedException;
import org.wikidata.wdtk.wikibaseapi.apierrors.MediaWikiApiErrorException;
import se.akerfeldt.okhttp.signpost.OkHttpOAuthConsumer;
import se.akerfeldt.okhttp.signpost.SigningInterceptor;

public class OAuthApiConnection
extends ApiConnection {
    private String consumerKey;
    private String consumerSecret;
    private String accessToken;
    private String accessSecret;

    public OAuthApiConnection(String apiBaseUrl, String consumerKey, String consumerSecret, String accessToken, String accessSecret) {
        super(apiBaseUrl, null);
        this.consumerKey = consumerKey;
        this.consumerSecret = consumerSecret;
        this.accessToken = accessToken;
        this.accessSecret = accessSecret;
        this.loggedIn = true;
    }

    @JsonCreator
    protected OAuthApiConnection(@JsonProperty(value="baseUrl") String apiBaseUrl, @JsonProperty(value="consumerKey") String consumerKey, @JsonProperty(value="consumerSecret") String consumerSecret, @JsonProperty(value="accessToken") String accessToken, @JsonProperty(value="accessSecret") String accessSecret, @JsonProperty(value="username") String username, @JsonProperty(value="loggedIn") boolean loggedIn, @JsonProperty(value="tokens") Map<String, String> tokens, @JsonProperty(value="connectTimeout") int connectTimeout, @JsonProperty(value="readTimeout") int readTimeout) {
        super(apiBaseUrl, tokens);
        this.consumerKey = consumerKey;
        this.consumerSecret = consumerSecret;
        this.accessToken = accessToken;
        this.accessSecret = accessSecret;
        this.username = username;
        this.loggedIn = loggedIn;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    @Override
    protected OkHttpClient.Builder getClientBuilder() {
        OkHttpOAuthConsumer consumer = new OkHttpOAuthConsumer(this.consumerKey, this.consumerSecret);
        consumer.setTokenWithSecret(this.accessToken, this.accessSecret);
        return new OkHttpClient.Builder().addInterceptor((Interceptor)new SigningInterceptor(consumer));
    }

    @Override
    public void logout() {
        this.consumerKey = null;
        this.consumerSecret = null;
        this.accessToken = null;
        this.accessSecret = null;
        this.username = "";
        this.loggedIn = false;
    }

    @Override
    public void checkCredentials() throws IOException, MediaWikiApiErrorException {
        super.checkCredentials();
    }

    @Override
    @JsonProperty(value="username")
    public String getCurrentUser() {
        if (!this.loggedIn) {
            return "";
        }
        if (this.username != null && !this.username.equals("")) {
            return this.username;
        }
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("action", "query");
            params.put("meta", "userinfo");
            JsonNode root = this.sendJsonRequest("POST", params);
            JsonNode nameNode = root.path("query").path("userinfo").path("name");
            if (nameNode.isMissingNode()) {
                throw new AssertUserFailedException("The path \"query/userinfo/name\" doesn't exist in the json response");
            }
            this.username = nameNode.textValue();
        }
        catch (IOException | MediaWikiApiErrorException e) {
            logger.warn("An error occurred when retrieving the username with OAuth credentials, the username is set to \"\" automatically: " + e.getMessage());
            this.username = "";
        }
        return this.username;
    }

    @JsonProperty(value="consumerKey")
    public String getConsumerKey() {
        return this.consumerKey;
    }

    @JsonProperty(value="consumerSecret")
    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    @JsonProperty(value="accessToken")
    public String getAccessToken() {
        return this.accessToken;
    }

    @JsonProperty(value="accessSecret")
    public String getAccessSecret() {
        return this.accessSecret;
    }
}

