/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.wikibaseapi;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.wdtk.datamodel.helpers.JsonSerializer;
import org.wikidata.wdtk.datamodel.interfaces.ItemDocument;
import org.wikidata.wdtk.datamodel.interfaces.ItemIdValue;
import org.wikidata.wdtk.datamodel.interfaces.MonolingualTextValue;
import org.wikidata.wdtk.datamodel.interfaces.PropertyDocument;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.datamodel.interfaces.Statement;
import org.wikidata.wdtk.datamodel.interfaces.StatementDocument;
import org.wikidata.wdtk.datamodel.interfaces.TermedStatementDocument;
import org.wikidata.wdtk.wikibaseapi.ApiConnection;
import org.wikidata.wdtk.wikibaseapi.GuidGenerator;
import org.wikidata.wdtk.wikibaseapi.RandomGuidGenerator;
import org.wikidata.wdtk.wikibaseapi.StatementUpdate;
import org.wikidata.wdtk.wikibaseapi.TermStatementUpdate;
import org.wikidata.wdtk.wikibaseapi.WbEditingAction;
import org.wikidata.wdtk.wikibaseapi.WikibaseDataFetcher;
import org.wikidata.wdtk.wikibaseapi.apierrors.MediaWikiApiErrorException;

public class WikibaseDataEditor {
    static final Logger logger = LoggerFactory.getLogger(WikibaseDataEditor.class);
    final WbEditingAction wbEditingAction;
    final WikibaseDataFetcher wikibaseDataFetcher;
    final GuidGenerator guidGenerator;
    final String siteIri;
    boolean editAsBot = false;

    public WikibaseDataEditor(ApiConnection connection, String siteUri) {
        this.wbEditingAction = new WbEditingAction(connection, siteUri);
        this.wikibaseDataFetcher = new WikibaseDataFetcher(connection, siteUri);
        this.siteIri = siteUri;
        this.guidGenerator = new RandomGuidGenerator();
    }

    public WikibaseDataEditor(ApiConnection connection, String siteUri, GuidGenerator generator) {
        this.wbEditingAction = new WbEditingAction(connection, siteUri);
        this.wikibaseDataFetcher = new WikibaseDataFetcher(connection, siteUri);
        this.siteIri = siteUri;
        this.guidGenerator = generator;
    }

    public boolean editAsBot() {
        return this.editAsBot;
    }

    public void setEditAsBot(boolean editAsBot) {
        this.editAsBot = editAsBot;
    }

    public int getMaxLag() {
        return this.wbEditingAction.getMaxLag();
    }

    public void setMaxLag(int maxLag) {
        this.wbEditingAction.setMaxLag(maxLag);
    }

    public int getAverageTimePerEdit() {
        return this.wbEditingAction.getAverageTimePerEdit();
    }

    public void setAverageTimePerEdit(int milliseconds) {
        this.wbEditingAction.setAverageTimePerEdit(milliseconds);
    }

    public int getRemainingEdits() {
        return this.wbEditingAction.getRemainingEdits();
    }

    public void setRemainingEdits(int remainingEdits) {
        this.wbEditingAction.setRemainingEdits(remainingEdits);
    }

    public void disableEditing() {
        this.wbEditingAction.setRemainingEdits(0);
    }

    public ItemDocument createItemDocument(ItemDocument itemDocument, String summary) throws IOException, MediaWikiApiErrorException {
        String data = JsonSerializer.getJsonString((ItemDocument)itemDocument);
        return (ItemDocument)this.wbEditingAction.wbEditEntity(null, null, null, "item", data, false, this.editAsBot, 0L, summary);
    }

    public PropertyDocument createPropertyDocument(PropertyDocument propertyDocument, String summary) throws IOException, MediaWikiApiErrorException {
        String data = JsonSerializer.getJsonString((PropertyDocument)propertyDocument);
        return (PropertyDocument)this.wbEditingAction.wbEditEntity(null, null, null, "property", data, false, this.editAsBot, 0L, summary);
    }

    public ItemDocument editItemDocument(ItemDocument itemDocument, boolean clear, String summary) throws IOException, MediaWikiApiErrorException {
        String data = JsonSerializer.getJsonString((ItemDocument)itemDocument);
        return (ItemDocument)this.wbEditingAction.wbEditEntity(itemDocument.getEntityId().getId(), null, null, null, data, clear, this.editAsBot, itemDocument.getRevisionId(), summary);
    }

    public PropertyDocument editPropertyDocument(PropertyDocument propertyDocument, boolean clear, String summary) throws IOException, MediaWikiApiErrorException {
        String data = JsonSerializer.getJsonString((PropertyDocument)propertyDocument);
        return (PropertyDocument)this.wbEditingAction.wbEditEntity(propertyDocument.getEntityId().getId(), null, null, null, data, clear, this.editAsBot, propertyDocument.getRevisionId(), summary);
    }

    public ItemDocument updateStatements(ItemIdValue itemIdValue, List<Statement> addStatements, List<Statement> deleteStatements, String summary) throws MediaWikiApiErrorException, IOException {
        ItemDocument currentDocument = (ItemDocument)this.wikibaseDataFetcher.getEntityDocument(itemIdValue.getId());
        return this.updateStatements(currentDocument, addStatements, deleteStatements, summary);
    }

    public ItemDocument updateTermsStatements(ItemIdValue itemIdValue, List<MonolingualTextValue> addLabels, List<MonolingualTextValue> addDescriptions, List<MonolingualTextValue> addAliases, List<MonolingualTextValue> deleteAliases, List<Statement> addStatements, List<Statement> deleteStatements, String summary) throws MediaWikiApiErrorException, IOException {
        ItemDocument currentDocument = (ItemDocument)this.wikibaseDataFetcher.getEntityDocument(itemIdValue.getId());
        return this.updateTermsStatements(currentDocument, addLabels, addDescriptions, addAliases, deleteAliases, addStatements, deleteStatements, summary);
    }

    public PropertyDocument updateStatements(PropertyIdValue propertyIdValue, List<Statement> addStatements, List<Statement> deleteStatements, String summary) throws MediaWikiApiErrorException, IOException {
        PropertyDocument currentDocument = (PropertyDocument)this.wikibaseDataFetcher.getEntityDocument(propertyIdValue.getId());
        return this.updateStatements(currentDocument, addStatements, deleteStatements, summary);
    }

    public <T extends StatementDocument> T updateStatements(T currentDocument, List<Statement> addStatements, List<Statement> deleteStatements, String summary) throws MediaWikiApiErrorException, IOException {
        StatementUpdate statementUpdate = new StatementUpdate(currentDocument, addStatements, deleteStatements);
        statementUpdate.setGuidGenerator(this.guidGenerator);
        if (statementUpdate.isEmptyEdit()) {
            return currentDocument;
        }
        return (T)((StatementDocument)this.wbEditingAction.wbEditEntity(currentDocument.getEntityId().getId(), null, null, null, statementUpdate.getJsonUpdateString(), false, this.editAsBot, currentDocument.getRevisionId(), summary));
    }

    public <T extends TermedStatementDocument> T updateTermsStatements(T currentDocument, List<MonolingualTextValue> addLabels, List<MonolingualTextValue> addDescriptions, List<MonolingualTextValue> addAliases, List<MonolingualTextValue> deleteAliases, List<Statement> addStatements, List<Statement> deleteStatements, String summary) throws MediaWikiApiErrorException, IOException {
        TermStatementUpdate termStatementUpdate = new TermStatementUpdate(currentDocument, addStatements, deleteStatements, addLabels, addDescriptions, addAliases, deleteAliases);
        termStatementUpdate.setGuidGenerator(this.guidGenerator);
        return (T)termStatementUpdate.performEdit(this.wbEditingAction, this.editAsBot, summary);
    }

    public <T extends StatementDocument> void nullEdit(ItemIdValue itemId) throws IOException, MediaWikiApiErrorException {
        ItemDocument currentDocument = (ItemDocument)this.wikibaseDataFetcher.getEntityDocument(itemId.getId());
        this.nullEdit(currentDocument);
    }

    public <T extends StatementDocument> void nullEdit(PropertyIdValue propertyId) throws IOException, MediaWikiApiErrorException {
        PropertyDocument currentDocument = (PropertyDocument)this.wikibaseDataFetcher.getEntityDocument(propertyId.getId());
        this.nullEdit(currentDocument);
    }

    public <T extends StatementDocument> T nullEdit(T currentDocument) throws IOException, MediaWikiApiErrorException {
        StatementUpdate statementUpdate = new StatementUpdate(currentDocument, Collections.emptyList(), Collections.emptyList());
        statementUpdate.setGuidGenerator(this.guidGenerator);
        return (T)((StatementDocument)this.wbEditingAction.wbEditEntity(currentDocument.getEntityId().getId(), null, null, null, statementUpdate.getJsonUpdateString(), false, this.editAsBot, currentDocument.getRevisionId(), null));
    }
}

