/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.wikibaseapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.wikidata.wdtk.wikibaseapi.ApiConnection;
import org.wikidata.wdtk.wikibaseapi.LoginFailedException;
import org.wikidata.wdtk.wikibaseapi.apierrors.MediaWikiApiErrorException;

public class BasicApiConnection
extends ApiConnection {
    public BasicApiConnection(String apiBaseUrl) {
        super(apiBaseUrl);
    }

    @JsonCreator
    private BasicApiConnection(@JsonProperty(value="baseUrl") String apiBaseUrl, @JsonProperty(value="cookies") Map<String, String> cookies, @JsonProperty(value="username") String username, @JsonProperty(value="loggedIn") boolean loggedIn) {
        super(apiBaseUrl, cookies, username, loggedIn);
    }

    public static BasicApiConnection getWikidataApiConnection() {
        return new BasicApiConnection("https://www.wikidata.org/w/api.php");
    }

    public static BasicApiConnection getTestWikidataApiConnection() {
        return new BasicApiConnection("https://test.wikidata.org/w/api.php");
    }

    @Override
    public void login(String username, String password) throws LoginFailedException {
        super.login(username, password);
    }

    @Override
    void confirmLogin(String token, String username, String password) throws IOException, LoginFailedException, MediaWikiApiErrorException {
        super.confirmLogin(token, username, password);
    }

    @Override
    @JsonProperty(value="loggedIn")
    public boolean isLoggedIn() {
        return super.isLoggedIn();
    }

    @Override
    @JsonProperty(value="username")
    public String getCurrentUser() {
        return super.getCurrentUser();
    }

    @JsonProperty(value="cookies")
    public Map<String, String> getCookies() {
        return Collections.unmodifiableMap(this.cookies);
    }

    @Override
    void fillCookies(Map<String, List<String>> headerFields) {
        super.fillCookies(headerFields);
    }

    @Override
    String getCookieString() {
        return super.getCookieString();
    }

    @Override
    String getLoginErrorMessage(String loginResult) {
        return super.getLoginErrorMessage(loginResult);
    }

    @Override
    void setupConnection(String requestMethod, String queryString, HttpURLConnection connection) throws IOException {
        super.setupConnection(requestMethod, queryString, connection);
        connection.setRequestProperty("Cookie", this.getCookieString());
    }
}

