/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.json.jackson.datavalues;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.wikidata.wdtk.datamodel.json.jackson.datavalues.JacksonValue;
import org.wikidata.wdtk.datamodel.json.jackson.datavalues.JacksonValueGlobeCoordinates;
import org.wikidata.wdtk.datamodel.json.jackson.datavalues.JacksonValueItemId;
import org.wikidata.wdtk.datamodel.json.jackson.datavalues.JacksonValueMonolingualText;
import org.wikidata.wdtk.datamodel.json.jackson.datavalues.JacksonValuePropertyId;
import org.wikidata.wdtk.datamodel.json.jackson.datavalues.JacksonValueQuantity;
import org.wikidata.wdtk.datamodel.json.jackson.datavalues.JacksonValueString;
import org.wikidata.wdtk.datamodel.json.jackson.datavalues.JacksonValueTime;

public class JacksonValueDeserializer
extends StdDeserializer<JacksonValue> {
    private static final long serialVersionUID = -2851517075035995962L;

    public JacksonValueDeserializer() {
        super(JacksonValue.class);
    }

    public JacksonValue deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectMapper mapper = (ObjectMapper)jsonParser.getCodec();
        JsonNode root = (JsonNode)mapper.readTree(jsonParser);
        Class<? extends JacksonValue> valueClass = this.getValueClass(root);
        return (JacksonValue)mapper.treeToValue((TreeNode)root, valueClass);
    }

    private Class<? extends JacksonValue> getValueClass(JsonNode jsonNode) throws JsonMappingException {
        String jsonType;
        switch (jsonType = jsonNode.get("type").asText()) {
            case "wikibase-entityid": {
                JsonNode valueNode = jsonNode.get("value");
                if (valueNode != null) {
                    String entityType;
                    switch (entityType = valueNode.get("entity-type").asText()) {
                        case "item": {
                            return JacksonValueItemId.class;
                        }
                        case "property": {
                            return JacksonValuePropertyId.class;
                        }
                    }
                    throw new JsonMappingException("Entities of type \"" + entityType + "\" are not supported as property values yet.");
                }
            }
            case "string": {
                return JacksonValueString.class;
            }
            case "time": {
                return JacksonValueTime.class;
            }
            case "globecoordinate": {
                return JacksonValueGlobeCoordinates.class;
            }
            case "quantity": {
                return JacksonValueQuantity.class;
            }
            case "monolingualtext": {
                return JacksonValueMonolingualText.class;
            }
        }
        throw new JsonMappingException("Property values of type \"" + jsonType + "\" are not supported yet.");
    }
}

