/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.json.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.compress.utils.Charsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.wdtk.datamodel.helpers.DatamodelConverter;
import org.wikidata.wdtk.datamodel.interfaces.EntityDocument;
import org.wikidata.wdtk.datamodel.interfaces.EntityDocumentDumpProcessor;
import org.wikidata.wdtk.datamodel.interfaces.ItemDocument;
import org.wikidata.wdtk.datamodel.interfaces.PropertyDocument;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonItemDocument;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonObjectFactory;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonPropertyDocument;

public class JsonSerializer
implements EntityDocumentDumpProcessor {
    static final Logger logger = LoggerFactory.getLogger(JsonSerializer.class);
    static final byte[] JSON_START_LIST = "[\n".getBytes(Charsets.UTF_8);
    static final byte[] JSON_SEP = ",\n".getBytes(Charsets.UTF_8);
    static final byte[] JSON_END_LIST = "\n]".getBytes(Charsets.UTF_8);
    protected final OutputStream outputStream;
    protected final DatamodelConverter datamodelConverter;
    protected final ObjectMapper mapper;
    protected int entityDocumentCount;

    public JsonSerializer(OutputStream outputStream) {
        this.outputStream = outputStream;
        this.mapper = new ObjectMapper();
        this.mapper.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        this.datamodelConverter = new DatamodelConverter(new JacksonObjectFactory());
    }

    @Override
    public void open() {
        this.entityDocumentCount = 0;
        try {
            this.outputStream.write(JSON_START_LIST);
        }
        catch (IOException e) {
            this.reportException(e);
        }
    }

    @Override
    public void processItemDocument(ItemDocument itemDocument) {
        if (!(itemDocument instanceof JacksonItemDocument)) {
            itemDocument = this.datamodelConverter.copy(itemDocument);
        }
        this.serializeEntityDocument(itemDocument);
    }

    @Override
    public void processPropertyDocument(PropertyDocument propertyDocument) {
        if (!(propertyDocument instanceof JacksonPropertyDocument)) {
            propertyDocument = this.datamodelConverter.copy(propertyDocument);
        }
        this.serializeEntityDocument(propertyDocument);
    }

    @Override
    public void close() {
        try {
            this.outputStream.write(JSON_END_LIST);
            this.outputStream.close();
        }
        catch (IOException e) {
            this.reportException(e);
        }
    }

    public int getEntityDocumentCount() {
        return this.entityDocumentCount;
    }

    protected void reportException(Exception e) {
        logger.error("Failed to write JSON export: " + e.toString());
        throw new RuntimeException(e.toString(), e);
    }

    protected void serializeEntityDocument(EntityDocument entityDocument) {
        try {
            if (this.entityDocumentCount > 0) {
                this.outputStream.write(JSON_SEP);
            }
            this.mapper.writeValue(this.outputStream, (Object)entityDocument);
        }
        catch (IOException e) {
            this.reportException(e);
        }
        ++this.entityDocumentCount;
    }
}

