/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.json.jackson;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.MonolingualTextValue;
import org.wikidata.wdtk.datamodel.interfaces.Statement;
import org.wikidata.wdtk.datamodel.interfaces.StatementDocument;
import org.wikidata.wdtk.datamodel.interfaces.StatementGroup;
import org.wikidata.wdtk.datamodel.interfaces.TermedDocument;
import org.wikidata.wdtk.datamodel.json.jackson.AliasesDeserializer;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonItemDocument;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonMonolingualTextValue;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonPropertyDocument;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonStatement;
import org.wikidata.wdtk.datamodel.json.jackson.StatementGroupFromJson;
import org.wikidata.wdtk.util.NestedIterator;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=JacksonItemDocument.class, name="item"), @JsonSubTypes.Type(value=JacksonPropertyDocument.class, name="property")})
public abstract class JacksonTermedStatementDocument
implements TermedDocument,
StatementDocument {
    public static final String JSON_TYPE_ITEM = "item";
    public static final String JSON_TYPE_PROPERTY = "property";
    @JsonDeserialize(using=AliasesDeserializer.class)
    protected Map<String, List<JacksonMonolingualTextValue>> aliases = new HashMap<String, List<JacksonMonolingualTextValue>>();
    protected Map<String, JacksonMonolingualTextValue> labels = new HashMap<String, JacksonMonolingualTextValue>();
    protected Map<String, JacksonMonolingualTextValue> descriptions = new HashMap<String, JacksonMonolingualTextValue>();
    private Map<String, List<JacksonStatement>> claims = new HashMap<String, List<JacksonStatement>>();
    private List<StatementGroup> statementGroups = null;
    protected String entityId = "";
    @JsonIgnore
    protected String siteIri = null;

    public void setAliases(Map<String, List<JacksonMonolingualTextValue>> aliases) {
        this.aliases = aliases;
    }

    @Override
    public Map<String, List<MonolingualTextValue>> getAliases() {
        HashMap<String, List<JacksonMonolingualTextValue>> returnMap = new HashMap<String, List<JacksonMonolingualTextValue>>();
        for (Map.Entry<String, List<JacksonMonolingualTextValue>> entry : this.aliases.entrySet()) {
            returnMap.put(entry.getKey(), Collections.unmodifiableList(entry.getValue()));
        }
        return Collections.unmodifiableMap(returnMap);
    }

    public void setDescriptions(Map<String, JacksonMonolingualTextValue> descriptions) {
        this.descriptions = descriptions;
    }

    @Override
    public Map<String, MonolingualTextValue> getDescriptions() {
        return Collections.unmodifiableMap(this.descriptions);
    }

    public void setLabels(Map<String, JacksonMonolingualTextValue> labels) {
        this.labels = labels;
    }

    @Override
    public Map<String, MonolingualTextValue> getLabels() {
        return Collections.unmodifiableMap(this.labels);
    }

    @JsonProperty(value="id")
    public void setJsonId(String id) {
        this.entityId = id;
    }

    @JsonProperty(value="id")
    public String getJsonId() {
        return this.entityId;
    }

    @JsonIgnore
    public void setSiteIri(String siteIri) {
        this.siteIri = siteIri;
        EntityIdValue subject = this.getEntityId();
        for (Map.Entry<String, List<JacksonStatement>> entry : this.claims.entrySet()) {
            for (JacksonStatement statement : entry.getValue()) {
                statement.setSubject(subject);
            }
        }
    }

    @JsonIgnore
    public String getSiteIri() {
        return this.siteIri;
    }

    @Override
    @JsonIgnore
    public List<StatementGroup> getStatementGroups() {
        if (this.statementGroups == null) {
            this.statementGroups = new ArrayList<StatementGroup>(this.claims.size());
            for (List<JacksonStatement> statements : this.claims.values()) {
                this.statementGroups.add(new StatementGroupFromJson(statements));
            }
        }
        return this.statementGroups;
    }

    @JsonProperty(value="claims")
    public void setJsonClaims(Map<String, List<JacksonStatement>> claims) {
        this.claims = claims;
        this.statementGroups = null;
    }

    @JsonProperty(value="claims")
    public Map<String, List<JacksonStatement>> getJsonClaims() {
        return this.claims;
    }

    @Override
    @JsonIgnore
    public Iterator<Statement> getAllStatements() {
        return new NestedIterator(this.getStatementGroups());
    }
}

