/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.json.jackson;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.helpers.ToString;
import org.wikidata.wdtk.datamodel.interfaces.Claim;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.Reference;
import org.wikidata.wdtk.datamodel.interfaces.Statement;
import org.wikidata.wdtk.datamodel.interfaces.StatementRank;
import org.wikidata.wdtk.datamodel.json.jackson.ClaimFromJson;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonReference;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonSnak;
import org.wikidata.wdtk.datamodel.json.jackson.StatementRankDeserializer;
import org.wikidata.wdtk.datamodel.json.jackson.StatementRankSerializer;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class JacksonStatement
implements Statement {
    private String id;
    @JsonIgnore
    EntityIdValue subject = null;
    @JsonSerialize(using=StatementRankSerializer.class)
    @JsonDeserialize(using=StatementRankDeserializer.class)
    private StatementRank rank;
    private List<JacksonReference> references = new ArrayList<JacksonReference>();
    private JacksonSnak mainsnak;
    private Map<String, List<JacksonSnak>> qualifiers = new HashMap<String, List<JacksonSnak>>();
    private List<String> propertyOrder = Collections.emptyList();

    public JacksonStatement() {
    }

    public JacksonStatement(String id, JacksonSnak mainsnak) {
        this.id = id;
        this.rank = StatementRank.NORMAL;
        this.mainsnak = mainsnak;
    }

    @JsonProperty(value="type")
    public String getJsonType() {
        return "statement";
    }

    @JsonIgnore
    EntityIdValue getSubject() {
        if (this.subject == null) {
            throw new RuntimeException("Cannot retrieve subject for insufficiently initialised statement/claim.");
        }
        return this.subject;
    }

    @JsonIgnore
    void setSubject(EntityIdValue subject) {
        this.subject = subject;
        this.mainsnak.setSiteIri(subject.getSiteIri());
        for (List<JacksonSnak> snaks : this.qualifiers.values()) {
            for (JacksonSnak jacksonSnak : snaks) {
                jacksonSnak.setSiteIri(subject.getSiteIri());
            }
        }
        for (JacksonReference reference : this.references) {
            for (List list : reference.snaks.values()) {
                for (JacksonSnak snak : list) {
                    snak.setSiteIri(subject.getSiteIri());
                }
            }
        }
    }

    @Override
    @JsonIgnore
    public Claim getClaim() {
        return new ClaimFromJson(this);
    }

    @Override
    public StatementRank getRank() {
        return this.rank;
    }

    public void setRank(StatementRank rank) {
        this.rank = rank;
    }

    @Override
    public List<? extends Reference> getReferences() {
        return this.references;
    }

    public void setReferences(List<JacksonReference> references) {
        this.references = references;
    }

    @Override
    @JsonProperty(value="id")
    public String getStatementId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setStatementId(String id) {
        this.id = id;
    }

    public JacksonSnak getMainsnak() {
        return this.mainsnak;
    }

    public void setMainsnak(JacksonSnak mainsnak) {
        this.mainsnak = mainsnak;
    }

    public Map<String, List<JacksonSnak>> getQualifiers() {
        return this.qualifiers;
    }

    public void setQualifiers(Map<String, List<JacksonSnak>> qualifiers) {
        this.qualifiers = qualifiers;
    }

    @JsonProperty(value="qualifiers-order")
    public void setPropertyOrder(List<String> propertyOrder) {
        this.propertyOrder = propertyOrder;
    }

    @JsonProperty(value="qualifiers-order")
    public List<String> getPropertyOrder() {
        return this.propertyOrder;
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }

    public boolean equals(Object obj) {
        return Equality.equalsStatement(this, obj);
    }

    public String toString() {
        return ToString.toString(this);
    }
}

