/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.json.jackson;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.wikidata.wdtk.datamodel.helpers.Datamodel;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.helpers.ToString;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.ItemDocument;
import org.wikidata.wdtk.datamodel.interfaces.ItemIdValue;
import org.wikidata.wdtk.datamodel.interfaces.SiteLink;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonSiteLink;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonTermedStatementDocument;

@JsonIgnoreProperties(ignoreUnknown=true)
public class JacksonItemDocument
extends JacksonTermedStatementDocument
implements ItemDocument {
    private Map<String, JacksonSiteLink> sitelinks = new HashMap<String, JacksonSiteLink>();

    @Override
    @JsonIgnore
    public ItemIdValue getItemId() {
        if (this.siteIri == null) {
            return Datamodel.makeWikidataItemIdValue(this.entityId);
        }
        return Datamodel.makeItemIdValue(this.entityId, this.siteIri);
    }

    @Override
    @JsonIgnore
    public EntityIdValue getEntityId() {
        return this.getItemId();
    }

    @JsonProperty(value="sitelinks")
    public void setSiteLinks(Map<String, JacksonSiteLink> sitelinks) {
        this.sitelinks = sitelinks;
    }

    @Override
    @JsonProperty(value="sitelinks")
    public Map<String, SiteLink> getSiteLinks() {
        return Collections.unmodifiableMap(this.sitelinks);
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }

    public boolean equals(Object obj) {
        return Equality.equalsItemDocument(this, obj);
    }

    public String toString() {
        return ToString.toString(this);
    }
}

