/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.helpers.ToString;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.datamodel.interfaces.Snak;
import org.wikidata.wdtk.datamodel.interfaces.SnakGroup;

public class SnakGroupImpl
implements SnakGroup,
Serializable {
    private static final long serialVersionUID = -6497504020405854760L;
    final List<? extends Snak> snaks;

    SnakGroupImpl(List<? extends Snak> snaks) {
        Validate.notNull(snaks, (String)"List of statements cannot be null", (Object[])new Object[0]);
        Validate.notEmpty(snaks, (String)"List of statements cannot be empty", (Object[])new Object[0]);
        PropertyIdValue property = snaks.get(0).getPropertyId();
        for (Snak snak : snaks) {
            if (property.equals(snak.getPropertyId())) continue;
            throw new IllegalArgumentException("All snaks in a snak group must use the same property");
        }
        this.snaks = snaks;
    }

    @Override
    public List<Snak> getSnaks() {
        return Collections.unmodifiableList(this.snaks);
    }

    @Override
    public PropertyIdValue getProperty() {
        return this.snaks.get(0).getPropertyId();
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }

    public boolean equals(Object obj) {
        return Equality.equalsSnakGroup(this, obj);
    }

    public String toString() {
        return ToString.toString(this);
    }

    @Override
    public Iterator<Snak> iterator() {
        return this.snaks.iterator();
    }
}

