/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import org.wikidata.wdtk.datamodel.helpers.ToString;
import org.wikidata.wdtk.datamodel.implementation.NumericEntityIdValueImpl;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;

public class PropertyIdValueImpl
extends NumericEntityIdValueImpl
implements PropertyIdValue {
    private static final long serialVersionUID = 3427673190538556373L;

    public static PropertyIdValueImpl create(String id, String baseIri) {
        if (id == null || id.length() <= 1 || id.charAt(0) != 'P') {
            throw new IllegalArgumentException("Wikibase property ids must have the form \"P<positive integer>\". Given id was \"" + id + "\"");
        }
        try {
            int numId = new Integer(id.substring(1));
            return new PropertyIdValueImpl(numId, baseIri);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Wikibase property ids must have the form \"P<positive integer>\". Given id was \"" + id + "\"");
        }
    }

    private PropertyIdValueImpl(int id, String baseIri) {
        super(id, baseIri);
    }

    @Override
    public String getEntityType() {
        return "http://www.wikidata.org/ontology#Property";
    }

    public String toString() {
        return ToString.toString(this);
    }

    @Override
    public String getId() {
        return "P" + this.id;
    }
}

