/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.helpers.ToString;
import org.wikidata.wdtk.datamodel.implementation.TermedStatementDocumentImpl;
import org.wikidata.wdtk.datamodel.interfaces.DatatypeIdValue;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.MonolingualTextValue;
import org.wikidata.wdtk.datamodel.interfaces.PropertyDocument;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.datamodel.interfaces.StatementGroup;

public class PropertyDocumentImpl
extends TermedStatementDocumentImpl
implements PropertyDocument,
Serializable {
    private static final long serialVersionUID = 3202706015471781558L;
    final PropertyIdValue propertyId;
    final DatatypeIdValue datatypeId;

    PropertyDocumentImpl(PropertyIdValue propertyId, List<MonolingualTextValue> labels, List<MonolingualTextValue> descriptions, List<MonolingualTextValue> aliases, List<StatementGroup> statementGroups, DatatypeIdValue datatypeId) {
        super(propertyId, labels, descriptions, aliases, statementGroups);
        Validate.notNull((Object)propertyId, (String)"property ID cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)datatypeId, (String)"datatype ID cannot be null", (Object[])new Object[0]);
        this.propertyId = propertyId;
        this.datatypeId = datatypeId;
    }

    @Override
    public EntityIdValue getEntityId() {
        return this.propertyId;
    }

    @Override
    public PropertyIdValue getPropertyId() {
        return this.propertyId;
    }

    @Override
    public DatatypeIdValue getDatatype() {
        return this.datatypeId;
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }

    public boolean equals(Object obj) {
        return Equality.equalsPropertyDocument(this, obj);
    }

    public String toString() {
        return ToString.toString(this);
    }
}

