/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import java.io.Serializable;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.helpers.ToString;
import org.wikidata.wdtk.datamodel.interfaces.MonolingualTextValue;
import org.wikidata.wdtk.datamodel.interfaces.ValueVisitor;

public class MonolingualTextValueImpl
implements MonolingualTextValue,
Serializable {
    private static final long serialVersionUID = -6165541960096088292L;
    final String text;
    final String languageCode;

    MonolingualTextValueImpl(String text, String languageCode) {
        Validate.notNull((Object)text, (String)"Text cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)languageCode, (String)"Language code cannot be null", (Object[])new Object[0]);
        this.text = text;
        this.languageCode = languageCode;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public String getLanguageCode() {
        return this.languageCode;
    }

    @Override
    public <T> T accept(ValueVisitor<T> valueVisitor) {
        return valueVisitor.visit(this);
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }

    public boolean equals(Object obj) {
        return Equality.equalsMonolingualTextValue(this, obj);
    }

    public String toString() {
        return ToString.toString(this);
    }
}

