/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.helpers.ToString;
import org.wikidata.wdtk.datamodel.interfaces.Claim;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.Snak;
import org.wikidata.wdtk.datamodel.interfaces.SnakGroup;
import org.wikidata.wdtk.util.NestedIterator;

public class ClaimImpl
implements Claim,
Serializable {
    private static final long serialVersionUID = -2991778567647082844L;
    final EntityIdValue subject;
    final Snak mainSnak;
    final List<SnakGroup> qualifiers;

    ClaimImpl(EntityIdValue subject, Snak mainSnak, List<SnakGroup> qualifiers) {
        Validate.notNull((Object)subject, (String)"Statement subjects cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)mainSnak, (String)"Statement main Snaks cannot be null", (Object[])new Object[0]);
        Validate.notNull(qualifiers, (String)"Statement qualifier groups cannot be null", (Object[])new Object[0]);
        this.subject = subject;
        this.mainSnak = mainSnak;
        this.qualifiers = qualifiers;
    }

    @Override
    public EntityIdValue getSubject() {
        return this.subject;
    }

    @Override
    public Snak getMainSnak() {
        return this.mainSnak;
    }

    @Override
    public List<SnakGroup> getQualifiers() {
        return Collections.unmodifiableList(this.qualifiers);
    }

    @Override
    public Iterator<Snak> getAllQualifiers() {
        return new NestedIterator(this.qualifiers);
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }

    public boolean equals(Object obj) {
        return Equality.equalsClaim(this, obj);
    }

    public String toString() {
        return ToString.toString(this);
    }
}

