/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.helpers;

import java.text.DecimalFormat;
import java.util.TreeSet;
import org.wikidata.wdtk.datamodel.interfaces.Claim;
import org.wikidata.wdtk.datamodel.interfaces.DatatypeIdValue;
import org.wikidata.wdtk.datamodel.interfaces.GlobeCoordinatesValue;
import org.wikidata.wdtk.datamodel.interfaces.ItemDocument;
import org.wikidata.wdtk.datamodel.interfaces.ItemIdValue;
import org.wikidata.wdtk.datamodel.interfaces.MonolingualTextValue;
import org.wikidata.wdtk.datamodel.interfaces.NoValueSnak;
import org.wikidata.wdtk.datamodel.interfaces.PropertyDocument;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.datamodel.interfaces.QuantityValue;
import org.wikidata.wdtk.datamodel.interfaces.Reference;
import org.wikidata.wdtk.datamodel.interfaces.SiteLink;
import org.wikidata.wdtk.datamodel.interfaces.Snak;
import org.wikidata.wdtk.datamodel.interfaces.SnakGroup;
import org.wikidata.wdtk.datamodel.interfaces.SomeValueSnak;
import org.wikidata.wdtk.datamodel.interfaces.Statement;
import org.wikidata.wdtk.datamodel.interfaces.StatementDocument;
import org.wikidata.wdtk.datamodel.interfaces.StatementGroup;
import org.wikidata.wdtk.datamodel.interfaces.StatementRank;
import org.wikidata.wdtk.datamodel.interfaces.StringValue;
import org.wikidata.wdtk.datamodel.interfaces.TermedDocument;
import org.wikidata.wdtk.datamodel.interfaces.TimeValue;
import org.wikidata.wdtk.datamodel.interfaces.ValueSnak;

public class ToString {
    public static String toString(ItemIdValue o) {
        return o.getIri() + " (item)";
    }

    public static String toString(PropertyIdValue o) {
        return o.getIri() + " (property)";
    }

    public static String toString(DatatypeIdValue o) {
        return o.getIri();
    }

    public static String toString(TimeValue o) {
        DecimalFormat timeForm = new DecimalFormat("00");
        return o.getYear() + "-" + timeForm.format(o.getMonth()) + "-" + timeForm.format(o.getDay()) + (o.getPrecision() > 11 || o.getHour() + o.getMinute() + o.getSecond() > 0 ? "T" + timeForm.format(o.getHour()) + ":" + timeForm.format(o.getMinute()) + ":" + timeForm.format(o.getSecond()) : "") + " (Prec.: " + ToString.getTimePrecisionString(o.getPrecision()) + " [-" + o.getBeforeTolerance() + " .. +" + o.getAfterTolerance() + "]" + ", PCal: " + ToString.getCalendarString(o.getPreferredCalendarModel()) + (o.getTimezoneOffset() != 0 ? ", Timezone: " + o.getTimezoneOffset() + "min " : "") + ")";
    }

    public static String toString(GlobeCoordinatesValue o) {
        return o.getLatitude() / 1.0 + ":" + o.getLongitude() / 1.0 + " (" + ToString.getGlobeString(o.getGlobe()) + ")";
    }

    public static String toString(StringValue o) {
        return "\"" + o.getString().replace("\"", "\\\"") + "\"";
    }

    public static String toString(MonolingualTextValue o) {
        return "\"" + o.getText().replace("\"", "\\\"") + "\" (" + o.getLanguageCode() + ")";
    }

    public static String toString(QuantityValue o) {
        return o.getNumericValue().toString() + " [" + o.getLowerBound().toString() + " .. " + o.getUpperBound().toString() + "]";
    }

    public static String toString(ValueSnak o) {
        return o.getPropertyId().getIri() + " :: " + o.getValue().toString();
    }

    public static String toString(SomeValueSnak o) {
        return o.getPropertyId().getIri() + " has some value";
    }

    public static String toString(NoValueSnak o) {
        return o.getPropertyId().getIri() + " has no value";
    }

    public static String toString(SnakGroup o) {
        String indent = "      ";
        String result = null;
        for (Snak s : o.getSnaks()) {
            if (result == null) {
                result = "      " + s.toString() + "\n";
                continue;
            }
            result = result + "      " + s.toString() + "\n";
        }
        return result;
    }

    public static String toString(Claim o) {
        StringBuilder sb = new StringBuilder();
        sb.append(o.getSubject()).append(": ");
        sb.append(o.getMainSnak().toString()).append("\n");
        for (SnakGroup s : o.getQualifiers()) {
            sb.append(ToString.toString(s));
        }
        return sb.toString();
    }

    public static String toString(Reference o) {
        StringBuilder sb = new StringBuilder();
        sb.append("  Reference:\n");
        for (SnakGroup s : o.getSnakGroups()) {
            sb.append(ToString.toString(s));
        }
        return sb.toString();
    }

    public static String toString(Statement o) {
        StringBuilder sb = new StringBuilder();
        sb.append(ToString.toString(o.getClaim()));
        if (o.getRank() != StatementRank.NORMAL) {
            sb.append("  Rank: ").append((Object)o.getRank()).append("\n");
        }
        for (Reference reference : o.getReferences()) {
            sb.append(ToString.toString(reference));
        }
        return sb.toString();
    }

    public static String toString(StatementGroup o) {
        StringBuilder sb = new StringBuilder();
        for (Statement s : o.getStatements()) {
            sb.append(ToString.toString(s));
        }
        return sb.toString();
    }

    public static String toString(SiteLink o) {
        if (o.getBadges().isEmpty()) {
            return o.getSiteKey() + "/" + o.getPageTitle();
        }
        return o.getSiteKey() + "/" + o.getPageTitle() + " " + o.getBadges();
    }

    public static String toString(PropertyDocument o) {
        return "==PropertyDocument " + o.getPropertyId().getIri() + "==\n" + "* Datatype: " + o.getDatatype() + ToString.toStringForTermedDocument(o) + ToString.toStringForStatementDocument(o);
    }

    public static String toString(ItemDocument o) {
        StringBuilder sb = new StringBuilder();
        sb.append("==ItemDocument ").append(o.getItemId().getIri());
        sb.append("==").append(ToString.toStringForTermedDocument(o));
        sb.append(ToString.toStringForStatementDocument(o));
        sb.append("* Site links: ");
        boolean first = true;
        TreeSet<String> siteKeys = new TreeSet<String>(o.getSiteLinks().keySet());
        for (String key : siteKeys) {
            if (first) {
                first = false;
            } else {
                sb.append("; ");
            }
            sb.append(ToString.toString(o.getSiteLinks().get(key)));
        }
        return sb.toString();
    }

    protected static String toStringForStatementDocument(StatementDocument o) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n===Statements===\n");
        for (StatementGroup sg : o.getStatementGroups()) {
            sb.append(ToString.toString(sg));
        }
        sb.append("\n===End of statements===\n");
        return sb.toString();
    }

    protected static String toStringForTermedDocument(TermedDocument o) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n* Labels: ");
        boolean first = true;
        TreeSet<String> labelKeys = new TreeSet<String>(o.getLabels().keySet());
        for (String key : labelKeys) {
            if (first) {
                first = false;
            } else {
                sb.append("; ");
            }
            sb.append(ToString.toString(o.getLabels().get(key)));
        }
        sb.append("\n* Descriptions: ");
        first = true;
        TreeSet<String> descriptionKeys = new TreeSet<String>(o.getDescriptions().keySet());
        for (String key : descriptionKeys) {
            if (first) {
                first = false;
            } else {
                sb.append("; ");
            }
            sb.append(ToString.toString(o.getDescriptions().get(key)));
        }
        sb.append("\n* Aliases: ");
        first = true;
        TreeSet<String> aliasKeys = new TreeSet<String>(o.getAliases().keySet());
        for (String key : aliasKeys) {
            for (MonolingualTextValue mtv : o.getAliases().get(key)) {
                if (first) {
                    first = false;
                } else {
                    sb.append("; ");
                }
                sb.append(ToString.toString(mtv));
            }
        }
        return sb.toString();
    }

    protected static String getGlobeString(String globeIri) {
        switch (globeIri) {
            case "http://www.wikidata.org/entity/Q2": {
                return "Earth";
            }
        }
        return globeIri;
    }

    protected static String getCalendarString(String calendarModel) {
        switch (calendarModel) {
            case "http://www.wikidata.org/entity/Q1985727": {
                return "Gregorian";
            }
            case "http://www.wikidata.org/entity/Q1985786": {
                return "Julian";
            }
        }
        return calendarModel;
    }

    protected static String getTimePrecisionString(byte precision) {
        switch (precision) {
            case 14: {
                return "sec";
            }
            case 13: {
                return "min";
            }
            case 12: {
                return "hour";
            }
            case 11: {
                return "day";
            }
            case 10: {
                return "month";
            }
            case 9: {
                return "year";
            }
            case 8: {
                return "decade";
            }
            case 7: {
                return "100 years";
            }
            case 6: {
                return "1000 years";
            }
            case 5: {
                return "10K years";
            }
            case 4: {
                return "100K years";
            }
            case 3: {
                return "1 million years";
            }
            case 2: {
                return "10 million years";
            }
            case 1: {
                return "100 million years";
            }
            case 0: {
                return "1000 million years";
            }
        }
        return "Unsupported precision " + precision;
    }
}

