/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.helpers;

import org.wikidata.wdtk.datamodel.interfaces.Claim;
import org.wikidata.wdtk.datamodel.interfaces.DatatypeIdValue;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.GlobeCoordinatesValue;
import org.wikidata.wdtk.datamodel.interfaces.ItemDocument;
import org.wikidata.wdtk.datamodel.interfaces.MonolingualTextValue;
import org.wikidata.wdtk.datamodel.interfaces.NoValueSnak;
import org.wikidata.wdtk.datamodel.interfaces.PropertyDocument;
import org.wikidata.wdtk.datamodel.interfaces.QuantityValue;
import org.wikidata.wdtk.datamodel.interfaces.Reference;
import org.wikidata.wdtk.datamodel.interfaces.SiteLink;
import org.wikidata.wdtk.datamodel.interfaces.SnakGroup;
import org.wikidata.wdtk.datamodel.interfaces.SomeValueSnak;
import org.wikidata.wdtk.datamodel.interfaces.Statement;
import org.wikidata.wdtk.datamodel.interfaces.StatementGroup;
import org.wikidata.wdtk.datamodel.interfaces.StringValue;
import org.wikidata.wdtk.datamodel.interfaces.TermedDocument;
import org.wikidata.wdtk.datamodel.interfaces.TimeValue;
import org.wikidata.wdtk.datamodel.interfaces.ValueSnak;

public class Hash {
    static final int prime = 31;

    public static int hashCode(EntityIdValue o) {
        int result = o.getId().hashCode();
        result = 31 * result + o.getSiteIri().hashCode();
        result = 31 * result + o.getEntityType().hashCode();
        return result;
    }

    public static int hashCode(DatatypeIdValue o) {
        return o.getIri().hashCode();
    }

    public static int hashCode(TimeValue o) {
        int result = new Long(o.getYear()).hashCode();
        result = 31 * result + o.getMonth();
        result = 31 * result + o.getDay();
        result = 31 * result + o.getHour();
        result = 31 * result + o.getMinute();
        result = 31 * result + o.getSecond();
        result = 31 * result + o.getPrecision();
        result = 31 * result + o.getBeforeTolerance();
        result = 31 * result + o.getAfterTolerance();
        result = 31 * result + o.getTimezoneOffset();
        result = 31 * result + o.getPreferredCalendarModel().hashCode();
        return result;
    }

    public static int hashCode(GlobeCoordinatesValue o) {
        int result = o.getGlobe().hashCode();
        long value = Double.valueOf(o.getLatitude()).hashCode();
        result = 31 * result + (int)(value ^ value >>> 32);
        value = Double.valueOf(o.getLongitude()).hashCode();
        result = 31 * result + (int)(value ^ value >>> 32);
        value = Double.valueOf(o.getPrecision()).hashCode();
        result = 31 * result + (int)(value ^ value >>> 32);
        return result;
    }

    public static int hashCode(StringValue o) {
        return o.getString().hashCode();
    }

    public static int hashCode(MonolingualTextValue o) {
        int result = o.getLanguageCode().hashCode();
        result = 31 * result + o.getText().hashCode();
        return result;
    }

    public static int hashCode(QuantityValue o) {
        int result = o.getNumericValue().hashCode();
        result = 31 * result + o.getLowerBound().hashCode();
        result = 31 * result + o.getUpperBound().hashCode();
        return result;
    }

    public static int hashCode(ValueSnak o) {
        int result = o.getValue().hashCode();
        result = 31 * result + o.getPropertyId().hashCode();
        return result;
    }

    public static int hashCode(SomeValueSnak o) {
        return o.getPropertyId().hashCode();
    }

    public static int hashCode(NoValueSnak o) {
        return o.getPropertyId().hashCode();
    }

    public static int hashCode(SnakGroup o) {
        return o.getSnaks().hashCode();
    }

    public static int hashCode(Claim o) {
        int result = o.getSubject().hashCode();
        result = 31 * result + o.getMainSnak().hashCode();
        result = 31 * result + o.getQualifiers().hashCode();
        return result;
    }

    public static int hashCode(Reference o) {
        return o.getSnakGroups().hashCode();
    }

    public static int hashCode(Statement o) {
        int result = o.getClaim().hashCode();
        result = 31 * result + o.getReferences().hashCode();
        result = 31 * result + o.getRank().hashCode();
        result = 31 * result + o.getStatementId().hashCode();
        return result;
    }

    public static int hashCode(StatementGroup o) {
        return o.getStatements().hashCode();
    }

    public static int hashCode(SiteLink o) {
        int result = o.getBadges().hashCode();
        result = 31 * result + o.getPageTitle().hashCode();
        result = 31 * result + o.getSiteKey().hashCode();
        return result;
    }

    public static int hashCode(PropertyDocument o) {
        int result = Hash.hashCodeForTermedDocument(o);
        result = 31 * result + o.getStatementGroups().hashCode();
        result = 31 * result + o.getDatatype().hashCode();
        return result;
    }

    public static int hashCode(ItemDocument o) {
        int result = Hash.hashCodeForTermedDocument(o);
        result = 31 * result + o.getStatementGroups().hashCode();
        result = 31 * result + o.getSiteLinks().hashCode();
        return result;
    }

    protected static int hashCodeForTermedDocument(TermedDocument o) {
        int result = o.getAliases().hashCode();
        result = 31 * result + o.getDescriptions().hashCode();
        result = 31 * result + o.getLabels().hashCode();
        return result;
    }
}

