/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.json.jackson.datavalues;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.helpers.ToString;
import org.wikidata.wdtk.datamodel.interfaces.TimeValue;
import org.wikidata.wdtk.datamodel.interfaces.ValueVisitor;
import org.wikidata.wdtk.datamodel.json.jackson.datavalues.JacksonInnerTime;
import org.wikidata.wdtk.datamodel.json.jackson.datavalues.JacksonValue;

@JsonIgnoreProperties(ignoreUnknown=true)
public class JacksonValueTime
extends JacksonValue
implements TimeValue {
    private JacksonInnerTime value;

    public JacksonValueTime() {
        super("time");
    }

    public JacksonInnerTime getValue() {
        return this.value;
    }

    public void setValue(JacksonInnerTime value) {
        this.value = value;
    }

    @Override
    @JsonIgnore
    public long getYear() {
        return this.value.getYear();
    }

    @Override
    @JsonIgnore
    public byte getMonth() {
        return this.value.getMonth();
    }

    @Override
    @JsonIgnore
    public byte getDay() {
        return this.value.getDay();
    }

    @Override
    @JsonIgnore
    public byte getHour() {
        return this.value.getHour();
    }

    @Override
    @JsonIgnore
    public byte getMinute() {
        return this.value.getMinute();
    }

    @Override
    @JsonIgnore
    public byte getSecond() {
        return this.value.getSecond();
    }

    @Override
    @JsonIgnore
    public String getPreferredCalendarModel() {
        return this.value.getCalendarmodel();
    }

    @Override
    @JsonIgnore
    public byte getPrecision() {
        return (byte)this.value.getPrecision();
    }

    @Override
    @JsonIgnore
    public int getTimezoneOffset() {
        return this.value.getTimezone();
    }

    @Override
    @JsonIgnore
    public int getBeforeTolerance() {
        return this.value.getBefore();
    }

    @Override
    @JsonIgnore
    public int getAfterTolerance() {
        return this.value.getAfter();
    }

    @Override
    public <T> T accept(ValueVisitor<T> valueVisitor) {
        return valueVisitor.visit(this);
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }

    public boolean equals(Object obj) {
        return Equality.equalsTimeValue(this, obj);
    }

    public String toString() {
        return ToString.toString(this);
    }
}

