/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.json.jackson.datavalues;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.math.BigDecimal;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.helpers.ToString;
import org.wikidata.wdtk.datamodel.interfaces.QuantityValue;
import org.wikidata.wdtk.datamodel.interfaces.ValueVisitor;
import org.wikidata.wdtk.datamodel.json.jackson.datavalues.JacksonInnerQuantity;
import org.wikidata.wdtk.datamodel.json.jackson.datavalues.JacksonValue;

@JsonIgnoreProperties(ignoreUnknown=true)
public class JacksonValueQuantity
extends JacksonValue
implements QuantityValue {
    private JacksonInnerQuantity value;

    public JacksonValueQuantity() {
        super("quantity");
    }

    public void setValue(JacksonInnerQuantity value) {
        this.value = value;
    }

    public JacksonInnerQuantity getValue() {
        return this.value;
    }

    @Override
    @JsonIgnore
    public BigDecimal getNumericValue() {
        return this.value.getAmount();
    }

    @Override
    @JsonIgnore
    public BigDecimal getLowerBound() {
        return this.value.getLowerBound();
    }

    @Override
    @JsonIgnore
    public BigDecimal getUpperBound() {
        return this.value.getUpperBound();
    }

    @Override
    public <T> T accept(ValueVisitor<T> valueVisitor) {
        return valueVisitor.visit(this);
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }

    public boolean equals(Object obj) {
        return Equality.equalsQuantityValue(this, obj);
    }

    public String toString() {
        return ToString.toString(this);
    }
}

